

#define		BYTE	unsigned char
#define		WORD	unsigned short


#include "REG_MG82FG5A64.H"
#include "delay.H"


#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

union WTYPE
  { BYTE B[2];
    WORD W;
  };

union WTYPE Ch3_PWM_Duty;
union WTYPE Ch4_PWM_Duty;
union WTYPE Ch5_PWM_Duty;

void main(void)
{
	CCAPM3 = ECOM0 | PWM0;						//set 8bit PWM
	CCAPM4 = ECOM0 | PWM0;						//set 8bit PWM
	CCAPM5 = ECOM0 | PWM0;						//set 8bit PWM
	CMOD = CPS0;								//CPS1 ~ CPS0 = 0, 1. (sysclk) / 2
	CR = 1;										//PCA run, 12MHz / 256 / 2 = 23.4KHz.
	P2M0 = 0xE0;

	Ch3_PWM_Duty.W = 0x40;
	CCAP3H = Ch3_PWM_Duty.B[1];
	Ch4_PWM_Duty.W = 0x80;
	CCAP4H = Ch4_PWM_Duty.B[1];
	Ch5_PWM_Duty.W = 0xC0;
	CCAP5H = Ch5_PWM_Duty.B[1];


	while(1)
	{
		if(P36 == 0)
		{
			if(Ch3_PWM_Duty.W < 0x100)
				Ch3_PWM_Duty.W ++;

			if(Ch4_PWM_Duty.W < 0x100)
				Ch4_PWM_Duty.W ++;

			if(Ch5_PWM_Duty.W < 0x100)
				Ch5_PWM_Duty.W ++;

			delay_ms(10);
		}
		if(P37 == 0)
		{
			if(Ch3_PWM_Duty.W)
				Ch3_PWM_Duty.W --;

			if(Ch4_PWM_Duty.W)
				Ch4_PWM_Duty.W --;

			if(Ch5_PWM_Duty.W)
				Ch5_PWM_Duty.W --;

			delay_ms(10);
		}
		
		if(Ch3_PWM_Duty.B[0])
			PCAPWM3 |= ECAP3H;			//ECAP3H
		else
			PCAPWM3 &= ~ECAP3H;
		
		if(Ch4_PWM_Duty.B[0])
			PCAPWM4 |= ECAP4H;			//ECAP4H
		else
			PCAPWM4 &= ~ECAP4H;
		
		if(Ch5_PWM_Duty.B[0])
			PCAPWM5 |= ECAP5H;			//ECAP5H
		else
			PCAPWM5 &= ~ECAP5H;

		CCAP3H = Ch3_PWM_Duty.B[1];
		CCAP4H = Ch4_PWM_Duty.B[1];
		CCAP5H = Ch5_PWM_Duty.B[1];
	}
}
