/**
 * @file    comp_polling.c
 * @author  MegawinTech Application Team
 * @version V1.0.0
 * @date    01-October-2024
 * @brief   This file contains all the system functions 
 */

/* Define to prevent recursive inclusion */
#define _COMP_POLLING_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "comp_polling.h"

/**
  * @addtogroup MDF101A_LibSamples
  * @{
  */

/**
  * @addtogroup COMP
  * @{
  */

/**
  * @addtogroup COMP_Polling
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_Configure(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    COMP_InitTypeDef COMP_InitStruct;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_COMP, ENABLE);

    COMP_StructInit(&COMP_InitStruct);
    COMP_InitStruct.COMP_Invert     = COMP_InvertingInput_0;
    COMP_InitStruct.COMP_NonInvert  = COMP_NonInvertingInput_0;
    COMP_InitStruct.COMP_Output     = COMP_Output_None;
    COMP_InitStruct.COMP_OutputPol  = COMP_Pol_NonInvertedOut;
    COMP_InitStruct.COMP_Hysteresis = COMP_Hysteresis_No;
    COMP_InitStruct.COMP_Mode       = COMP_Mode_LowPower;
    COMP_InitStruct.COMP_OFLT       = COMP_Filter_4_Period;
    COMP_Init(COMP1, &COMP_InitStruct);

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_3 | GPIO_Pin_4;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    COMP_Cmd(COMP1, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void COMP_Polling_Sample(void)
{
    uint32_t OldLevel = 0, NewLevel = 0;

    printf("\r\nTest %s", __FUNCTION__);

    COMP_Configure();

    printf("\r\nTurn around RV2 or RV3, adjust the comparator channel voltage.");

    while (1)
    {
        NewLevel = COMP_GetOutputLevel(COMP1);

        if (OldLevel != NewLevel)
        {
            OldLevel = NewLevel;

            printf("\r\nCOMP GetOutputLevel : %d", NewLevel);
        }

        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */



