#ifndef OCP_H
#define OCP_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set OCP
// <o.2..4> I_LIMIT <0=> 0.15V <1=> 0.2V <2=> 0.25V <3=> 0.3V <4=> 0.35V <5=> 0.4V <6=> 0.45V <7=> 0.5V
#define AOCPCONT_REGS 0x17

// <o.0..2> I_SHORT <0=> 0.15V <1=> 0.2V <2=> 0.25V <3=> 0.3V <4=> 0.35V <5=> 0.4V <6=> 0.45V <7=> 0.5V
#define I_SHORT_REGS 0x07
// </h>


// <h> Set OCPCONT
// <o.0> OCPMS <0=> Auto Mode <1=> User Mode 
// <o.2..6> OCPDBT <1-31>
// <i> OCPN input de-bounce time (default 41.67nS) 
// <i> 0~31 = 0~1.291uS (48MHz/2 fixed)
#define OCPCONT_REGS 0x7C 
// </h>

// <o.1> Set AOCPS <0=> Digital OCP <1=> Analog OCP
#define AOCPS 0x02

// <<< end of configuration section >>>

// OCPCONT
#define OCPST 0x80 // OCP Short status
#define OCPDBT 0x1F<<6 // Analog OCP input de-bounce time (0 ~ 31) = (0 ~ 1.291us)
#define OCPC 0x02 // OCP status clear
#define OCPMS 0x01// User Mode

#define MPWMEN 0x80
extern void OCP_Init (void);
#endif