#ifndef RTW_HEADER_Subsystem_h_
#define RTW_HEADER_Subsystem_h_

#ifdef DUTY_CONTROL
#define OUTPUT_TABLE_0 AMP_MIN
#define INPUT_TABLE_0  CMD_START_VAL
#endif

#ifdef SPEEDLOOP_CONTROL
#define OUTPUT_TABLE_0 SPEED_MIN
#define INPUT_TABLE_0  CMD_START_VAL
#endif

#ifdef CURRENTLOOP_CONTROL
#define OUTPUT_TABLE_0 IBUS_MIN*1000/dAMP_PER_CONSTANT
#define INPUT_TABLE_0  CMD_START_VAL
#endif

#define MAX_TABLE_NUMBER 7

// <<< Use Configuration Wizard in Context Menu >>>
//<e> LookupTable_EN Enable/Disable
#define LookupTable_EN 0
// <o0> Output : LookupTable_Data[1]
// <o1> Output : LookupTable_Data[2]
// <o2> Output : LookupTable_Data[3]
// <o3> Output : LookupTable_Data[4]
// <o4> Output : LookupTable_Data[5]
// <o5> Output : LookupTable_Data[6]
// <o6> Input  : Vsp_Data[1] (unit : Vsp_Val)
// <o7> Input  : Vsp_Data[2] (unit : Vsp_Val)
// <o8> Input  : Vsp_Data[3] (unit : Vsp_Val)
// <o9> Input  : Vsp_Data[4] (unit : Vsp_Val)
// <o10> Input  : Vsp_Data[5] (unit : Vsp_Val)
// <o11> Input  : Vsp_Data[6] (unit : Vsp_Val)
#define LOOKUPTABLE_DEFAULTS { \
  { OUTPUT_TABLE_0, 300, 530, 780, 995, 1210,1640}, \
  { INPUT_TABLE_0,  515, 565, 655, 706, 770,921} \
}

typedef struct {
  int uDLookupTable_tableData[MAX_TABLE_NUMBER];
  int uDLookupTable_bp01Data[MAX_TABLE_NUMBER];
} ConstP;

// <<< end of configuration section >>>


extern int look1_binlx(int u0, const int bp0[], const int table[], unsigned char maxIndex);
#endif                                 /* RTW_HEADER_Subsystem_h_ */
