#ifndef CAPTURE_H
#define CAPTURE_H

#define	CAPPINSEL	0x10

// <<< Use Configuration Wizard in Context Menu >>>

// <h> CAPCONT tm
	// <o> CAP_RANGE <0=> 184Hz-120000Hz <1=> 92Hz-60000Hz <2=> 46Hz-30000Hz <3=> 23Hz-15000Hz <4=> 12Hz-7500Hz <5=> 6Hz-3750Hz <6=> 3Hz-1875Hz <7=> 2Hz-938Hz
	#define	CAP_RANGE	(0)				
	#if (CAP_RANGE == 0)
		#define	PWM_RANGE1	
		#define CAPCKS 								(4)
	#elif (CAP_RANGE == 1)
		#define	PWM_RANGE2	
		#define CAPCKS 								(8)
	#elif (CAP_RANGE == 2)
		#define	PWM_RANGE3
		#define CAPCKS 								(16)
	#elif (CAP_RANGE == 3)
		#define	PWM_RANGE4	
		#define CAPCKS 								(32)
	#elif (CAP_RANGE == 4)
		#define	PWM_RANGE5	
		#define CAPCKS 								(64)
	#elif (CAP_RANGE == 5)
		#define	PWM_RANGE6	
		#define CAPCKS 								(128)
	#elif (CAP_RANGE == 6)
		#define	PWM_RANGE7
		#define CAPCKS 								(256)
	#elif (CAP_RANGE == 7)
		#define	PWM_RANGE8	
		#define CAPCKS 								(512)
	#endif
	
	// <o.4> CAPPINSEL <0=> CAP2/P2.7 <1=> CAP1/P1.6
	// <o.6> CAP_EN <0=> Disable <1=> Enable 
		#define CAPCONT_REGS 0xD7
// </h>
// <<< end of configuration section >>>

	#if((CAPCONT_REGS & CAPPINSEL) == 0x10)
		#define	CAP1 (P1_6)
	#elif((CAPCONT_REGS & CAPPINSEL) == 0x00)
		#define	CAP1 (P2_7)
	#endif

	



	// #if ((CAPCONT_REGS & 0x07) == 0x00)
		// #define SPEED_VALUE ((((uint32)48000000/4)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x01)
		// #define SPEED_VALUE ((((uint32)48000000/8)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x02)
		// #define SPEED_VALUE ((((uint32)48000000/16)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x03)
		// #define SPEED_VALUE ((((uint32)48000000/32)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x04)
		// #define SPEED_VALUE ((((uint32)48000000/64)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x05)
		// #define SPEED_VALUE ((((uint32)48000000/128)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x06)
		// #define SPEED_VALUE ((((uint32)48000000/256)*60))
	// #endif
	
	// #if ((CAPCONT_REGS & 0x07) == 0x07)
		// #define SPEED_VALUE ((uint32)((float)93750 * 120 * 32768/(POLE)/(BASE_RPM)))
		// #define FREQ_VALUE ((uint32)2298000) //24.512 * 48000000/512
	// #endif


	extern void CAP_Init (void);
#endif