//********************************************************************************
//Project Name : Sensor Source Code
//Date : 2024.9.10
//MCU : CGH0X1A
//Others : Sensor ; Pole Pairs

//Ru-v = R 	 / Rv-w = R   / Ru-w = R
//Lu-v = uH / Lv-w = uH / Lu-w = uH
//********************************************************************************
//								      MEMO
//********************************************************************************
//Oct. 23, 2024 Reviced(V0.0) : CGH0X1A Version.
//Dec. 23, 2024 Reviced(V1.0) : CGH0X1A Version.
//Mar. 04, 2025 Reviced(V2.0) : CGH0X1A Version.
/*

*/                       
//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//datawqܶqbe128r`]0x00~0x7F^a}Ŷ
//idatawqܶqb]0x00~0xFF^a}Ŷ
//xdatawqܶqhObW~XiRAMŶ]@~0xF000~0xF0FFŶAŶjp]ӲAS~RAM^

//datawqܶqt׳̧֡AidataAxdatae̺C
//`QϥΪܼƥdata/idataŧi; `ϥΪܼƥxdataŧi.
//LSOŧiܼơAw]Odata

//Define Forward Hall Sequence 
//code unsigned char	HALL_TABLE_FRD[] = {6, 4, 5, 1, 3, 2};  //24V߮; Test Board
code unsigned char	HALL_TABLE_FRD[] = {3, 1, 5, 4, 6, 2};  //24V߮
//code unsigned char	HALL_TABLE_FRD[] = {1, 3, 7, 6, 4, 0};	//12V߮
//Define Reverse Hall Sequence   
//code unsigned char	HALL_TABLE_REV[] = {6, 4, 5, 1, 3, 2};  //24V߮; Test Board
code unsigned char	HALL_TABLE_REV[] = {3, 1, 5, 4, 6, 2};
unsigned char		HALL_TABLE[6];
code unsigned char	HALL_TABLE_ERROR_STATUS[] = {0, 7}; //24V߮
//code unsigned char	HALL_TABLE_ERROR_STATUS[] = {0x02, 0x05}; 	//12V߮


xdata unsigned char	Error_Code  = 0;
bit	Flag_OCP                    = 0;
bit	Flag_Motor_Running          = 0;
bit	Flag_Virtual_Hall           = 0;
bit	Flag_Reverse                = 0; // 0 : Forward 1 : Reverse
bit	Flag_Reverse_Temp           = 0; // 0 : Forward 1 : Reverse			
bit FR							= 0;
unsigned int FR_Delay           = 0;
bit FR_OUT                      = 0;

xdata unsigned int	System_Restart_Cnt	= 0;
xdata unsigned char	System_Reset_Cnt	= 0;

//Hall
unsigned int  Reset_Estimated_Count		= 0;
#ifdef	BOOTSTRAP
xdata unsigned int BootStrap_Cnt		= 0;
#endif

/* VSP & PWM Command */
data unsigned int  VSP		= 0;
data unsigned int  VSP_NEW	= 0;
#if (Input_Command_Type == dPWM)
data unsigned int  Capt_t	= 0;
data unsigned int  Caph_t	= 0;
xdata signed char  Capt_Overflow;
xdata unsigned int Capt_t_old;
xdata short Cap_dif;
xdata short Cap_cfn			= 0;
#if (PWM_CMD_SLOPE_EN == 1)
data unsigned char VSP_DLY	= 0;
data unsigned int  VSP_TMP	= 0;
#endif
#elif (Input_Command_Type == dFrequency)
data unsigned int  Capt_t	= 0;
data unsigned int  Vsp_dly	= 0;
#endif

/* Idc Bus */
#ifdef	CURRENTLOOP_CONTROL
data unsigned int Idc_Bua_Data            = 0;
data unsigned int Idc_Bua_Data_FILTED     = 0;
data unsigned int Idc_Bua_Data_FILTED_Pre = 0;
data unsigned int Idc_Bua_FILTED_Out	  = 0;
#endif


/* Control Command */
data  unsigned int	Duty_Command         = 0;
data  unsigned int	Duty_Command_Buffer  = 0;
xdata unsigned int	Duty_Slope_Cnt2      = 0;
data  signed int	Speed_Command_Buffer = 0;
data  signed int	IBus_Command         = 0;
data  signed int	IBus_Command_Buffer  = 0;
xdata unsigned int	IBus_Slope_Cnt       = 0;

data unsigned int Estimated_Speed			= 0;
data unsigned int Estimated_Speed_Cnt[8]	= {0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff};
data unsigned int FG_RPM_Compensation		= 0;

#ifdef	FG_CAL
unsigned short RpmTemp;
unsigned char  RTH2;
unsigned char  RTL2;
#endif

#if (Control_Mode == dTuning_Mode)
xdata unsigned int AS_VSP			= 0;
xdata unsigned int AS_FG			= 0;
xdata unsigned int AS_FG_COUNTER	= 0;
#endif

#if (LookupTable_EN == 1)
code const ConstP rtConstP = LOOKUPTABLE_DEFAULTS;
#endif

//********************************************************************************
//								    MAIN
//********************************************************************************
void main(void){
	uint16 Power_on_delay_counter = 0;
	for(Power_on_delay_counter=0;Power_on_delay_counter<dPOWER_ON_DELAY_Mechanical_Cycle;Power_on_delay_counter++){};
	
	PWM_Init();
	GPIO_Init();
	Adc_Init();
	Timer_Init();
	OCP_Init();
	MDE_Init();
	Interrupt_Init();
	CAP_Init();

	HallTable_Init();
	MotorReset_MDE_Init();
	
	#ifdef	FG_CAL
		FG = 1;
	#endif
	
	#if (dUART_MODE == 1)
		Uart_Definition(); 
	#endif

	while(1){
		#ifdef	FG_CAL
		if(Estimated_Speed <= SPEED_MIN){
			ET1 = 0;
			TR1 = 0;
			FG  = 1;
		} 
		else{		
			TR1 = 1;
			ET1 = 1;
			#if (Control_Mode == dTuning_Mode)
				RpmTemp = FG_FORMULAR/(AS_FG);
			#else
				RpmTemp = FG_FORMULAR/(Estimated_Speed);
			#endif
			RTH2 = (65535-RpmTemp) >> 8;
			RTL2 = (65535-RpmTemp) &  0XFF;
		}
		#endif
				
		//UART		
		#if (dUART_MODE == 1)
			if(RxState == RX_FINISH)
				Uart_ReadPackage_Build();
			if(UartFlag == 1){	//10ms
				Debug_A = Debug_RxBuffer[0];//Duty_Command;//dAMP_PER_CONSTANT;//Estimated_Speed_Cnt;//VSP;
				Debug_B = Debug_RxBuffer[1];//PIParm_IBUS.qOut;//VSP_NEW;//IBus_Command;//Estimated_Speed;//Duty_Command;//Estimated_Speed;//Duty_Command_Buffer;//VSP_NEW;
				Debug_C = TxState;//test;//PIParm_IBUS.qOut;//Duty_Command_Buffer;//REVERSE_TIME;//Estimated_Speed;//VSP_NEW;//Flag_Reverse;Reverse_Reset_Cnt >= REVERSE_RESET_TIME
				Debug_D = Debug_TxDataLen;//Idc_Bua_Data_FILTED;//CMD_START_VAL;//Estimated_Speed_Cnt[7];//VSP;//Estimated_Speed_Cnt;
				Debug_E = Debug_TxCounter;//PIParm_IBUS.qOut;//Error_Code;//test;//Error_Code;//Estimated_Speed;//CMD_STOP_VAL;//SPEED_LIMIT_VAL//AOCPCONT
				Debug_F = UartFlag;//PIParm_IBUS.qCnt;
				Uart_Package_Build();
				UartFlag = 0;
			}
		#endif
	}
}
//********************************************************************************
//								PWM & CAPTURER
//********************************************************************************
void PWM_CAPTURER(void){
////////////////////////////////////////////////////////////////////////////
	#if(Input_Command_Type==dFrequency)	
		Capt_t = (CAPT_H << 8) + CAPT_L; //2T:3us 25bytes level=0		
		
		if(Capt_t == 0xFFFF)
			VSP = 0;
		else{ //CAPH != 0XFFFF
			if(Capt_t != 0)			
				VSP = (48000000 / CAPCKS) / Capt_t; //2T:3us 25bytes level=0
			else								
				VSP = 0;
			if(VSP > CMD_MAX_VAL)	
				VSP = CMD_MAX_VAL;	
		}
////////////////////////////////////////////////////////////////////////////
	#elif(Input_Command_Type==dPWM)
		Capt_t = (CAPT_H << 8) + CAPT_L; //2T:3us 25bytes level=0
		Caph_t = (CAPH_H << 8) + CAPH_L;
		
		if(Caph_t == 0xFFFF){
			if(CAP1 == 0){
				if(++Capt_Overflow > 20){
					Capt_Overflow = 20;
					VSP_NEW       = 0;
				}
			}
			else{ //CAP1 = 1
				if((--Capt_Overflow > 0) && (VSP_NEW == 0))
					VSP_NEW       = 0;
				else{
					Capt_Overflow = 0;
					VSP_NEW       = 4096;
				}
			}
		}
		else{ //CAPH != 0XFFFF
			Capt_Overflow = 0;
			if(Capt_t != 0)			
				VSP_NEW = (unsigned long)(((unsigned long)Caph_t << 10) / Capt_t) << 2;
			else								
				VSP_NEW = 0;
			if(VSP_NEW > 4096)	
				VSP_NEW = 4096;	
		}
		#ifdef	INPUT_NOINV	
			#if(PWM_CMD_SLOPE_EN == 1)	
				VSP_TMP = ((VSP_TMP * 12 + VSP_NEW) >> 4);
				if(VSP_DLY ++ > PWM_CMD_SLOPE){
					if(VSP < VSP_TMP)
						VSP ++;
					else if(VSP > VSP_TMP)
						VSP --;
					VSP_DLY = 0;
				}
			#else
				VSP = ((VSP * 12 + VSP_NEW) >> 4);
			#endif
		#else
			#if(PWM_CMD_SLOPE_EN == 1)
				VSP_TMP = 1024 - (((1024-VSP_TMP) * 12 + VSP_NEW) >> 4);
				if(VSP_DLY ++ > PWM_CMD_SLOPE){
					if(VSP < VSP_TMP)
						VSP ++;
					else if(VSP > VSP_TMP)
						VSP --;
					VSP_DLY = 0;
				}
			#else
				VSP = 1024 - (((1024-VSP) * 12 + VSP_NEW) >> 4);
		#endif
	#endif
////////////////////////////////////////////////////////////////////////////
	#elif(Input_Command_Type==dVSP)
		VSP_NEW = (Adc_Channel(VSP_CH))<<2;
		#ifdef	INPUT_NOINV
			VSP = ((VSP * 12 + VSP_NEW) >> 4);
		#else
			VSP = 1024 - (((1024-VSP) * 12 + VSP_NEW) >> 4);
		#endif
	#endif
////////////////////////////////////////////////////////////////////////////			
	#if(Force_Command == 1)
		VSP = VSP_RATIO;
	#elif (Control_Mode == dTuning_Mode)
		VSP       = 1024;
		AS_VSP    = Adc_Channel(VSP_CH);
	#endif			
}
//********************************************************************************
//								Speed Estimation
//********************************************************************************
void Speed_Estimation(void){
	Estimated_Speed_Cnt[6] = Estimated_Speed_Cnt[5];
	Estimated_Speed_Cnt[5] = Estimated_Speed_Cnt[4];
	Estimated_Speed_Cnt[4] = Estimated_Speed_Cnt[3];
	Estimated_Speed_Cnt[3] = Estimated_Speed_Cnt[2];
	Estimated_Speed_Cnt[2] = Estimated_Speed_Cnt[1];
	Estimated_Speed_Cnt[1] = Estimated_Speed_Cnt[0];
	Estimated_Speed_Cnt[0] = (ROTORSPEEDH * 256) + ROTORSPEEDL; // 2T:2.2us 20bytes level = 0

	#ifdef POLE_14
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1] + (unsigned long)Estimated_Speed_Cnt[2] + 
		(unsigned long)Estimated_Speed_Cnt[3] + (unsigned long)Estimated_Speed_Cnt[4] + (unsigned long)Estimated_Speed_Cnt[5] + (unsigned long)Estimated_Speed_Cnt[6]) / 7);
	#endif
	#ifdef POLE_12
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1] + (unsigned long)Estimated_Speed_Cnt[2] + 
		(unsigned long)Estimated_Speed_Cnt[3] + (unsigned long)Estimated_Speed_Cnt[4] + (unsigned long)Estimated_Speed_Cnt[5]) / 6);
	#endif
	#ifdef POLE_10
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1] + (unsigned long)Estimated_Speed_Cnt[2] + 
		(unsigned long)Estimated_Speed_Cnt[3] + (unsigned long)Estimated_Speed_Cnt[4]) / 5);
	#endif
	#ifdef POLE_8
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1] + (unsigned long)Estimated_Speed_Cnt[2] + 
		(unsigned long)Estimated_Speed_Cnt[3]) / 4);
	#endif
	#ifdef POLE_6
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1] + (unsigned long)Estimated_Speed_Cnt[2]) / 3);
	#endif
	#ifdef POLE_4
		Estimated_Speed_Cnt[7] = (((unsigned long)Estimated_Speed_Cnt[0] + (unsigned long)Estimated_Speed_Cnt[1]) / 2);
	#endif

	Estimated_Speed  = ((unsigned long)RPM_D / Estimated_Speed_Cnt[7]) >> SPEED_SHIFT;
}
//********************************************************************************
//								 Motor Stop
//********************************************************************************
void Motor_Stop(void){
	unsigned int dMCONT1;
	dMCONT1 = MCONT1;

	Duty_Command           = 0;
	Duty_Command_Buffer    = 0;
	Speed_Command_Buffer   = 0;
	IBus_Command_Buffer	   = 0;
	Flag_Motor_Running     = 0;
	AS_Command_Buffer      = 0;
		
	#if(dLOCK_ROTOR_PROTECTION_ENABLE == 1)
		Rotor_Lock_Detection(RESET, 500);
	#endif
		
		//Hall_Error_Status_Detection(RESET, HALL_TABLE_ERROR_STATUS[0], HALL_TABLE_ERROR_STATUS[1], 5);
		
		//if(System_Restart_Cnt != 0 && Error_Code != dERRORCODE_OVERCURRENTPROTECTION && Error_Code != dERRORCODE_OVERVOLTAGEPROTECTION) Estimated_Speed =0;
	
	#ifdef	BOOTSTRAP
		BootStrap_Cnt = 0;
	#endif
	HALL_1_TO_3();
	InitPI(&PIParm_W);
	InitPI(&PIParm_IBUS);

	if(dMCONT1&=0x80){
		if(++Reset_Estimated_Count >= 500){
			Reset_Estimated_Count = 0;
			Estimated_Speed 		= 0;
		}
	} 
	else{
		Reset_Estimated_Count = 0;
	}
}
//********************************************************************************
//								 PWM Reset
//********************************************************************************
void RST_PWM(void){
	//Duty_Command_Buffer = 0;
	SVPWMAMPFT = 0;
	SVPWMAMPL  = 0;
	SVPWMAMPH  = 0;
	MPWMCONT1  = 0;	// High-side Force Low
	MPWMCONT2  = 0;	// Low-side Force Low
}