// I2CDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DemoApplication.h"
#include "TCEdit.h"
#include "I2CDlg.h"
#include "MWBridgeDLL.h"
#include "afxdialogex.h"
#include "GPIOPWMDlg.h"
#include "OtherDlg.h"
#include "SPIDlg.h"
#include "UARTDlg.h"
#include "DemoApplicationDlg.h"
// CI2CDlg dialog

extern sMWBridge gMWBridge;
IMPLEMENT_DYNAMIC(CI2CDlg, CDialog)

CI2CDlg::CI2CDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CI2CDlg::IDD, pParent),
	m_hEditAuxBuffer(NULL)
{

}

CI2CDlg::~CI2CDlg()
{
}

void CI2CDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_I2C_SPEED_SELECTION, m_comboI2CSpeedSelection);
	DDX_Control(pDX, IDC_COMBO_I2C_SCL_TIMEOUT_SELECTION, m_comboI2CSCLTimeoutSelection);
	DDX_Control(pDX, IDC_COMBO_I2C_OPERATION_TYPE, m_comboI2COperationType);
	DDX_Control(pDX, IDC_EDIT_I2C_DEVICE_ADDRESS, m_editI2CDeviceAddress);
	DDX_Control(pDX, IDC_EDIT_I2C_AUX_BUFFER_SIZE, m_editI2CAuxBufferSize);
}


BEGIN_MESSAGE_MAP(CI2CDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_I2C_SET_STREAM_MODE, &CI2CDlg::OnBnClickedButtonTwiSetStreamMode)
	ON_BN_CLICKED(IDC_BUTTON_I2C_GET_STREAM_MODE, &CI2CDlg::OnBnClickedButtonTwiGetStreamMode)
	ON_EN_CHANGE(IDC_EDIT_I2C_AUX_BUFFER_SIZE, &CI2CDlg::OnChangeEditTwiAuxBufferSize)
END_MESSAGE_MAP()


// CI2CDlg message handlers


void CI2CDlg::InitialInterface()
{
	m_comboI2CSCLTimeoutSelection.AddString(_T("    20 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("    40 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("    80 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("  160 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("  320 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("  640 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("  960 ms"));
	m_comboI2CSCLTimeoutSelection.AddString(_T("1280 ms"));
	m_comboI2CSCLTimeoutSelection.SetCurSel(0);

	m_comboI2CSpeedSelection.AddString(_T("    25 K"));
	m_comboI2CSpeedSelection.AddString(_T("    50 K"));
	m_comboI2CSpeedSelection.AddString(_T("    75 K"));
	m_comboI2CSpeedSelection.AddString(_T("  100 K"));
	m_comboI2CSpeedSelection.SetCurSel(0);

	m_comboI2COperationType.AddString(_T("Idle"));
	m_comboI2COperationType.AddString(_T("Sequential Write"));
	m_comboI2COperationType.AddString(_T("Sequential Read"));
	m_comboI2COperationType.AddString(_T("RandomRead"));
	m_comboI2COperationType.SetCurSel(0);

	CheckDlgButton(IDC_RADIO_I2C_NO_ACTION, BST_CHECKED);
	m_editI2CDeviceAddress.SetWindowTextW(_T("00"));
	m_editI2CDeviceAddress.SetLimitText(2);
	m_editI2CAuxBufferSize.SetLimitText(2);
	m_editI2CAuxBufferSize.SetWindowText(_T("00"));

	DWORD hc[] = { 0x55, 0xC8C8C8, 0, 0xC8C8C8, 0, 0xC8C8C8, 0, 0xC8C8C8, 0 };	
	m_hEditAuxBuffer = ::GetDlgItem(m_hWnd, IDC_EDIT_I2C_AUX_BUFFER);
	::SendMessage(m_hEditAuxBuffer, HM_COLOR, (WPARAM)&hc, 0);           // Set Color
	::SendMessage(m_hEditAuxBuffer, HM_FONTSIZE, 14, 0);                 // Set Font Size
	::SendMessage(m_hEditAuxBuffer, HM_LINELENGTH, MAKELONG(0, 4), 0);   // Set Line Length

}


BOOL CI2CDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	InitialInterface();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CI2CDlg::OnBnClickedButtonTwiSetStreamMode()
{
	DWORD dwResult = ERROR_SUCCESS;
	sStreamSetting StreamSetting;
	TCHAR tmpBuffer[MAX_PATH + 1] = { 0 };
	UINT ButtonState;

	StreamSetting.Mode = I2C;
	ButtonState = IsDlgButtonChecked(IDC_RADIO_I2C_NO_ACTION);
	if (ButtonState == BST_CHECKED)
		StreamSetting.I2C.ResetControl = NoAction;
	else
		StreamSetting.I2C.ResetControl = ResetI2CEngine;

	ButtonState = IsDlgButtonChecked(IDC_CHECK_I2C_SCL_TIMEOUT_DETECTION_ENABLE);
	if (ButtonState == BST_CHECKED)
		StreamSetting.I2C.SCLTimeoutDetectionControl = Enable;
	else
		StreamSetting.I2C.SCLTimeoutDetectionControl = Disable;

	StreamSetting.I2C.SCLTimeoutSelection = eSCLTimeoutSelection(m_comboI2CSCLTimeoutSelection.GetCurSel());
	StreamSetting.I2C.SpeedSelection = eSpeedSelection(m_comboI2CSpeedSelection.GetCurSel());

	dwResult = SetStreamMode(&gMWBridge, StreamSetting);
	if (dwResult == ERROR_SUCCESS)
	{
		((CDemoApplicationDlg*)GetParent())->m_Options.Mode = I2C;
		_stprintf_s(tmpBuffer, _T("SetStreamMode I2C OK !"));
		((CDemoApplicationDlg*)GetParent())->m_StatusBar.SetPaneText(0, tmpBuffer);
	}
	else
	{
		_stprintf_s(tmpBuffer, _T("SetStreamMode I2C Fail ! Error Code = %8X"), dwResult);
		((CDemoApplicationDlg*)GetParent())->m_StatusBar.SetPaneText(0, tmpBuffer);
	}
}


void CI2CDlg::OnBnClickedButtonTwiGetStreamMode()
{
	DWORD dwResult = ERROR_SUCCESS;
	sStreamSetting StreamSetting;
	TCHAR tmpBuffer[MAX_PATH + 1] = { 0 };

	dwResult = GetStreamMode(&gMWBridge, &StreamSetting);
	if (dwResult == ERROR_SUCCESS)
	{
		if (StreamSetting.Mode == I2C)
		    _stprintf_s(tmpBuffer, _T("GetStreamMode I2C OK !"));
		else
			_stprintf_s(tmpBuffer, _T("GetStreamMode OK ! But not in I2C Mode"));
		((CDemoApplicationDlg*)GetParent())->m_StatusBar.SetPaneText(0, tmpBuffer);
	}
	else
	{
		_stprintf_s(tmpBuffer, _T("GetStreamMode I2C Fail ! Error Code = %8X"), dwResult);
		((CDemoApplicationDlg*)GetParent())->m_StatusBar.SetPaneText(0, tmpBuffer);
	}

	if (StreamSetting.Mode == I2C)
	{
		if (StreamSetting.I2C.ResetControl == NoAction)
		{
			CheckDlgButton(IDC_RADIO_I2C_NO_ACTION, BST_CHECKED);
			CheckDlgButton(IDC_RADIO_I2C_RESET_I2C_ENGINE, BST_UNCHECKED);
		}
		else
		{
			CheckDlgButton(IDC_RADIO_I2C_NO_ACTION, BST_UNCHECKED);
			CheckDlgButton(IDC_RADIO_I2C_RESET_I2C_ENGINE, BST_CHECKED);
		}
		if (StreamSetting.I2C.SCLTimeoutDetectionControl == Enable)
			CheckDlgButton(IDC_CHECK_I2C_SCL_TIMEOUT_DETECTION_ENABLE, BST_CHECKED);
		else
			CheckDlgButton(IDC_CHECK_I2C_SCL_TIMEOUT_DETECTION_ENABLE, BST_UNCHECKED);

		m_comboI2CSCLTimeoutSelection.SetCurSel(StreamSetting.I2C.SCLTimeoutSelection);
		m_comboI2CSpeedSelection.SetCurSel(StreamSetting.I2C.SpeedSelection);
	}
	else
	{
		_stprintf_s(tmpBuffer, _T("GetStreamMode Not In I2C Mode!"));
		((CDemoApplicationDlg*)GetParent())->m_StatusBar.SetPaneText(0, tmpBuffer);
	}
}


BOOL CI2CDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
	if (pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_ESCAPE)
	{
		return TRUE;
	}
	else
	{
		return CDialog::PreTranslateMessage(pMsg);
	}
}


void CI2CDlg::OnChangeEditTwiAuxBufferSize()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	int Index = 0;
	DWORD dwSize = 0;
	TCHAR tmpBuffer[0x10] = { 0 };
	BYTE *pBuffer = NULL;

	Index = m_comboI2COperationType.GetCurSel();
	if (Index == 3) // OperationType = Sequence Read
	{
		m_editI2CAuxBufferSize.GetWindowText(tmpBuffer, 0x10);
		dwSize = _tcstoul(tmpBuffer, NULL, 16);
		if (dwSize > 4)
		{
			m_editI2CAuxBufferSize.SetWindowText(_T("4"));
			dwSize = 4;
		}
		if (dwSize == 0)
		{
			m_editI2CAuxBufferSize.SetWindowText(_T("1"));
			dwSize = 1;
		}

		if (dwSize != 0) 
		{
			
			pBuffer = new BYTE[dwSize];
			if (pBuffer != NULL)
			{
				memset(pBuffer, 0, dwSize);
				::SendMessage(m_hEditAuxBuffer, HM_LIMITSIZE, dwSize, 0);
				::SendMessage(m_hEditAuxBuffer, HM_SETDATA, (WPARAM)pBuffer, dwSize);
				delete[]pBuffer;
				pBuffer = NULL;
			}

		}
	}
}
