




/**
 ******************************************************************************
 *
 * @file        Sample_MID_URT_RXTX.c
 * @brief       The sample code is that use middleware to receive and transmit data
 *     \n       (The middleware is use polling flag).
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/06/13
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_CSC_Init.h"
#include "MG32_GPIO_MID.h"
#include "MG32_URT_MID.h"
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static URT_HandleTypeDef MURT_RXTX;

static uint8_t MID_URTRXTX_BUF[10];

/* Private function prototypes -----------------------------------------------*/
void SysTick_Handler(void);

void Sample_MID_URT_Transfer(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief     The is SysTick Handler Sample.
 * @details   Call the MID_IncTick() function into SysTick_Handler() if 
 *            the SysTick_Handler() already  exists, or uncommenting 
 *            the SysTick_Handler() function in the sample code.   
 * @return      
 * @exception No
 * @note      No
 *******************************************************************************
 */
//void SysTick_Handler(void)
//{
//    MID_IncTick();
//}

/**
 *******************************************************************************
 * @brief	  Initalize the URT MSP.
 * @details     
 * @param[in] MURT : URT control struct. 
 * @return      
 * @exception No
 * @note      No
 *******************************************************************************
 */
void MID_URT_MspInit( URT_HandleTypeDef* MURT)
{
    GPIO_InitTypeDef PINX_InitStruct;
    
    //==============================================================================
    //CSC Inital 
    //You can:
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //    2. In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    
    //==============================================================================
    //GPIO Inital : 
    //You can :
    //    1. Tick CSC checkbox of MG32_ChipInit in Manage Run-Time Environment.
    //       In MG32_ChipInit_Wizard of Project window use MG32_CSC_Init.h file
    //       to select that you want CSC environment.
    //    or
    //    2. Use MID_GPIO_Pin_Init() or MID_GPIO_Init()
    //       the following sample code is MID_GPIO_Pin_Init().
    //    - TX : 
    //        1. Pin : PB8 
    //        2. Mode : Push pull mode.
    //    - RX : 
    //        1. Pin : PB9
    //        2. Mode : Open drain with internal pull up R. 
    PINX_InitStruct.Mode		   = GPIO_MODE_OPENDRAIN_O;
    PINX_InitStruct.Pull           = GPIO_PULLUP;
    PINX_InitStruct.Speed          = GPIO_SPEED_LOW;
    PINX_InitStruct.OUTDrive       = GPIO_OUTDRIVE_LEVEL0;
    PINX_InitStruct.FilterDivider  = GPIO_FILTERDIVIDER_BYPASS;
    PINX_InitStruct.Inverse        = GPIO_INVERSE_DISABLE;
    PINX_InitStruct.Alternate      = 3;
    MID_GPIO_Pin_Init(PINB(9),&PINX_InitStruct);
    
    PINX_InitStruct.Mode	       = GPIO_MODE_PUSHPULL_O;
    MID_GPIO_Pin_Init(PINB(8),&PINX_InitStruct);

    //==============================================================================
    // Prevent unused argument(s) compilation warning 
    UNUSED( MURT);
}

/**
 *******************************************************************************
 * @brief	    The sample code is that use blocking mode to receive data 
 *   \n         and transfer data.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void Sample_MID_URT_Transfer(void)
{
    //==============================================================================
    //Enable systick for Timeout use.
    MID_InitTick(12000000UL); // *.1ms Tick in systick clock source is 12MHz.
                              //
                              // *.Have to option IRQ_handler of MG32_ChipInit_Wizard
                              //   in Manage Run-Time Environment or own write 
                              //   SysTick_Handler() and call MID_IncTick().
    //==============================================================================
    //Select URT : The sample select UART0 
    MURT_RXTX.Instance            =  URT0;
    
    //==============================================================================
    //URT standard inital :
    //    - Baudrate.
    //    - Data Size.  
    //    - Hardware Flow Control. (CTS / RTS)
    //    - Sample time.
    //    - Parity bit.
    //    - Stop bit.
    MURT_RXTX.Init.BaudRate       =  115200;                            
    MURT_RXTX.Init.WordLength     =  UART_WORDLENGTH_8B;
    MURT_RXTX.Init.HWFlowCtrl     =  URT_HWCONTROL_NONE;
    MURT_RXTX.Init.Mode           =  URT_TX_RX;
    MURT_RXTX.Init.OneBitSampling =  URT_ONEBIT_SAMPLE_THREE;
    MURT_RXTX.Init.Parity         =  URT_PARITY_NO;
    MURT_RXTX.Init.StopBits       =  URT_STOPBIT_1_0;
    
    //==============================================================================
    //URT advanced inital. 
    
    //-------------------------------------------------------------
    //Exsample 1 :
    //    - No need Advanced inital.
    MURT_RXTX.AdvancedInit.AdvFeatureInit     = URT_ADVFEATURE_NO_INIT;
    
    //-------------------------------------------------------------
    //Exsample 2 :
    //    - AdvFeatureInit select to deal with item :
    //        -1. TXDataInvert : Control TX Data bit whether inverse or not.
    //        -2. RXDataInvert : Control RX Data bit whether inverse or not.
    //        -3. TXMSBFirst   : Control TX Data bit order is MSB or LSB.
    //        -4. RXMSBFirst   : Control RX Data bit order is MSB or LSB.
   
//    MURT_RXTX.AdvancedInit.AdvFeatureInit     = (URT_ADVFEATURE_TXDATAINVERT_INIT | URT_ADVFEATURE_TXMSBFIRST_INIT | \
//                                                 URT_ADVFEATURE_RXDATAINVERT_INIT | URT_ADVFEATURE_RXMSBFIRST_INIT); 

//    MURT_RXTX.AdvancedInit.TXDataInvert       = URT_ADVFEATURE_TXDATAINV_ENABLE;
//    MURT_RXTX.AdvancedInit.RXDataInvert       = URT_ADVFEATURE_RXDATAINV_ENABLE;
//    MURT_RXTX.AdvancedInit.TXMSBFirst         = URT_ADVFEATURE_MSBFIRST;
//    MURT_RXTX.AdvancedInit.RXMSBFirst         = URT_ADVFEATURE_MSBFIRST;

    MID_URT_Init( &MURT_RXTX);
    
    //==============================================================================
    //To start receive / transmit transfer
    //    *. The flow is transmit 10 bytes after receive receive 10 bytes.     
    MID_URT_Receive( &MURT_RXTX , &MID_URTRXTX_BUF[0]  , 10 , 5000);       //Receive 10 byte to SMP_URTRXTX_BUF[] , and receive timeout is 5 s
    MID_URT_Transmit( &MURT_RXTX , &MID_URTRXTX_BUF[0] , 10 , 5);          // Transmit 10 bytes data from SMP_URTRXTX_BUF[] and transmit timeout is 5 ms .
}


