/**
  ******************************************************************************
 *
 * @file        Sample_MID_APB_OBMx_SetupExample.c
 *
 * @brief       Output Signal Break and Modulation Control setup example.
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_APB_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static MID_OBMx_HandleTypeDef mOBMx;
    
/* Private function prototypes -----------------------------------------------*/
void Sample_MID_APB_OBMx_SetupExample(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    APB OBM0 setup example.
 * @details     initial APB OBM0 .
 * @return      None
 *******************************************************************************
 */
void Sample_MID_APB_OBMx_SetupExample(void)
{  
    mOBMx.Instance                  = OBM0;
    mOBMx.Init.OBMxMode             = APB_OBM_CLR;                  // STA bit is cleared by falling edge of OR signal
    mOBMx.Init.BKS0Src              = APB_BKS0_CMP0_OUT;            // sigle-end type
    mOBMx.Init.BKS0Polarity         = APB_OBM_BKS0_LOW;             // BKS0 : Non-Invert
    mOBMx.Init.BKS1Src              = APB_BKS1_TM01_TRGO;           // sigle-end type
    mOBMx.Init.BKS1Polarity         = APB_OBM_BKS1_LOW;             // BKS1 : Non-Invert
    mOBMx.Init.BKS2Src              = APB_BKS2_LOGIC_1;             // BKS2 always keep '1'
    mOBMx.Init.BKS2Polarity         = APB_OBM_BKS2_LOW;             // BKS2 : Non-Invert
    mOBMx.Init.OutChannel0Src       = APB_CH0_TM00_CKO;             // Channel0 output signal is TM00_CKO 
    mOBMx.Init.OutChannel0Polarity  = APB_OBM_CH0_LOW;              // Non-invert channel0 output
    mOBMx.Init.OutChannel1Src       = APB_CH1_LOGIC_0;              // Channel1 output '0' /w invert
    mOBMx.Init.OutChannel1Polarity  = APB_OBM_CH1_HIGH;             // Invert channel1 output
    mOBMx.Init.OBMxOutPolarity      = APB_OBM_PIN_LOW;              // Non-invert
    mOBMx.Init.SyncFilter           = OBM_SYNCHRONIZE_BYPASS;       // disable OBMx output filter
    mOBMx.Init.InitSTAState         = APB_OBM_INITSTA_HIGH;         // Set initial STA to '1'
    
    MID_OBMx_Init(&mOBMx);
    

    
}




