/**
 ******************************************************************************
 *
 * @file        Sample_Show_UID.c
 *
 * @brief       Show UID(Unique Identity) code.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2021/05/25
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define UID_Address         0x1FF20040

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
#if defined (__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050) /* ARM Compiler V6 */
    #pragma clang diagnostic push
    #pragma clang diagnostic ignored "-Wmissing-variable-declarations"
        uint32_t *INDEX;
    #pragma clang diagnostic pop
#else
    uint32_t *INDEX;
#endif

/* Private function prototypes -----------------------------------------------*/
void Show_UID (void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief       Show UID (Unique Identity)
 * @details     Show UID
 * @return      None
 * @note
 * @par         Example
 * @code
    Show_UID();
 * @endcode
 *******************************************************************************
 */
void Show_UID (void)
{

    INDEX = (uint32_t*) UID_Address;            // Set INDEX = UID[3~0]
                                                // UID data 4 words
//    printf("\n\nUID code:");                    // Show UID code
//    printf("\n0x%08x", *INDEX); INDEX++;        // UID[0 ~ 3]
//    printf("\n0x%08x", *INDEX); INDEX++;        // UID[4 ~ 7]
//    printf("\n0x%08x", *INDEX); INDEX++;        // UID[9 ~ 12]
//    printf("\n0x%08x", *INDEX);                 // UID[13 ~ 16]
}



