
/**
 ******************************************************************************
 *
 * @file        main.C
 * @brief       MG32 demo main c Code. 
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/06/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
//#include "MG32__Common_DRV.h"
//#include "MG32_EXIC_DRV.h"
//#include "MG32__IRQHandler.h"
#include "MG32_MID.h"

#include "MG32_GPIO_Init.h"
#include "MG32_IRQ_Init.h"
#include "MG32_I2C_Init.h"
#include "MG32_EMB_Init.h"
#include "MG32_MEM_Init.h"
#include "MG32_GPL_Init.h"

#include "LCD.h"
#include "ltdc.h"
#include "ugui.h"
#include "LCDDEMO_RGBLED_API.h"
#include "LCDDEMO_KEY_API.h"
#include "API_Flash.h"

//#incldue "meun.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define TextCol 80
#define TextRow 20

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
//void ChipInit(void);
//void Sample_Code(void);
//extern UG_GUI gui;

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern DRV_Return URT_Init(URT_Struct* URTX);
extern void ChipInit(void);


struct {
    struct{
        uint8_t Text[TextCol];
        uint8_t Font;
        uint8_t Length;
        uint16_t Color;
    }Text[TextRow];
    uint8_t ShowEnable;
    uint8_t AddIndex;
    uint16_t Accumulation;
}TextList;



void API_TextList_Init(void)
{
    uint8_t lx, ly;
    ly = 0;
    do{
        lx = 0;
        do{
            TextList.Text[ly].Text[lx] = 0x20;
        }while(++lx < TextCol);
        TextList.Text[ly].Color = 0;
        TextList.Text[ly].Font = 0;
        TextList.Text[ly].Length = 0;
    }while(++ly < TextRow);
    TextList.Accumulation = 0;
    TextList.AddIndex = 0;
    TextList.ShowEnable = 0;
}



void API_ShowTextList(void)
{
    uint16_t lYAxis = 0;
    uint8_t lShowIndex;
    uint8_t lShowCount = 0;
    if(TextList.ShowEnable == 0)
        return;
    LCD_Clear(BLACK);
    if(TextList.Accumulation < TextRow)
        lShowIndex = 0;
    else
        lShowIndex = TextList.AddIndex;
    do{
        LCD_ShowString(0, lYAxis, lcddev.width, 16, TextList.Text[0].Color, TextList.Text[lShowIndex].Font, TextList.Text[lShowIndex].Text);
        lShowIndex ++;
        if(lShowIndex >= TextRow)
            lShowIndex = 0;
        lYAxis += 16;
    }while(++lShowCount < TextRow);
}



void API_AddText2List(uint8_t *p, uint8_t Length, uint8_t Font, uint16_t Color)
{
    uint8_t *lpChar = p;
    uint8_t lCharCount = 0;
    do{
        TextList.Text[TextList.AddIndex].Text[lCharCount] = *lpChar;
        lpChar ++;
    }while(++lCharCount < TextCol);
    TextList.Text[TextList.AddIndex].Length = Length;
    TextList.Text[TextList.AddIndex].Font = Font;
    TextList.Text[TextList.AddIndex].Color = Color;

    TextList.AddIndex ++;
    if(TextList.AddIndex >= TextRow)
        TextList.AddIndex = 0;
    TextList.Accumulation ++;
    API_ShowTextList();
}


uint32_t TotalCount = 0;



struct{
    uint8_t Name[6];
    uint32_t Address;
    uint32_t Size;
    uint16_t Check;
}FlashIS;



union RBuffer{
    uint32_t W[512];
    uint16_t H[1024];
    uint8_t  B[2048];
}ReadDataBuffer;



void LCD_Show_Picture(uint16_t nTh)
{
    uint32_t lBaseAddr = (nTh << 4);
    uint32_t lCount;
    uint32_t lAddr;
    union{
        uint16_t H[512];
        uint8_t B[1024];
    }lH_B;
    // Read Head 
    API_Flash_MultiBytesRead(0x0000000, (uint8_t *)&TotalCount, 0x4);

    API_Flash_MultiBytesRead(lBaseAddr, (uint8_t *)&FlashIS.Name, 6);
    API_Flash_MultiBytesRead((lBaseAddr + 6), (uint8_t *)&FlashIS.Address, 4);
    API_Flash_MultiBytesRead((lBaseAddr + 0xA), (uint8_t *)&FlashIS.Size, 4);
    API_Flash_MultiBytesRead((lBaseAddr + 0xE), (uint8_t *)&FlashIS.Check, 2);

    LCD_SetCursor(0, 0);		//?????? 
    LCD_WriteRAM_Prepare();	    //????GRAM
    __LCD_CS_CLR();\
    __LCD_RS_SET();\

    lAddr = FlashIS.Address;
    do{
        API_Flash_MultiBytesRead(lAddr, &lH_B.B[0], 1024);
        lCount = 0;
        do{
            if(lH_B.H[lCount] == 0xFFFF)
                __DATAOUT(0x0000);
            else
                __DATAOUT(lH_B.H[lCount]);
        }while(++ lCount < 512);
        lAddr += 1024;
    }while(lAddr < (FlashIS.Address + FlashIS.Size));
    __LCD_CS_SET();
}



void LCD_Show_Text(void)
{
    __LCD_BackLight_Off();
    LCD_Clear(BLACK);
    LCD_ShowString(0, 0, lcddev.width, 24, GBLUE, 24, (uint8_t *)"Megawin Company");
    LCD_ShowString(0, 24, lcddev.width, 24, BRED, 24, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(0, 48, lcddev.width, 24, YELLOW, 24, (uint8_t *)"Product MG32F02A");	
    LCD_ShowString(0, 72, lcddev.width, 24, GREEN, 24, (uint8_t *)"Show Features");
    LCD_ShowString(0, 96, lcddev.width, 24, BLUE, 24, (uint8_t *)"2018/02/17");

    LCD_ShowString(0, 144, lcddev.width, 16, WHITE, 16, (uint8_t *)"Megawin Company");	
    LCD_ShowString(0, 160, lcddev.width, 16, WHITE, 16, (uint8_t *)"ARM Cortex M0 Series");	
    LCD_ShowString(0, 176, lcddev.width, 16, WHITE, 16, (uint8_t *)"Product MG32F02A");
    LCD_ShowString(0, 192, lcddev.width, 16, WHITE, 16, (uint8_t *)"Show Features");
    LCD_ShowString(0, 208, lcddev.width, 16, WHITE, 16, (uint8_t *)"2018/02/17");

    LCD_ShowString(0, 240, lcddev.width, 12, WHITE, 12, (uint8_t *)"Megawin MG32F02A");	
    LCD_ShowString(0, 252, lcddev.width, 12, WHITE, 12, (uint8_t *)"ARM Cortex M0 Series");	
    LCD_ShowString(0, 264, lcddev.width, 12, WHITE, 12, (uint8_t *)"Product MG32F02A");
    LCD_ShowString(0, 276, lcddev.width, 12, WHITE, 12, (uint8_t *)"Show Features");
    LCD_ShowString(0, 288, lcddev.width, 12, WHITE, 12, (uint8_t *)"2018/02/17");
    __LCD_BackLight_On();
}



void LCD_Random_Text(void)
{   uint16_t lCount = 50;
    LCD_Clear(0xE71C);
    LCD_ShowString(0, 80, lcddev.width, 24, 0x001F, 24, (uint8_t *)"Megawin Company");
    LCD_ShowString(0, 104, lcddev.width, 24, 0x33E0, 24, (uint8_t *)"ARM Cortex-M0 Series");
    LCD_ShowString(0, 128, lcddev.width, 24, 0xF100, 24, (uint8_t *)"Product MG32F02A");
    Delay(1000);
    do{
        LCD_ShowString(rand() % 240, rand() % 320, lcddev.width, 24, rand() % 0xFFFF, 24, (uint8_t *)"Megawin Company");
        LCD_ShowString(rand() % 240, rand() % 320, lcddev.width, 24, rand() % 0xFFFF, 24, (uint8_t *)"ARM Cortex-M0 Series");
        LCD_ShowString(rand() % 240, rand() % 320, lcddev.width, 24, rand() % 0xFFFF, 24, (uint8_t *)"Product MG32F02A");	
    }while(-- lCount != 0);
}


void LCD_Random_Line(void)
{
    uint16_t lCount = 500;
    LCD_Clear(BLACK);
    do{
        LCD_DrawLine(rand() % 240, rand() % 320, rand() % 240, rand() % 320, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

void LCD_Random_Rectangle(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_DrawRectangle(rand() % 240, rand() % 320, rand() % 240, rand() % 320, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

void LCD_Random_Fill(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_Fill(rand() % 120, rand() % 160, rand() % 120, rand() % 160, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

void LCD_Random_Circle(void)
{
    uint16_t lCount = 200;
    LCD_Clear(BLACK);
    do{
        LCD_Draw_Circle(rand() % 240, rand() % 320, rand() % 320, rand() % 0xFFFF);
    }while(-- lCount != 0);
}

void LCD_Random_Geometry(void)
{
    uint16_t lCount = 100;
    LCD_Clear(BLACK);
    do{
        LCD_DrawLine(rand() % 240, rand() % 320, rand() % 240, rand() % 320, rand() % 0xFFFF);
        LCD_DrawRectangle(rand() % 240, rand() % 320, rand() % 240, rand() % 320, rand() % 0xFFFF);
        LCD_Draw_Circle(rand() % 240, rand() % 320, rand() % 320, rand() % 0xFFFF);
    }while(-- lCount != 0);
}



typedef enum{
    LCD_Show_Logo = 1,
    LCD_Show_Text1,
//    LCD_Show_Text1 = 1,
    LCD_Show_GrayBar_1,
    LCD_Show_ColorBar1,
    LCD_Show_ColorBar2,
    LCD_Show_Line,
    LCD_Show_Rectangle,
    LCD_Show_Circle,
//    LCD_Show_Fill,
    LCD_Show_Geometry,
    LCD_Show_Text2,
    LCD_Show_Stop,
}LCD_Show_Typedef;



uint32_t            SPIFlashID;
uint32_t            ShowDelay = 0;
uint32_t            ShowDelayCapture;
MatrixKeyDef        key, oldkey;
RGB_MODE_TYPE       RGB1_Mode = RGB_Mode_SPECTRUM;
RGB_MODE_TYPE       RGB2_Mode = RGB_Mode_SPECTRUM;
RGB_MODE_TYPE       RGB3_Mode = RGB_Mode_SPECTRUM;
uint8_t             RGB1_light = 255;
uint8_t             RGB2_light = 255;
uint8_t             RGB3_light = 255;
uint8_t             DemoLoopEnable = 1;



void LCD_Show(uint8_t Template)
{
    switch(Template){
        case LCD_Show_Logo:
            SPIFlashID = MID_Flash_Read_ID();
            if((SPIFlashID == 0xFFFFFF) || (SPIFlashID == 0x00000000))
            {
                __LCD_BackLight_Off();
                LCD_Clear(BLACK);
                LCD_ShowString(0, 24, lcddev.width, 24, BRED, 24, (uint8_t *)"SPI Flash Not Ready");
                __LCD_BackLight_On();
            }
            else
                LCD_Show_Picture(1);
        break;
        case LCD_Show_GrayBar_1:
            LCD_GrayBar_1();
        break;
        case LCD_Show_ColorBar1:
            LCD_ColorBar_1();
        break;
        case LCD_Show_ColorBar2:
            LCD_ColorBar_2();
        break;
        case LCD_Show_Text1:
            LCD_Show_Text();
        break;
        case LCD_Show_Line:
            LCD_Random_Line();
        break;
        case LCD_Show_Rectangle:
            LCD_Random_Rectangle();
        break;
        case LCD_Show_Circle:
            LCD_Random_Circle();
        break;
//        case LCD_Show_Fill:
//            LCD_Random_Fill();
//        break;       
        case LCD_Show_Geometry:
            LCD_Random_Geometry();
        break;
        case LCD_Show_Text2:
            LCD_Random_Text();
        break;
        case LCD_Show_Stop:
        break;
    }
}



int main(void)
{
    LCD_Show_Typedef DemoTemplate = (LCD_Show_Typedef)2;
    LCD_Show_Typedef OldDemoTemplate = (LCD_Show_Typedef)0;
    uint8_t lcd_id[80];

    ChipInit();

    // Tick Initial
    // DRV_Return InitTick(uint32_t TickClock, uint32_t TickPriority)
    InitTick(48000000, 0);

    URT_Init(URT0);         // for Debug Information
    //URT_Init(URT2);         // for Debug Information
    printf("%c[2J",27);
    printf("%c[H",27);

    API_Flash_Init();       /* Need include to ChipInit(); */
    //printf("  SPI Flash ID %X \n\r", MID_Flash_Read_ID());    /* Read Flash ID */ // MID
    SPIFlashID = MID_Flash_Read_ID();
    LCD_Init();
    API_Key_Init();
    API_RGBLED_Init();      // RGB1 / RGB2 / RGB3 Inital ( RGB1/2/3 inital is OFF)
    IRQ_Init();
    printf("Initial Ready \n\r");

    // Sample_Code();

    // Setting RGB1 Color
    API_RGBColor_Select(&RGB1, 0, 255, 0);
    API_RGBColor_Select(&RGB2, 255, 0, 0);
    API_RGBColor_Select(&RGB3, 0, 0, 255);

    // Setting RGB1 Mode
    API_RGBMode_Select(&RGB1, RGB_Mode_SPECTRUM);
    API_RGBMode_Select(&RGB2, RGB_Mode_SPECTRUM);
    API_RGBMode_Select(&RGB3, RGB_Mode_SPECTRUM);

    LCD_Clear(BLACK);
    __LCD_BackLight_Off();
    LCD_ShowString(0, 0, lcddev.width, 24, GREEN, 24, (uint8_t *)"Initial Ready");
    sprintf((char *)lcd_id, "SPI Flash ID:%X", SPIFlashID);//?LCD ID???lcd_id??
    LCD_ShowString(0, 24, lcddev.width, 24, GBLUE, 24, lcd_id);
    sprintf((char *)lcd_id, "LCD ID:%04X",lcddev.id);//?LCD ID???lcd_id??
    LCD_ShowString(0, 48, lcddev.width, 24, GBLUE, 24, lcd_id);
    sprintf((char *)lcd_id, "Resolution %d x %d", lcddev.width, lcddev.height);//?LCD ID???lcd_id??
    LCD_ShowString(0, 72, lcddev.width, 24, YELLOW, 24, lcd_id);
    __LCD_BackLight_On();

    OldDemoTemplate = (LCD_Show_Typedef)0;
    DemoTemplate = (LCD_Show_Typedef)0;
    ShowDelayCapture = GetTick();
    ShowDelay = 1000;

    oldkey = NoPressKey;
    do{
        if(DemoLoopEnable != 0)
        {
            if((GetTick() - ShowDelayCapture) >= ShowDelay)
            {
                DemoTemplate++;
                if(DemoTemplate >= LCD_Show_Stop)
                    DemoTemplate = (LCD_Show_Typedef)1;

                SPIFlashID = MID_Flash_Read_ID();
                if((SPIFlashID == 0xFFFFFF) || (SPIFlashID == 0x00000000))
                    ShowDelay = 1000;
                else
                    ShowDelay = 3000;
                ShowDelayCapture = GetTick();
            }
        }

        if((TextList.ShowEnable == 0) && (OldDemoTemplate != DemoTemplate))
        {
            OldDemoTemplate = DemoTemplate;
            LCD_Show(DemoTemplate);
            switch(DemoTemplate){
                //case LCD_Show_Logo:
                case LCD_Show_Text1:
                case LCD_Show_GrayBar_1:
                case LCD_Show_ColorBar1:
                case LCD_Show_ColorBar2:
                    ShowDelay = 3000;
                    break;

                case LCD_Show_Line:
                case LCD_Show_Rectangle:
                case LCD_Show_Circle:
                //LCD_Show_Fill,
                case LCD_Show_Geometry:
                case LCD_Show_Text2:
                    ShowDelay = 1000;
                    break;
                case LCD_Show_Stop:
                    break;
            }
            ShowDelayCapture = GetTick();
        }

        key = API_ReadKey();
        if(oldkey == key)
            continue;

        oldkey = key;
        //printf("    Key = %d\n\r", key);

        switch(key){
            case SKey1:
                if(RGB2_Mode == RGB_Mode_SPECTRUM)
                    RGB2_Mode = RGB_Mode_OFF;
                else
                    RGB2_Mode ++;
                API_RGBMode_Select(&RGB2, RGB2_Mode);
                API_AddText2List((uint8_t *)"Left LED Mode", 20, 16, YELLOW);
                break;
            case SKey2:
                if (RGB2_light == 255)
                    RGB2_light = 0;
                else
                    if(RGB2_light > 204)
                        RGB2_light = 255;
                    else
                        RGB2_light += 51;
                RGB2_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB2, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB2, RGB2_light, 0, 0); 
                API_AddText2List((uint8_t *)"Left LED PWM +", 20, 16, YELLOW);
                break;
            case SKey3:
                if (RGB2_light == 0)
                    RGB2_light = 255;
                else
                    if(RGB2_light < 51)
                        RGB2_light = 0;
                    else
                        RGB2_light -= 51;
                RGB2_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB2, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB2, RGB2_light, 0, 0); 
                API_AddText2List((uint8_t *)"Left LED PWM -", 20, 16, YELLOW);
                break;
            case SKey4:
                DemoLoopEnable = 0;
                API_AddText2List((uint8_t *)"Escape", 20, 16, YELLOW);
                break;
            case SKey5: // Left
                DemoLoopEnable = 0;
                DemoTemplate--;
                if(DemoTemplate == (LCD_Show_Typedef)0)
                    DemoTemplate = LCD_Show_Text2;
                API_AddText2List((uint8_t *)"Left <", 20, 16, YELLOW);
                break;
            case SKey6:
                API_AddText2List((uint8_t *)"Loop Mode", 20, 16, YELLOW);
//                if(TextList.ShowEnable == 0)
//                    DemoTemplate++;
                TextList.ShowEnable = 0;
                ShowDelay = 0;
                ShowDelayCapture = GetTick();
                DemoLoopEnable = 1;
                break;
            case SKey7:
                if(RGB1_Mode == RGB_Mode_SPECTRUM)
                    RGB1_Mode = RGB_Mode_OFF;
                else
                    RGB1_Mode ++;
                API_RGBMode_Select(&RGB1, RGB1_Mode);
                API_AddText2List((uint8_t *)"Center LED Mode", 20, 16, YELLOW);
                break;
            case SKey8:
                if (RGB1_light == 255)
                    RGB1_light = 0;
                else
                    if(RGB1_light > 204)
                        RGB1_light = 255;
                    else
                        RGB1_light += 51;
                RGB1_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB1, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB1, 0, RGB1_light, 0);
                API_AddText2List((uint8_t *)"Center LED PWM +", 20, 16, YELLOW);
                break;
            case SKey9:
                if (RGB1_light == 0)
                    RGB1_light = 255;
                else
                    if(RGB1_light < 51)
                        RGB1_light = 0;
                    else
                        RGB1_light -= 51;
                RGB1_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB1, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB1, 0, RGB1_light, 0); 
                API_AddText2List((uint8_t *)"Center LED PWM -", 20, 16, YELLOW);
                break;
            case SKey10:// Up
                DemoLoopEnable = 0;
                API_AddText2List((uint8_t *)"Up ^", 20, 16, YELLOW);
                break;
            case SKey11://
                DemoLoopEnable = 0;
                API_AddText2List((uint8_t *)"Enter ", 20, 16, YELLOW);
                break;
            case SKey12:// Down
                DemoLoopEnable = 0;
                API_AddText2List((uint8_t *)"Down v", 20, 16, YELLOW);
                break;
            case PKey1:
                if(RGB3_Mode == RGB_Mode_SPECTRUM)
                    RGB3_Mode = RGB_Mode_OFF;
                else
                    RGB3_Mode ++;
                API_RGBMode_Select(&RGB3, RGB3_Mode);
                API_AddText2List((uint8_t *)"Right LED Mode", 20, 16, YELLOW);
                break;
            case PKey2:
                if (RGB3_light == 255)
                    RGB3_light = 0;
                else
                    if(RGB3_light > 204)
                        RGB3_light = 255;
                    else
                        RGB3_light += 51;
                RGB3_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB3, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB3, 0, 0, RGB3_light);
                API_AddText2List((uint8_t *)"Right LED PWM +", 20, 16, YELLOW);
                break;
            case PKey3:
                if (RGB3_light == 0)
                    RGB3_light = 255;
                else
                    if(RGB3_light < 51)
                        RGB3_light = 0;
                    else
                        RGB3_light -= 51;
                RGB3_Mode = RGB_Mode_STATIC;
                API_RGBMode_Select(&RGB3, RGB_Mode_STATIC);
                API_RGBColor_Select(&RGB3, 0, 0, RGB3_light);
                API_AddText2List((uint8_t *)"Right LED PWM -", 20, 16, YELLOW);
                break;
            case PKey4:
                DemoLoopEnable = 0;
                API_AddText2List((uint8_t *)"Return", 20, 16, YELLOW);
                break;
            case PKey5: // Right
                DemoLoopEnable = 0;
                DemoTemplate++;
                if(DemoTemplate >= LCD_Show_Stop)
                    DemoTemplate = (LCD_Show_Typedef)1;
                API_AddText2List((uint8_t *)"Right >", 20, 16, YELLOW);
                break;
            case PKey6:
                DemoLoopEnable = 0;
                TextList.ShowEnable = 1;
                API_AddText2List((uint8_t *)"Key Oprating Log", 20, 16, YELLOW);
                break;
            case NoPressKey:
            default:
                break;
        }
    }while(1);
}
//    do
//    {
//        LCD_Clear(WHITE);
//        __LCD_BackLight_Off();
//        LCD_DrawLine(0, 0 , 0, 320, BLACK);
//        LCD_DrawLine(80, 0 , 80, 320, BLACK);
//        LCD_DrawLine(81, 0 , 81, 320, BLACK);
//        LCD_DrawLine(160, 0 ,160, 320, BLACK);
//        LCD_DrawLine(161, 0 ,161, 320, BLACK);
//        LCD_DrawLine(240, 0 ,240, 320, BLACK);
//        LCD_DrawLine(0, 0 , 240, 0, BLACK);
//        LCD_DrawLine(0, 64 , 240, 64, BLACK);
//        LCD_DrawLine(0, 65 , 240, 65, BLACK);
//        LCD_DrawLine(0, 128 , 240, 128, BLACK);
//        LCD_DrawLine(0, 129 , 240, 129, BLACK);
//        LCD_DrawLine(0, 192 , 240, 192, BLACK);
//        LCD_DrawLine(0, 193 , 240, 193, BLACK);
//        LCD_DrawLine(0, 256 , 240, 256, BLACK);
//        LCD_DrawLine(0, 257 , 240, 257, BLACK);
//        LCD_DrawLine(0, 320 , 240, 320, BLACK);
//        __LCD_BackLight_On();
//        Delay(3000);


//        //To do......
//    }while(1);


