/**
 ******************************************************************************
 * @file     system_MG32.h
 * @brief    CMSIS Cortex-M# Device Peripheral Access Layer Source File for
 *           Device MG32
 * @version  V1.10
 * @date     2023/06/25
 *
 * @note
 *
 ******************************************************************************
 * Copyright (c) 2012 ARM LIMITED

  All rights reserved.
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
  - Neither the name of ARM nor the names of its contributors may be used
    to endorse or promote products derived from this software without
    specific prior written permission.
  *
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
  ---------------------------------------------------------------------------
  */

#ifndef _system_MG32_H
#define _system_MG32_H



#ifdef __cplusplus
 extern "C" {
#endif

/*----------------------------------------------------------------------------
  Define clocks
 *----------------------------------------------------------------------------*/
/* ToDo: add here your necessary defines for device initialization
         following is an example for different system frequencies             */
#define __IHRCO_FREQ           (12000000UL)     /* On-Chip Internal frequency 12000000 / 11059200 Hz      */
#define __XTAL_FREQ            (12000000UL)     /* Oscillator frequency             */
#define __EXTCK_FREQ           (12000000UL)     /* External Clock frequency         */
#define __SYSTEM_CLOCK         (__IHRCO_FREQ)   /* User Define Default CK_AHB Clock */
/**
 *************************************************
 *  Chip definitions
 *************************************************
 */
// Chip Generation

#define MG32_1ST
/**
 * @name    Function announce
 *
 */
void SystemCoreClockUpdate(void);
void SystemInit (void);
void HardFault_Handler_C(unsigned int * hardfault_args, unsigned lr_value) __attribute__((noreturn));

#ifdef __cplusplus
}
#endif

/*----------------------------------------------------------------------------*/
/*                       End of file system_MG32.h                        */
/*----------------------------------------------------------------------------*/
#endif

