/**
 ******************************************************************************
 *
 * @file        MG32_CPU.h
 *
 * @brief       MG32 CPU Register Definitions Header File
 *
 * @par         Project
 *              MG32
 * @version     V3.92 (Register File Date : 2022_1109)
 * @date        2022/12/14 14:57 (H File Generated Date)
 * @author      HeadCodeGen V1.44
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32_CPU_H
#define _MG32_CPU_H
#define _MG32_CPU_H_VER                         392     /*!< File Version */

#include "MG32.h"

#if !(_MG32_H_VER == _MG32_CPU_H_VER)
    #error "_MG32_CPU_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      CPU_Struct
 *              CPU  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    __I  uint32_t  RESERVED0[4];        /*!< Offset[0x00]   Reserved */

    __IO uint32_t  SYST_CSR;            /*!< Offset[0x10]   CPU SysTick Control and Status Register */
    __IO uint32_t  SYST_RVR;            /*!< Offset[0x14]   CPU SysTick Reload Value Register */
    __IO uint32_t  SYST_CVR;            /*!< Offset[0x18]   CPU SysTick Current Value Register */
    __I  uint32_t  SYST_CALIB;          /*!< Offset[0x1C]   CPU SysTick Calibration Value Register */
    __I  uint32_t  RESERVED1[56];       /*!< Offset[0x20]   Reserved */

    __IO uint32_t  ISER;                /*!< Offset[0x100]  CPU Interrupt Set-enable Register */
    __I  uint32_t  RESERVED2[31];       /*!< Offset[0x104]  Reserved */

    __IO uint32_t  ICER;                /*!< Offset[0x180]  CPU Interrupt Clear-enable Register */
    __I  uint32_t  RESERVED3[31];       /*!< Offset[0x184]  Reserved */

    __IO uint32_t  ISPR;                /*!< Offset[0x200]  CPU Interrupt Set-pending Register */
    __I  uint32_t  RESERVED4[31];       /*!< Offset[0x204]  Reserved */

    __IO uint32_t  ICPR;                /*!< Offset[0x280]  CPU Interrupt Clear-pending Register */
    __I  uint32_t  RESERVED5[95];       /*!< Offset[0x284]  Reserved */

    __IO uint32_t  IPR0;                /*!< Offset[0x400]  CPU Interrupt Priority Registers 0 */
    __IO uint32_t  IPR1;                /*!< Offset[0x404]  CPU Interrupt Priority Registers 1 */
    __IO uint32_t  IPR2;                /*!< Offset[0x408]  CPU Interrupt Priority Registers 2 */
    __IO uint32_t  IPR3;                /*!< Offset[0x40C]  CPU Interrupt Priority Registers 3 */
    __IO uint32_t  IPR4;                /*!< Offset[0x410]  CPU Interrupt Priority Registers 4 */
    __IO uint32_t  IPR5;                /*!< Offset[0x414]  CPU Interrupt Priority Registers 5 */
    __IO uint32_t  IPR6;                /*!< Offset[0x418]  CPU Interrupt Priority Registers 6 */
    __IO uint32_t  IPR7;                /*!< Offset[0x41C]  CPU Interrupt Priority Registers 7 */
    __I  uint32_t  RESERVED6[568];      /*!< Offset[0x420]  Reserved */

    __I  uint32_t  CPUID;               /*!< Offset[0xD00]  CPU ID Register */
    __IO uint32_t  ICSR;                /*!< Offset[0xD04]  CPU Interrupt Control and State Register */
    __I  uint32_t  RESERVED7;           /*!< Offset[0xD08]  Reserved */

    __IO uint32_t  AIRCR;               /*!< Offset[0xD0C]  CPU Application Interrupt and Reset Control Register */
    __IO uint32_t  SCR;                 /*!< Offset[0xD10]  CPU System Control Register */
    __I  uint32_t  CCR;                 /*!< Offset[0xD14]  CPU Configuration and Control Register */
    __I  uint32_t  RESERVED8;           /*!< Offset[0xD18]  Reserved */

    __IO uint32_t  SHPR2;               /*!< Offset[0xD1C]  CPU System Handler Priority Register 2 */
    __IO uint32_t  SHPR3;               /*!< Offset[0xD20]  CPU System Handler Priority Register 3 */
} CPU_Struct;

/**
 ******************************************************************************
 *
 * @name        CPU  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define CPU_Base                        ((uint32_t)0xE000E000)              /*!< CPU Private Peripheral Bus Control */
#define CPU                             ((CPU_Struct*) CPU_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        CPU  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        CPU_SYST_CSR  [register's definitions]
 *              Offset[0x10]  CPU SysTick Control and Status Register (0xE000E010)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CSR_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SYST_CSR */
#define CPU_SYST_CSR_COUNTFLAG_mask_w               ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CSR_COUNTFLAG_mask_h1              ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CSR_COUNTFLAG_mask_b2              ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CSR_COUNTFLAG_shift_w              (16)                    /*!< Bit Shift of 32bit */
#define CPU_SYST_CSR_COUNTFLAG_shift_h1             (0)                     /*!< Bit Shift of 16bit */
#define CPU_SYST_CSR_COUNTFLAG_shift_b2             (0)                     /*!< Bit Shift of 8bit */

#define CPU_SYST_CSR_CLKSOURCE_mask_w               ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CSR_CLKSOURCE_mask_h0              ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CSR_CLKSOURCE_mask_b0              ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CSR_CLKSOURCE_reference_clock_w    ((uint32_t)0x00000000)  /*!< Bit Value =(0):reference clock of 32bit */
#define CPU_SYST_CSR_CLKSOURCE_reference_clock_h0   ((uint16_t)0x0000)      /*!< Bit Value =(0):reference clock of 16bit */
#define CPU_SYST_CSR_CLKSOURCE_reference_clock_b0   ((uint8_t )0x00)        /*!< Bit Value =(0):reference clock of 8bit */
#define CPU_SYST_CSR_CLKSOURCE_processor_clock_w    ((uint32_t)0x00000004)  /*!< Bit Value =(1):processor clock of 32bit */
#define CPU_SYST_CSR_CLKSOURCE_processor_clock_h0   ((uint16_t)0x0004)      /*!< Bit Value =(1):processor clock of 16bit */
#define CPU_SYST_CSR_CLKSOURCE_processor_clock_b0   ((uint8_t )0x04)        /*!< Bit Value =(1):processor clock of 8bit */

#define CPU_SYST_CSR_TICKINT_mask_w                 ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CSR_TICKINT_mask_h0                ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CSR_TICKINT_mask_b0                ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CSR_TICKINT_notassert_w            ((uint32_t)0x00000000)  /*!< Bit Value =(0):NotAssert of 32bit */
#define CPU_SYST_CSR_TICKINT_notassert_h0           ((uint16_t)0x0000)      /*!< Bit Value =(0):NotAssert of 16bit */
#define CPU_SYST_CSR_TICKINT_notassert_b0           ((uint8_t )0x00)        /*!< Bit Value =(0):NotAssert of 8bit */
#define CPU_SYST_CSR_TICKINT_assert_w               ((uint32_t)0x00000002)  /*!< Bit Value =(1):Assert of 32bit */
#define CPU_SYST_CSR_TICKINT_assert_h0              ((uint16_t)0x0002)      /*!< Bit Value =(1):Assert of 16bit */
#define CPU_SYST_CSR_TICKINT_assert_b0              ((uint8_t )0x02)        /*!< Bit Value =(1):Assert of 8bit */

#define CPU_SYST_CSR_ENCNT_mask_w                   ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CSR_ENCNT_mask_h0                  ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CSR_ENCNT_mask_b0                  ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CSR_ENCNT_disable_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define CPU_SYST_CSR_ENCNT_disable_h0               ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define CPU_SYST_CSR_ENCNT_disable_b0               ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define CPU_SYST_CSR_ENCNT_enable_w                 ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define CPU_SYST_CSR_ENCNT_enable_h0                ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define CPU_SYST_CSR_ENCNT_enable_b0                ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_RVR  [register's definitions]
 *              Offset[0x14]  CPU SysTick Reload Value Register (0xE000E014)
 ******************************************************************************
 */
///@{
#define CPU_SYST_RVR_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SYST_RVR */
#define CPU_SYST_RVR_RELOAD_mask_w                  ((uint32_t)0x00FFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_SYST_RVR_RELOAD_shift_w                 (0)                     /*!< Bit Shift of 32bit */
#define CPU_SYST_RVR_RELOAD_shift_h0                (0)                     /*!< Bit Shift of 16bit */
#define CPU_SYST_RVR_RELOAD_shift_b0                (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CVR  [register's definitions]
 *              Offset[0x18]  CPU SysTick Current Value Register (0xE000E018)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CVR_default                        ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SYST_CVR */
#define CPU_SYST_CVR_CURRENT_mask_w                 ((uint32_t)0x00FFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CVR_CURRENT_shift_w                (0)                     /*!< Bit Shift of 32bit */
#define CPU_SYST_CVR_CURRENT_shift_h0               (0)                     /*!< Bit Shift of 16bit */
#define CPU_SYST_CVR_CURRENT_shift_b0               (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SYST_CALIB  [register's definitions]
 *              Offset[0x1C]  CPU SysTick Calibration Value Register (0xE000E01C)
 ******************************************************************************
 */
///@{
#define CPU_SYST_CALIB_default                      ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SYST_CALIB */
#define CPU_SYST_CALIB_NOREF_mask_w                 ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CALIB_NOREF_mask_h1                ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CALIB_NOREF_mask_b3                ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CALIB_NOREF_refer_w                ((uint32_t)0x00000000)  /*!< Bit Value =(0):Refer of 32bit */
#define CPU_SYST_CALIB_NOREF_refer_h1               ((uint16_t)0x0000)      /*!< Bit Value =(0):Refer of 16bit */
#define CPU_SYST_CALIB_NOREF_refer_b3               ((uint8_t )0x00)        /*!< Bit Value =(0):Refer of 8bit */
#define CPU_SYST_CALIB_NOREF_proc_w                 ((uint32_t)0x80000000)  /*!< Bit Value =(1):Proc of 32bit */
#define CPU_SYST_CALIB_NOREF_proc_h1                ((uint16_t)0x8000)      /*!< Bit Value =(1):Proc of 16bit */
#define CPU_SYST_CALIB_NOREF_proc_b3                ((uint8_t )0x80)        /*!< Bit Value =(1):Proc of 8bit */

#define CPU_SYST_CALIB_SKEW_mask_w                  ((uint32_t)0x40000000)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CALIB_SKEW_mask_h1                 ((uint16_t)0x4000)      /*!< Bit Mask of 16bit */
#define CPU_SYST_CALIB_SKEW_mask_b3                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CPU_SYST_CALIB_SKEW_exact_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):exact of 32bit */
#define CPU_SYST_CALIB_SKEW_exact_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):exact of 16bit */
#define CPU_SYST_CALIB_SKEW_exact_b3                ((uint8_t )0x00)        /*!< Bit Value =(0):exact of 8bit */
#define CPU_SYST_CALIB_SKEW_inexact_w               ((uint32_t)0x40000000)  /*!< Bit Value =(1):inexact of 32bit */
#define CPU_SYST_CALIB_SKEW_inexact_h1              ((uint16_t)0x4000)      /*!< Bit Value =(1):inexact of 16bit */
#define CPU_SYST_CALIB_SKEW_inexact_b3              ((uint8_t )0x40)        /*!< Bit Value =(1):inexact of 8bit */

#define CPU_SYST_CALIB_TENMS_mask_w                 ((uint32_t)0x00FFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_SYST_CALIB_TENMS_shift_w                (0)                     /*!< Bit Shift of 32bit */
#define CPU_SYST_CALIB_TENMS_shift_h0               (0)                     /*!< Bit Shift of 16bit */
#define CPU_SYST_CALIB_TENMS_shift_b0               (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_ISER  [register's definitions]
 *              Offset[0x100]  CPU Interrupt Set-enable Register (0xE000E100)
 ******************************************************************************
 */
///@{
#define CPU_ISER_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_ISER */
#define CPU_ISER_SETENA_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_ISER_SETENA_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CPU_ISER_SETENA_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CPU_ISER_SETENA_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_ICER  [register's definitions]
 *              Offset[0x180]  CPU Interrupt Clear-enable Register (0xE000E180)
 ******************************************************************************
 */
///@{
#define CPU_ICER_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_ICER */
#define CPU_ICER_CLRENA_mask_w                      ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_ICER_CLRENA_shift_w                     (0)                     /*!< Bit Shift of 32bit */
#define CPU_ICER_CLRENA_shift_h0                    (0)                     /*!< Bit Shift of 16bit */
#define CPU_ICER_CLRENA_shift_b0                    (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_ISPR  [register's definitions]
 *              Offset[0x200]  CPU Interrupt Set-pending Register (0xE000E200)
 ******************************************************************************
 */
///@{
#define CPU_ISPR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_ISPR */
#define CPU_ISPR_SETPEND_mask_w                     ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_ISPR_SETPEND_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CPU_ISPR_SETPEND_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CPU_ISPR_SETPEND_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_ICPR  [register's definitions]
 *              Offset[0x280]  CPU Interrupt Clear-pending Register (0xE000E280)
 ******************************************************************************
 */
///@{
#define CPU_ICPR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_ICPR */
#define CPU_ICPR_CLRPEND_mask_w                     ((uint32_t)0xFFFFFFFF)  /*!< Bit Mask of 32bit */
#define CPU_ICPR_CLRPEND_shift_w                    (0)                     /*!< Bit Shift of 32bit */
#define CPU_ICPR_CLRPEND_shift_h0                   (0)                     /*!< Bit Shift of 16bit */
#define CPU_ICPR_CLRPEND_shift_b0                   (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR0  [register's definitions]
 *              Offset[0x400]  CPU Interrupt Priority Registers 0 (0xE000E400)
 ******************************************************************************
 */
///@{
#define CPU_IPR0_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR0 */
#define CPU_IPR0_PRI_3_mask_w                       ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR0_PRI_3_mask_h1                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR0_PRI_3_mask_b3                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR0_PRI_3_shift_w                      (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR0_PRI_3_shift_h1                     (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR0_PRI_3_shift_b3                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR0_PRI_2_mask_w                       ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR0_PRI_2_mask_h1                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR0_PRI_2_mask_b2                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR0_PRI_2_shift_w                      (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR0_PRI_2_shift_h1                     (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR0_PRI_2_shift_b2                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR0_PRI_1_mask_w                       ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR0_PRI_1_mask_h0                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR0_PRI_1_mask_b1                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR0_PRI_1_shift_w                      (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR0_PRI_1_shift_h0                     (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR0_PRI_1_shift_b1                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR0_PRI_0_mask_w                       ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR0_PRI_0_mask_h0                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR0_PRI_0_mask_b0                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR0_PRI_0_shift_w                      (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR0_PRI_0_shift_h0                     (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR0_PRI_0_shift_b0                     (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR1  [register's definitions]
 *              Offset[0x404]  CPU Interrupt Priority Registers 1 (0xE000E404)
 ******************************************************************************
 */
///@{
#define CPU_IPR1_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR1 */
#define CPU_IPR1_PRI_7_mask_w                       ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR1_PRI_7_mask_h1                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR1_PRI_7_mask_b3                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR1_PRI_7_shift_w                      (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR1_PRI_7_shift_h1                     (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR1_PRI_7_shift_b3                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR1_PRI_6_mask_w                       ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR1_PRI_6_mask_h1                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR1_PRI_6_mask_b2                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR1_PRI_6_shift_w                      (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR1_PRI_6_shift_h1                     (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR1_PRI_6_shift_b2                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR1_PRI_5_mask_w                       ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR1_PRI_5_mask_h0                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR1_PRI_5_mask_b1                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR1_PRI_5_shift_w                      (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR1_PRI_5_shift_h0                     (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR1_PRI_5_shift_b1                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR1_PRI_4_mask_w                       ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR1_PRI_4_mask_h0                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR1_PRI_4_mask_b0                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR1_PRI_4_shift_w                      (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR1_PRI_4_shift_h0                     (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR1_PRI_4_shift_b0                     (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR2  [register's definitions]
 *              Offset[0x408]  CPU Interrupt Priority Registers 2 (0xE000E408)
 ******************************************************************************
 */
///@{
#define CPU_IPR2_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR2 */
#define CPU_IPR2_PRI_11_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR2_PRI_11_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR2_PRI_11_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR2_PRI_11_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR2_PRI_11_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR2_PRI_11_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR2_PRI_10_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR2_PRI_10_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR2_PRI_10_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR2_PRI_10_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR2_PRI_10_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR2_PRI_10_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR2_PRI_9_mask_w                       ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR2_PRI_9_mask_h0                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR2_PRI_9_mask_b1                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR2_PRI_9_shift_w                      (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR2_PRI_9_shift_h0                     (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR2_PRI_9_shift_b1                     (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR2_PRI_8_mask_w                       ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR2_PRI_8_mask_h0                      ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR2_PRI_8_mask_b0                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR2_PRI_8_shift_w                      (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR2_PRI_8_shift_h0                     (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR2_PRI_8_shift_b0                     (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR3  [register's definitions]
 *              Offset[0x40C]  CPU Interrupt Priority Registers 3 (0xE000E40C)
 ******************************************************************************
 */
///@{
#define CPU_IPR3_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR3 */
#define CPU_IPR3_PRI_15_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR3_PRI_15_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR3_PRI_15_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR3_PRI_15_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR3_PRI_15_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR3_PRI_15_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR3_PRI_14_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR3_PRI_14_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR3_PRI_14_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR3_PRI_14_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR3_PRI_14_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR3_PRI_14_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR3_PRI_13_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR3_PRI_13_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR3_PRI_13_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR3_PRI_13_shift_w                     (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR3_PRI_13_shift_h0                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR3_PRI_13_shift_b1                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR3_PRI_12_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR3_PRI_12_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR3_PRI_12_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR3_PRI_12_shift_w                     (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR3_PRI_12_shift_h0                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR3_PRI_12_shift_b0                    (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR4  [register's definitions]
 *              Offset[0x410]  CPU Interrupt Priority Registers 4 (0xE000E410)
 ******************************************************************************
 */
///@{
#define CPU_IPR4_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR4 */
#define CPU_IPR4_PRI_19_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR4_PRI_19_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR4_PRI_19_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR4_PRI_19_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR4_PRI_19_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR4_PRI_19_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR4_PRI_18_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR4_PRI_18_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR4_PRI_18_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR4_PRI_18_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR4_PRI_18_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR4_PRI_18_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR4_PRI_17_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR4_PRI_17_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR4_PRI_17_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR4_PRI_17_shift_w                     (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR4_PRI_17_shift_h0                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR4_PRI_17_shift_b1                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR4_PRI_16_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR4_PRI_16_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR4_PRI_16_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR4_PRI_16_shift_w                     (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR4_PRI_16_shift_h0                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR4_PRI_16_shift_b0                    (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR5  [register's definitions]
 *              Offset[0x414]  CPU Interrupt Priority Registers 5 (0xE000E414)
 ******************************************************************************
 */
///@{
#define CPU_IPR5_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR5 */
#define CPU_IPR5_PRI_23_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR5_PRI_23_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR5_PRI_23_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR5_PRI_23_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR5_PRI_23_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR5_PRI_23_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR5_PRI_22_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR5_PRI_22_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR5_PRI_22_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR5_PRI_22_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR5_PRI_22_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR5_PRI_22_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR5_PRI_21_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR5_PRI_21_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR5_PRI_21_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR5_PRI_21_shift_w                     (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR5_PRI_21_shift_h0                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR5_PRI_21_shift_b1                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR5_PRI_20_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR5_PRI_20_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR5_PRI_20_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR5_PRI_20_shift_w                     (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR5_PRI_20_shift_h0                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR5_PRI_20_shift_b0                    (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR6  [register's definitions]
 *              Offset[0x418]  CPU Interrupt Priority Registers 6 (0xE000E418)
 ******************************************************************************
 */
///@{
#define CPU_IPR6_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR6 */
#define CPU_IPR6_PRI_27_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR6_PRI_27_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR6_PRI_27_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR6_PRI_27_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR6_PRI_27_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR6_PRI_27_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR6_PRI_26_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR6_PRI_26_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR6_PRI_26_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR6_PRI_26_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR6_PRI_26_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR6_PRI_26_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR6_PRI_25_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR6_PRI_25_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR6_PRI_25_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR6_PRI_25_shift_w                     (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR6_PRI_25_shift_h0                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR6_PRI_25_shift_b1                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR6_PRI_24_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR6_PRI_24_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR6_PRI_24_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR6_PRI_24_shift_w                     (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR6_PRI_24_shift_h0                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR6_PRI_24_shift_b0                    (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_IPR7  [register's definitions]
 *              Offset[0x41C]  CPU Interrupt Priority Registers 7 (0xE000E41C)
 ******************************************************************************
 */
///@{
#define CPU_IPR7_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_IPR7 */
#define CPU_IPR7_PRI_31_mask_w                      ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_IPR7_PRI_31_mask_h1                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR7_PRI_31_mask_b3                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR7_PRI_31_shift_w                     (30)                    /*!< Bit Shift of 32bit */
#define CPU_IPR7_PRI_31_shift_h1                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR7_PRI_31_shift_b3                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR7_PRI_30_mask_w                      ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_IPR7_PRI_30_mask_h1                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR7_PRI_30_mask_b2                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR7_PRI_30_shift_w                     (22)                    /*!< Bit Shift of 32bit */
#define CPU_IPR7_PRI_30_shift_h1                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR7_PRI_30_shift_b2                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR7_PRI_29_mask_w                      ((uint32_t)0x0000C000)  /*!< Bit Mask of 32bit */
#define CPU_IPR7_PRI_29_mask_h0                     ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_IPR7_PRI_29_mask_b1                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR7_PRI_29_shift_w                     (14)                    /*!< Bit Shift of 32bit */
#define CPU_IPR7_PRI_29_shift_h0                    (14)                    /*!< Bit Shift of 16bit */
#define CPU_IPR7_PRI_29_shift_b1                    (6)                     /*!< Bit Shift of 8bit */

#define CPU_IPR7_PRI_28_mask_w                      ((uint32_t)0x000000C0)  /*!< Bit Mask of 32bit */
#define CPU_IPR7_PRI_28_mask_h0                     ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_IPR7_PRI_28_mask_b0                     ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_IPR7_PRI_28_shift_w                     (6)                     /*!< Bit Shift of 32bit */
#define CPU_IPR7_PRI_28_shift_h0                    (6)                     /*!< Bit Shift of 16bit */
#define CPU_IPR7_PRI_28_shift_b0                    (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_CPUID  [register's definitions]
 *              Offset[0xD00]  CPU ID Register (0xE000ED00)
 ******************************************************************************
 */
///@{
#define CPU_CPUID_default                           ((uint32_t)0x410CC200)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_CPUID */
#define CPU_CPUID_IMPLEMENTER_mask_w                ((uint32_t)0xFF000000)  /*!< Bit Mask of 32bit */
#define CPU_CPUID_IMPLEMENTER_mask_h1               ((uint16_t)0xFF00)      /*!< Bit Mask of 16bit */
#define CPU_CPUID_IMPLEMENTER_mask_b3               ((uint8_t )0xFF)        /*!< Bit Mask of 8bit */
#define CPU_CPUID_IMPLEMENTER_shift_w               (24)                    /*!< Bit Shift of 32bit */
#define CPU_CPUID_IMPLEMENTER_shift_h1              (8)                     /*!< Bit Shift of 16bit */
#define CPU_CPUID_IMPLEMENTER_shift_b3              (0)                     /*!< Bit Shift of 8bit */

#define CPU_CPUID_VARIANT_mask_w                    ((uint32_t)0x00F00000)  /*!< Bit Mask of 32bit */
#define CPU_CPUID_VARIANT_mask_h1                   ((uint16_t)0x00F0)      /*!< Bit Mask of 16bit */
#define CPU_CPUID_VARIANT_mask_b2                   ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define CPU_CPUID_VARIANT_shift_w                   (20)                    /*!< Bit Shift of 32bit */
#define CPU_CPUID_VARIANT_shift_h1                  (4)                     /*!< Bit Shift of 16bit */
#define CPU_CPUID_VARIANT_shift_b2                  (4)                     /*!< Bit Shift of 8bit */

#define CPU_CPUID_CONSTANT_mask_w                   ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define CPU_CPUID_CONSTANT_mask_h1                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CPU_CPUID_CONSTANT_mask_b2                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CPU_CPUID_CONSTANT_shift_w                  (16)                    /*!< Bit Shift of 32bit */
#define CPU_CPUID_CONSTANT_shift_h1                 (0)                     /*!< Bit Shift of 16bit */
#define CPU_CPUID_CONSTANT_shift_b2                 (0)                     /*!< Bit Shift of 8bit */

#define CPU_CPUID_PARTNO_mask_w                     ((uint32_t)0x0000FFF0)  /*!< Bit Mask of 32bit */
#define CPU_CPUID_PARTNO_mask_h0                    ((uint16_t)0xFFF0)      /*!< Bit Mask of 16bit */
#define CPU_CPUID_PARTNO_shift_w                    (4)                     /*!< Bit Shift of 32bit */
#define CPU_CPUID_PARTNO_shift_h0                   (4)                     /*!< Bit Shift of 16bit */
#define CPU_CPUID_PARTNO_shift_b0                   (4)                     /*!< Bit Shift of 8bit */

#define CPU_CPUID_REVISION_mask_w                   ((uint32_t)0x0000000F)  /*!< Bit Mask of 32bit */
#define CPU_CPUID_REVISION_mask_h0                  ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define CPU_CPUID_REVISION_mask_b0                  ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */
#define CPU_CPUID_REVISION_shift_w                  (0)                     /*!< Bit Shift of 32bit */
#define CPU_CPUID_REVISION_shift_h0                 (0)                     /*!< Bit Shift of 16bit */
#define CPU_CPUID_REVISION_shift_b0                 (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_ICSR  [register's definitions]
 *              Offset[0xD04]  CPU Interrupt Control and State Register (0xE000ED04)
 ******************************************************************************
 */
///@{
#define CPU_ICSR_default                            ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_ICSR */
#define CPU_ICSR_NMIPENDSET_mask_w                  ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_NMIPENDSET_mask_h1                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_NMIPENDSET_mask_b3                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_NMIPENDSET_shift_w                 (31)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_NMIPENDSET_shift_h1                (15)                    /*!< Bit Shift of 16bit */
#define CPU_ICSR_NMIPENDSET_shift_b3                (7)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_PENDSVSET_mask_w                   ((uint32_t)0x10000000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_PENDSVSET_mask_h1                  ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_PENDSVSET_mask_b3                  ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_PENDSVSET_shift_w                  (28)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_PENDSVSET_shift_h1                 (12)                    /*!< Bit Shift of 16bit */
#define CPU_ICSR_PENDSVSET_shift_b3                 (4)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_PENDSVCLR_mask_w                   ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_PENDSVCLR_mask_h1                  ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_PENDSVCLR_mask_b3                  ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_PENDSVCLR_shift_w                  (27)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_PENDSVCLR_shift_h1                 (11)                    /*!< Bit Shift of 16bit */
#define CPU_ICSR_PENDSVCLR_shift_b3                 (3)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_PENDSTSET_mask_w                   ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_PENDSTSET_mask_h1                  ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_PENDSTSET_mask_b3                  ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_PENDSTSET_shift_w                  (26)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_PENDSTSET_shift_h1                 (10)                    /*!< Bit Shift of 16bit */
#define CPU_ICSR_PENDSTSET_shift_b3                 (2)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_PENDSTCLR_mask_w                   ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_PENDSTCLR_mask_h1                  ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_PENDSTCLR_mask_b3                  ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_PENDSTCLR_shift_w                  (25)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_PENDSTCLR_shift_h1                 (9)                     /*!< Bit Shift of 16bit */
#define CPU_ICSR_PENDSTCLR_shift_b3                 (1)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_ISRPENDING_mask_w                  ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_ISRPENDING_mask_h1                 ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_ISRPENDING_mask_b2                 ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_ISRPENDING_shift_w                 (22)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_ISRPENDING_shift_h1                (6)                     /*!< Bit Shift of 16bit */
#define CPU_ICSR_ISRPENDING_shift_b2                (6)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_VECTPENDING_mask_w                 ((uint32_t)0x0003F000)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_VECTPENDING_mask_h0                ((uint16_t)0xF000)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_VECTPENDING_mask_b1                ((uint8_t )0xF0)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_VECTPENDING_shift_w                (12)                    /*!< Bit Shift of 32bit */
#define CPU_ICSR_VECTPENDING_shift_h0               (12)                    /*!< Bit Shift of 16bit */
#define CPU_ICSR_VECTPENDING_shift_b1               (4)                     /*!< Bit Shift of 8bit */

#define CPU_ICSR_VECTACTIVE_mask_w                  ((uint32_t)0x0000003F)  /*!< Bit Mask of 32bit */
#define CPU_ICSR_VECTACTIVE_mask_h0                 ((uint16_t)0x003F)      /*!< Bit Mask of 16bit */
#define CPU_ICSR_VECTACTIVE_mask_b0                 ((uint8_t )0x3F)        /*!< Bit Mask of 8bit */
#define CPU_ICSR_VECTACTIVE_shift_w                 (0)                     /*!< Bit Shift of 32bit */
#define CPU_ICSR_VECTACTIVE_shift_h0                (0)                     /*!< Bit Shift of 16bit */
#define CPU_ICSR_VECTACTIVE_shift_b0                (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_AIRCR  [register's definitions]
 *              Offset[0xD0C]  CPU Application Interrupt and Reset Control Register (0xE000ED0C)
 ******************************************************************************
 */
///@{
#define CPU_AIRCR_default                           ((uint32_t)0xFA050000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_AIRCR */
#define CPU_AIRCR_VECTKEY_mask_w                    ((uint32_t)0xFFFF0000)  /*!< Bit Mask of 32bit */
#define CPU_AIRCR_VECTKEY_mask_h1                   ((uint16_t)0xFFFF)      /*!< Bit Mask of 16bit */
#define CPU_AIRCR_VECTKEY_shift_w                   (16)                    /*!< Bit Shift of 32bit */
#define CPU_AIRCR_VECTKEY_shift_h1                  (0)                     /*!< Bit Shift of 16bit */
#define CPU_AIRCR_VECTKEY_shift_b2                  (0)                     /*!< Bit Shift of 8bit */

#define CPU_AIRCR_ENDIANESS_mask_w                  ((uint32_t)0x00008000)  /*!< Bit Mask of 32bit */
#define CPU_AIRCR_ENDIANESS_mask_h0                 ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define CPU_AIRCR_ENDIANESS_mask_b1                 ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define CPU_AIRCR_ENDIANESS_little_endian_w         ((uint32_t)0x00000000)  /*!< Bit Value =(0):Little-endian of 32bit */
#define CPU_AIRCR_ENDIANESS_little_endian_h0        ((uint16_t)0x0000)      /*!< Bit Value =(0):Little-endian of 16bit */
#define CPU_AIRCR_ENDIANESS_little_endian_b1        ((uint8_t )0x00)        /*!< Bit Value =(0):Little-endian of 8bit */
#define CPU_AIRCR_ENDIANESS_big_endian__w           ((uint32_t)0x00008000)  /*!< Bit Value =(1):Big-endian. of 32bit */
#define CPU_AIRCR_ENDIANESS_big_endian__h0          ((uint16_t)0x8000)      /*!< Bit Value =(1):Big-endian. of 16bit */
#define CPU_AIRCR_ENDIANESS_big_endian__b1          ((uint8_t )0x80)        /*!< Bit Value =(1):Big-endian. of 8bit */

#define CPU_AIRCR_SYSRESETREQ_mask_w                ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CPU_AIRCR_SYSRESETREQ_mask_h0               ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CPU_AIRCR_SYSRESETREQ_mask_b0               ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CPU_AIRCR_SYSRESETREQ_shift_w               (2)                     /*!< Bit Shift of 32bit */
#define CPU_AIRCR_SYSRESETREQ_shift_h0              (2)                     /*!< Bit Shift of 16bit */
#define CPU_AIRCR_SYSRESETREQ_shift_b0              (2)                     /*!< Bit Shift of 8bit */

#define CPU_AIRCR_VECTCLRACTIVE_mask_w              ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CPU_AIRCR_VECTCLRACTIVE_mask_h0             ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CPU_AIRCR_VECTCLRACTIVE_mask_b0             ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CPU_AIRCR_VECTCLRACTIVE_shift_w             (1)                     /*!< Bit Shift of 32bit */
#define CPU_AIRCR_VECTCLRACTIVE_shift_h0            (1)                     /*!< Bit Shift of 16bit */
#define CPU_AIRCR_VECTCLRACTIVE_shift_b0            (1)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SCR  [register's definitions]
 *              Offset[0xD10]  CPU System Control Register (0xE000ED10)
 ******************************************************************************
 */
///@{
#define CPU_SCR_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SCR */
#define CPU_SCR_SEVONPEND_mask_w                    ((uint32_t)0x00000010)  /*!< Bit Mask of 32bit */
#define CPU_SCR_SEVONPEND_mask_h0                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define CPU_SCR_SEVONPEND_mask_b0                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define CPU_SCR_SEVONPEND_shift_w                   (4)                     /*!< Bit Shift of 32bit */
#define CPU_SCR_SEVONPEND_shift_h0                  (4)                     /*!< Bit Shift of 16bit */
#define CPU_SCR_SEVONPEND_shift_b0                  (4)                     /*!< Bit Shift of 8bit */

#define CPU_SCR_SLEEPDEEP_mask_w                    ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define CPU_SCR_SLEEPDEEP_mask_h0                   ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define CPU_SCR_SLEEPDEEP_mask_b0                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define CPU_SCR_SLEEPDEEP_sleep_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):sleep of 32bit */
#define CPU_SCR_SLEEPDEEP_sleep_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):sleep of 16bit */
#define CPU_SCR_SLEEPDEEP_sleep_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):sleep of 8bit */
#define CPU_SCR_SLEEPDEEP_deep_sleep_w              ((uint32_t)0x00000004)  /*!< Bit Value =(1):deep sleep of 32bit */
#define CPU_SCR_SLEEPDEEP_deep_sleep_h0             ((uint16_t)0x0004)      /*!< Bit Value =(1):deep sleep of 16bit */
#define CPU_SCR_SLEEPDEEP_deep_sleep_b0             ((uint8_t )0x04)        /*!< Bit Value =(1):deep sleep of 8bit */

#define CPU_SCR_SLEEPONEXIT_mask_w                  ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define CPU_SCR_SLEEPONEXIT_mask_h0                 ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define CPU_SCR_SLEEPONEXIT_mask_b0                 ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CPU_SCR_SLEEPONEXIT_shift_w                 (1)                     /*!< Bit Shift of 32bit */
#define CPU_SCR_SLEEPONEXIT_shift_h0                (1)                     /*!< Bit Shift of 16bit */
#define CPU_SCR_SLEEPONEXIT_shift_b0                (1)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_CCR  [register's definitions]
 *              Offset[0xD14]  CPU Configuration and Control Register (0xE000ED14)
 ******************************************************************************
 */
///@{
#define CPU_CCR_default                             ((uint32_t)0x00000208)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_CCR */
#define CPU_CCR_STKALIGN_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define CPU_CCR_STKALIGN_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define CPU_CCR_STKALIGN_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define CPU_CCR_STKALIGN_shift_w                    (9)                     /*!< Bit Shift of 32bit */
#define CPU_CCR_STKALIGN_shift_h0                   (9)                     /*!< Bit Shift of 16bit */
#define CPU_CCR_STKALIGN_shift_b1                   (1)                     /*!< Bit Shift of 8bit */

#define CPU_CCR_UNALIGN_TRP_mask_w                  ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define CPU_CCR_UNALIGN_TRP_mask_h0                 ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define CPU_CCR_UNALIGN_TRP_mask_b0                 ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define CPU_CCR_UNALIGN_TRP_shift_w                 (3)                     /*!< Bit Shift of 32bit */
#define CPU_CCR_UNALIGN_TRP_shift_h0                (3)                     /*!< Bit Shift of 16bit */
#define CPU_CCR_UNALIGN_TRP_shift_b0                (3)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR2  [register's definitions]
 *              Offset[0xD1C]  CPU System Handler Priority Register 2 (0xE000ED1C)
 ******************************************************************************
 */
///@{
#define CPU_SHPR2_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SHPR2 */
#define CPU_SHPR2_PRI_11_mask_w                     ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_SHPR2_PRI_11_mask_h1                    ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_SHPR2_PRI_11_mask_b3                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_SHPR2_PRI_11_shift_w                    (30)                    /*!< Bit Shift of 32bit */
#define CPU_SHPR2_PRI_11_shift_h1                   (14)                    /*!< Bit Shift of 16bit */
#define CPU_SHPR2_PRI_11_shift_b3                   (6)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        CPU_SHPR3  [register's definitions]
 *              Offset[0xD20]  CPU System Handler Priority Register 3 (0xE000ED20)
 ******************************************************************************
 */
///@{
#define CPU_SHPR3_default                           ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of CPU_SHPR3 */
#define CPU_SHPR3_PRI_15_mask_w                     ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define CPU_SHPR3_PRI_15_mask_h1                    ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define CPU_SHPR3_PRI_15_mask_b3                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_SHPR3_PRI_15_shift_w                    (30)                    /*!< Bit Shift of 32bit */
#define CPU_SHPR3_PRI_15_shift_h1                   (14)                    /*!< Bit Shift of 16bit */
#define CPU_SHPR3_PRI_15_shift_b3                   (6)                     /*!< Bit Shift of 8bit */

#define CPU_SHPR3_PRI_14_mask_w                     ((uint32_t)0x00C00000)  /*!< Bit Mask of 32bit */
#define CPU_SHPR3_PRI_14_mask_h1                    ((uint16_t)0x00C0)      /*!< Bit Mask of 16bit */
#define CPU_SHPR3_PRI_14_mask_b2                    ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define CPU_SHPR3_PRI_14_shift_w                    (22)                    /*!< Bit Shift of 32bit */
#define CPU_SHPR3_PRI_14_shift_h1                   (6)                     /*!< Bit Shift of 16bit */
#define CPU_SHPR3_PRI_14_shift_b2                   (6)                     /*!< Bit Shift of 8bit */

///@}

#endif  // _MG32_CPU_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32_CPU.h                         */
/*----------------------------------------------------------------------------*/
