
/**
 ******************************************************************************
 *
 * @file        MG32_ARGB_WS2812.h
 * @brief      The code is Using URT of MG32 to control ARGB 
 *
 * @par         Project
 *              MG32
 * @version     V1.03
 * @date        2023/01/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
 
#ifndef __MG32_URT_ARGB
#define __MG32_URT_ARGB
 
 
/* Includes ------------------------------------------------------------------*/
#include "MG32.h" 
#include "MG32_ChipInit.h"
#include "MG32_URT.h"
 
/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/*! @struct ARGBCTR_TypeDef
    @brief  
*/ 
typedef struct __attribute__((packed))
{
    //=====================================================================
    //Hardware Control Relationship.
         uint8_t             ARGB_UsePeripheral;   /*< .*/
                                                   
    __IO uint32_t            *ARGB_REG_INT;        /*< Pointer to control the ARGB interrupt register .*/
                                                   
    __IO uint32_t            *ARGB_REG_STA;        /*< Pointer to control the ARGB status register .*/
                                                   
    __IO uint32_t            *ARGB_REG_TXData;     /*< Pointer to control the ARGB data transmit register .*/
                                                   
    __IO uint32_t            *ARGB_REG_TMO;        /*< Pointer to control the ARGB timeout timer control register( only for URT) .*/
                                                   
    __IO uint32_t            *ARGB_REG_CRX;        /*< Pointer to control the ARGB control register .*/
                                                   
         uint32_t            ARGB_STA_TX;          /*< Declare TX flag bit.*/
                                                   
         uint32_t            ARGB_STA_TC;          /*< Declare TC flag bit.*/
                                                   
         uint32_t            ARGB_STA_TMO;         /*< Declare TMO flag bit.(only for URT)*/
                                                   
         uint32_t            ARGB_STA_UG;          /*< Declare general event flag bit.(only for URT).*/
                                                   
         uint32_t            ARGB_TMO_EN;          /*< Declare Timeout timer enable bit.(only for URT).*/
                                                   
         IRQn_Type           ARGB_IRQ;             /*< Declare the ARGB IRQ vector.*/
                                                   
         uint8_t             ARGB_LOGIC_0;         /*< Declare the ARGB logical 0 data.*/
                                                   
         uint8_t             ARGB_LOGIC_1;         /*< Declare the ARGB logical 1 data.*/
    //======================================================================
    //Hardware Transmission Relationship.
         uint8_t             *updateBuf;           /*!< Pointer to data buffer for transmission.*/
                                                   
         uint8_t             TXMode;               /*!< ARGB transmit data mode.
                                                        This parameter can be a value of reference to SMP_ARGB_TXModeTypeDef.*/ 
                                                   
         uint8_t             DataBitCmp;           /*!< Record transmission bit now. */
                                                   
         uint32_t            DataCount;            /*!< Record already transmission data bytes.*/
                                                   
    __IO uint32_t            TotalCount;           /*!< Record remaining data bytes.*/
                                                   
         uint8_t             TXData;               /*!< Record transmission data now.*/
                                                   
         uint8_t             TRES;                 /*!< Control Trst.*/
                                                   
    __IO uint8_t             State;                /*!< ARGB state information. 
                                                        This parameter can be a value of reference to SMP_ARGB_StateTypeDef*/
                                                                   
    //=======================================================================
    // ARGB mode Drama Control Relationship.
    
         uint8_t             DramaMode;            /*!< ARGB Display mode control.
                                                        This parameter can be a value of reference to SMP_ARGB_DramaModeTypeDef.*/
         uint8_t             UpdateTRG;            /*!< ARGB control relationship trigger parameter.
                                                        This parameter can be any value of SMP_ARGB_TRGTypeDef.*/
                                                     
         uint8_t             DramaTmp[3];          /*!< Calculate Temporary buffer.*/
                                                   
         uint8_t             *DramaBuf;            /*!< Pointer to data buffer for calculation.*/
                                                   
         uint8_t             DramaAct;             /*!< Control the ARGB drama current main step*/
                                                   
         uint8_t             DramaActMax;          /*!< Control the ARGB drama max main step.*/
                                                   
         uint32_t            DramaScene;           /*!< Control the ARGB drama current substep*/
                                                   
         uint32_t            DramaSceneMax;        /*!< Control the ARGB drama max substep.*/
                                                   
         uint8_t             DramaTime;            /*!< Control the ARGB drama current time .*/
                                                   
         uint8_t             DramaTimeMax;         /*!< Control the ARGB drama max time .*/
                                 
}ARGBCTR_TypeDef;

/* Private define ------------------------------------------------------------*/
/**
 * @name	============== ARGB logic 0 / 1 data proportion ==============
 *   		
 */ 
///@{
//==================================================
//For ARGB WS2812
#define ARGB_LOGIC_URT_0              0x1F  /*!< WS2812 logic 0 data proportion for URT.*/
#define ARGB_LOGIC_URT_1              0x07  /*!< WS2812 logic 1 data proportion for URT.*/
               
#define ARGB_LOGIC_SPI_0              0xE0  /*!< WS2812 logic 0 data proportion for SPI.*/
#define ARGB_LOGIC_SPI_1              0xF8  /*!< WS2812 logic 1 data proportion for SPI.*/

//==================================================
//For ARGB WS2812B
//#define ARGB_LOGIC_URT_0              0x3F  /*!< WS2812B logic 0 data proportion.*/
//#define ARGB_LOGIC_URT_1              0x00  /*!< WS2812B logic 1 data proportion.*/
                                              
//#define ARGB_LOGIC_SPI_0              0xE0  /*!< WS2812 logic 0 data proportion for SPI.*/
//#define ARGB_LOGIC_SPI_1              0xFC  /*!< WS2812 logic 1 data proportion for SPI.*/

//==================================================
//For SK6812
//#define ARGB_LOGIC_URT_0              0x1F  /*!< SK6812 logic 0 data proportion.*/
//#define ARGB_LOGIC_URT_1              0x07  /*!< SK6812 logic 1 data proportion.*/
                                              
//#define ARGB_LOGIC_SPI_0              0xE0  /*!< WS2812 logic 0 data proportion for SPI.*/
//#define ARGB_LOGIC_SPI_1              0xF8  /*!< WS2812 logic 1 data proportion for SPI.*/
///@}


/**
 * @name	
 *   		
 */ 
///@{
#define ARGB_PERIPHERAL_MASK          0xF0
   
#define ARGB_PERIPHERAL_URT_MASK      0x00
#if defined(URT0_Base)  
#define ARGB_PERIPHERAL_URT0          0x00
#endif  
#if defined(URT1_Base)  
#define ARGB_PERIPHERAL_URT1          0x01
#endif  
#if defined(URT2_Base)  
#define ARGB_PERIPHERAL_URT2          0x02
#endif  
#if defined(URT3_Base)  
#define ARGB_PERIPHERAL_URT3          0x04
#endif  
#define ARGB_PERIPHERAL_SPI0          0x10
///@}

/**
 * @name	SMP_ARGB_StateTypeDef : ARGB state information
 *   		
 */ 
///@{
#define ARGB_RESET                    0x00  /*!< ARGB handle status is reset.*/
#define ARGB_READY                    0x10  /*!< ARGB handle status is ready.*/
#define ARGB_BUSY                     0x11  /*!< ARGB handle status is busy.*/
#define ARGB_FAIL                     0x80  /*!< ARGB initial fail.*/
///@}

/**
 * @name	SMP_ARGB_TXModeTypeDef : ARGB transmit mode
 *   		
 */ 
///@{
#define ARGB_BLOCKING_MODE            0     /*!< Send data to ARGB  by blocking mode.*/
#define ARGB_IT_MODE                  1     /*!< Send data to ARGB  by interrupt mode.*/
///@}

/**
 * @name	SMP_ARGB_TRGTypeDef : ARGB relationship trigger status.
 *   		
 */ 
///@{
#define ARGB_UPDATE_DATA              0x01  /*!< ARGB data update.*/
#define ARGB_UPDATE_MODE              0x02  /*!< ARGB mode update.*/
///@}

/**
 * @name	SMP_ARGB_DramaModeTypeDef : ARGB Display mode.
 *   		
 */ 
///@{
#define ARGB_DRAMA_DISABLE            0     /*!<ARGB mode = ARGB disable mode.*/
#define ARGB_DRAMA_STATIC             1     /*!<ARGB mode = ARGB Static color mode.*/
#define ARGB_DRAMA_BREATH             2     /*!<ARGB mode = ARGB breath mode.*/
#define ARGB_DRAMA_RAINBOW            3     /*!<ARGB mode = ARGB rainbow mode.*/
#define ARGB_DRAMA_MORPHING           4     /*!<ARGB mode = ARGB morphing color mode.*/
#define ARGB_DRAMA_WDROP              5     /*!<ARGB mode = ARGB water drop mode.*/
#define ARGB_DRAMA_MOVING             6     /*!<ARGB mode = ARGB signal direct move mode.*/
#define ARGB_DRAMA_2MOVING            7     /*!<ARGB mode = ARGB two direct move mode.*/
///@} 

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/**
 * @name ARGB sample function.
 *   		
 */ 
///@{
void URT_ARGB_Init(ARGBCTR_TypeDef *sARGB );
void URT_ARGB_UpdateTrigger( uint8_t ARGB_Mode);
void ARGB_Main(void);


void Sample_ARGB_Init(ARGBCTR_TypeDef *sARGB );
void Sample_URT_ARGB_UpdateTrigger( uint8_t  ARGB_Mode);

///@}

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/
/**
 * @name ARGB sample parameter.
 *   		
 */ 

///@{
extern ARGBCTR_TypeDef   ARGB0;

///@}



#endif


