/**
  ******************************************************************************
 *
 * @file        Sample_CSC_PLL_Init.c
 *
 * @brief       CSC module PLL block initialize.
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2024/04/19
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */



/* Includes ------------------------------------------------------------------*/
#include "MG32_DRV.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void Sample_CSC_PLL_Init(void);
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       Sample CSC_PLL_Init
 * @details     1. Enable IHRCO
 *      \n      2. Select IHRCO clock is 12MHz
 *              3. CK_HS clock source select.
 *              4. PLL block intialize.
 * @return	    None
 * @note        
 * @par         Example
 * @code
    Sample_CSC_PLL_Init();
 * @endcode
 *******************************************************************************
 */
void Sample_CSC_PLL_Init(void)
{
    CSC_PLL_TypeDef CSC_PLL_Init;
    
    UnProtectModuleReg(CSCprotect);
    /* 1. Enable IHRCO (Internal High Speed RC Circuit). */
    CSC_IHRCO_Cmd(ENABLE);
    /* 2. Select Internal High Speed RC Circuit is 12MHz. */
    CSC_IHRCO_Select(IHRCO_12MHz);
    /* 3. CK_HS Source Select. */
    CSC_CK_HS_Select(HS_CK_IHRCO);
    /* 4. PLL Block Initialize. */
    // For MG32F02A128/A064/U128/U064
    #if defined(CSC_PLL_PLLI_SEL_mask_w)
    CSC_PLL_Init.InputDivider = PLLI_DIV_2;
    CSC_PLL_Init.Multiplication = PLLI_CLKx24;
    CSC_PLL_Init.OutputDivider = PLLO_DIV_4;
    CSC_PLL_Init.PLLInputClockSelect = PLLI_SEL_HS;
    #else
    // For MG32F02A132/A072/A032
    CSC_PLL_Init.InputDivider = PLLI_DIV_2;
    CSC_PLL_Init.Multiplication = PLLIx16;
    CSC_PLL_Init.OutputDivider = PLLO_DIV_4;
    #endif
    CSC_PLL_Config(&CSC_PLL_Init);
    ProtectModuleReg(CSCprotect);
}




