/**
  ******************************************************************************
 *
 * @file        Sample_IWDT_Init.c
 *
 * @brief       IWDT sample code
 *
 * @par         Project
 *              MG32
 * @version     V1.10
 * @date        2018/01/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2018 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#include "Sample.h"

#if Sample_Code_Macro_Select == Sample_Code_Macro_IWDT && Sample_Code_IWDT == Sample_Code_IWDT_Init


#include "MG32_DRV.h"


/**
 *******************************************************************************
 * @brief  	    Sample IWDT init
 * @details     1. Enable CSC to IWDT clock
 *      \n      2. Configure IWDT clock
 *      \n      3. Enable IWDT module
 *      \n      4. Check flag action
 *      \n      5. Disable IWDT module
 * @return	    None	
 * @note        
 * @par         Example
 * @code
    Sample_IWDT_Init();
 * @endcode
 *******************************************************************************
 */
void Sample_IWDT_Init (void)
{
    
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12Mz
    //Select CK_MAIN Source = CK_HS
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->IWDT = Enable

//    /*=== 1. Enable CSC to IWDT clock ===*/
//    UnProtectModuleReg(CSCprotect);                                 // Unprotect CSC module
//    CSC_PeriphOnModeClock_Config(CSC_ON_IWDT, ENABLE);              // Enable IWDT module clock
//    ProtectModuleReg(CSCprotect);                                   // protect CSC module
      
    /*=== 2. Configure IWDT clock ===*/
    UnProtectModuleReg(IWDTprotect);                                // Unprotect IWDT module
    IWDT_Divider_Select(IWDT_DIV_256);                              // DIV output = CK_IWDT /256
    
    /*=== 3. Enable IWDT module ===*/
    IWDT_Cmd(ENABLE);                                               // Enable IWDT module
    UnProtectModuleReg(IWDTprotect);                                // Protect IWDT module
    
    /*=== 4. Check flag action ===*/
    while(IWDT_GetSingleFlagStatus(IWDT_EW1F) == DRV_UnHappened);   // Wait IWDT early wakeup-1 happened
    IWDT_ClearFlag(IWDT_EW1F);                                      // Clear EW1F flag 
    
    while(IWDT_GetSingleFlagStatus(IWDT_EW0F) == DRV_UnHappened);   // Wait IWDT early wakeup-0 happened
    IWDT_ClearFlag(IWDT_EW0F);                                      // Clear EW0F flag
    
    while(IWDT_GetSingleFlagStatus(IWDT_TF) == DRV_UnHappened);     // Wait IWDT timer timeout happened
    IWDT_ClearFlag(IWDT_TF);                                        // Clear TF flag
    IWDT_RefreshCounter();                                          // Clear IWDT timer
    
    /*===  5. Disable IWDT module ===*/
    UnProtectModuleReg(IWDTprotect);                                // Unprotect IWDT module
    IWDT_Cmd(DISABLE);                                              // Disable IWDT module
    ProtectModuleReg(IWDTprotect);                                  // Protect IWDT module

}



#endif
