/**
  ******************************************************************************
 *
 * @file        Sample_MID_TM26_PWM.c
 *
 * @brief       TM26 PWM output example.
 *
 * @par         Project
 *              MG32
 * @version     V1.13
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static TM_HandleTypeDef    mTM26;

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_TM26_PWM(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    TM26 PWM output example.
 * @details     1.Initial TM26 32 bit counter range.
 *    \n        2.Initial TM26 clock mode.
 *    \n        3.TM26 PWM output channel configuration.
 *    \n        4.Start PWM output.
 *    \n        5.Update duty cycle.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_TM26_PWM(void)
{      
    TM_OC_InitTypeDef       sConfig;    
    TM_ClockConfigTypeDef   CKConfig;

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->TM26 = Enable
	
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOA->PA12,PA13
    //GPIO port initial is 0xFFFF
    //PA12,PA13 mode is PPO
    //PA12,PA13 function TM26_OC00,TM26_OC10
    
    // ------------------------------------------------------------------------
    // 1.Initial TM26 for 10-bit PWM.
    // ------------------------------------------------------------------------
    mTM26.Instance                  = TM26;
    mTM26.Init.TM_CounterMode       = TM_SEPARATE_UP;
    mTM26.Init.TM_Period            = 1023;
    mTM26.Init.TM_Prescaler         = 0;
    MID_TM_PWM_Init(&mTM26);
    
    // ------------------------------------------------------------------------
    // 2.Initial TM26 clock mode.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    
    MID_TM_ConfigClockSource(&mTM26, &CKConfig);  
    
    // ------------------------------------------------------------------------
    // 3.TM26 PWM output channel configuration.
    // ------------------------------------------------------------------------
    MID_TM_OC_Struct_Init(&sConfig);               // default initial (output state)
    sConfig.OCMode = TM_CH_16bit_PWM;
    sConfig.Pulse = 511;                        // Duty cycle
    MID_TM_PWM_ConfigChannel(&mTM26, &sConfig, MID_TM_Channel0);
    sConfig.Pulse = 767;                        // Duty cycle
    MID_TM_PWM_ConfigChannel(&mTM26, &sConfig, MID_TM_Channel1);    
    
    // ------------------------------------------------------------------------
    // 4.Start PWM output.
    // ------------------------------------------------------------------------
    MID_TM_PWM_Start(&mTM26, MID_TM_Channel0);    // Channel0 be 16bit PWM output (Blocking mode: Polling) 
    MID_TM_PWM_Start(&mTM26, MID_TM_Channel1);    // Channel1 be 16bit PWM output (Blocking mode: Polling)

	// ------------------------------------------------------------------------
	// 5.Update duty cycle.
	// ------------------------------------------------------------------------
	__DRV_TM_SET_COMPARE_B(&mTM26, MID_TM_Channel0, 800);
	__DRV_TM_SET_COMPARE_B(&mTM26, MID_TM_Channel1, 900);

    
    return;
    
}

