/**
 *******************************************************************************
 * @file        MG32_RST_Init.h
 *
 * @brief       The RST initial code h file
 *
 * MG32 remote controller
 * @version     V1.17
 * @date        2023/05/10
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2020 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 *******************************************************************************
 * @par         Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#include "MG32.h"
#include "MG32_RST.h"



#ifndef _MG32_RST_INIT_H
/*!< _MG32_RST_INIT_H */ 
#define _MG32_RST_INIT_H


/**
 ******************************************************************************
 *
 * @struct      RST_InitConfig[]
 *              RST initial configuration array
 *
 ******************************************************************************
 */
//*** <<< Use Configuration Wizard in Context Menu >>> ***

//  <h> Configure RST Module
//      <h> IO State Kept After Warm Reset
//          <q.8>  PA[3:0] pins
            #define CONF_RST_CR0_PA_DIS0    0 
//          <q.9>  PA[11:8] pins
            #define CONF_RST_CR0_PA_DIS1    0 
//          <q.10> PB[3:0] pins
            #define CONF_RST_CR0_PB_DIS0    0
//          <q.11> PB[11:8] pins
            #define CONF_RST_CR0_PB_DIS1    0
//          <q.12> PC[3:0] pins
            #define CONF_RST_CR0_PC_DIS0    0
//          <q.13> PC[11:8] pins
            #define CONF_RST_CR0_PC_DIS1    0
//          <q.14> PD[3:0] pins
            #define CONF_RST_CR0_PD_DIS0    0
//          <q.15> PD[11:8] pins
            #define CONF_RST_CR0_PD_DIS1    0
//          <q.16> PE[3:0] pins
//              <i> Support MG32F02A132/A128/A072/A064/U128/U064
            #define CONF_RST_CR0_PE_DIS0    0
//          <q.17> PE[9:8] pins
//              <i> Support MG32F02A132/A128/A072/A064/U128/U064
            #define CONF_RST_CR0_PE_DIS1    0
//      </h>
    
//      <h> Cold Reset Source Configuration
//          <q.1>  Software Reset
            #define CONF_RST_CE_SW          0
//          <q.2>  External Reset Pin
            #define CONF_RST_CE_EX          0
//          <q.3>  CPU SYSRESETREQ Bit
            #define CONF_RST_CE_CPU         0
//          <q.4>  BOD0
            #define CONF_RST_CE_BOD0        0
//          <q.5>  BOD1
            #define CONF_RST_CE_BOD1        0
//          <q.7>  BOD2
            #define CONF_RST_CE_BOD2        0
//              <i> Support MG32F02U128/U064/A128/A064/V032
//          <q.6>  Low Power STOP Mode
            #define CONF_RST_CE_LPM         0
//          <q.8>  CSC Missing Clock Detect
            #define CONF_RST_CE_CSC         0
//          <q.10> Flash Memory Read/Write/Erase Error
            #define CONF_RST_CE_MEM         0
//          <q.11> IWDT
            #define CONF_RST_CE_IWDT        0
//          <q.12> WWDT
            #define CONF_RST_CE_WWDT        0
//          <q.13> ADC Analog Voltage Watch-Dog 
            #define CONF_RST_CE_ADC         0
//          <q.16> Comparator CMP0
//              <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_RST_CE_CMP0        0
//          <q.17> Comparator CMP1
//              <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_RST_CE_CMP1        0
//          <q.18> Comparator CMP2
//              <i> Support MG32F02A132/A072
            #define CONF_RST_CE_CMP2        0
//          <q.19> Comparator CMP3
//              <i> Support MG32F02A132/A072
            #define CONF_RST_CE_CMP3        0
//      </h>

//      <h> Warm Reset Source Configuration
//          <q.1>  Software Reset
            #define CONF_RST_WE_SW          2
//          <q.2>  External Reset Pin
            #define CONF_RST_WE_EX          4
//          <q.3>  CPU SYSRESETREQ Bit
            #define CONF_RST_WE_CPU         8
//          <q.4>  BOD0
            #define CONF_RST_WE_BOD0        0
//          <q.5>  BOD1
            #define CONF_RST_WE_BOD1        0
//          <q.7>  BOD2
//              <i> Support MG32F02U128/U064/A128/A064/V032
            #define CONF_RST_WE_BOD2        0
//          <q.6>  Low Power STOP Mode
            #define CONF_RST_WE_LPM         0
//          <q.8>  CSC Missing Clock Detect
            #define CONF_RST_WE_CSC         0
//          <q.10> Flash Memory Read/Write/Erase Error
            #define CONF_RST_WE_MEM         0
//          <q.11> IWDT
            #define CONF_RST_WE_IWDT        0
//          <q.12> WWDT
            #define CONF_RST_WE_WWDT        0
//          <q.13> ADC Analog Voltage Watch-Dog 
            #define CONF_RST_WE_ADC         0
//          <q.16> Comparator CMP0
//              <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_RST_WE_CMP0        0
//          <q.17> Comparator CMP1
//              <i> Support MG32F02A132/A128/A072/A064/A032/U128/U064
            #define CONF_RST_WE_CMP1        0
//          <q.18> Comparator CMP2
//              <i> Support MG32F02A132/A072
            #define CONF_RST_WE_CMP2        0
//          <q.19> Comparator CMP3
//              <i> Support MG32F02A132/A072
            #define CONF_RST_WE_CMP3        0
//      </h>

//      <h> Module Reset Action Configureation
//          <h> USB Module
//              <i> Support MG32F02U128/U064
//          <o.25> USB Module Reset Control <0=> All, USB Reset Level-0
//                                          <1=> LV1, USB Reset Level-1
            #define CONF_RST_CR0_USB_RCTL   33554432
//          </h>
//      </h>
//  </h>

#define CONF_RST_STA    0x00000000
#define CONF_RST_INT    0x00000000
#define CONF_RST_KEY    0x00000000
#define CONF_RST_CR0    CONF_RST_CR0_PA_DIS0 | CONF_RST_CR0_PA_DIS1 | CONF_RST_CR0_PB_DIS0 | CONF_RST_CR0_PB_DIS1 | CONF_RST_CR0_PC_DIS0 | CONF_RST_CR0_PC_DIS1 | CONF_RST_CR0_PD_DIS0 | CONF_RST_CR0_PD_DIS1 | CONF_RST_CR0_PE_DIS0 | CONF_RST_CR0_PE_DIS1 | CONF_RST_CR0_USB_RCTL
#define CONF_RST_CE     CONF_RST_CE_SW | CONF_RST_CE_EX | CONF_RST_CE_CPU | CONF_RST_CE_BOD0 | CONF_RST_CE_BOD1 | CONF_RST_CE_BOD2 | CONF_RST_CE_LPM | CONF_RST_CE_CSC | CONF_RST_CE_MEM | CONF_RST_CE_IWDT | CONF_RST_CE_WWDT | CONF_RST_CE_ADC | CONF_RST_CE_CMP0 | CONF_RST_CE_CMP1 | CONF_RST_CE_CMP2 | CONF_RST_CE_CMP3
#define CONF_RST_WE     CONF_RST_WE_SW | CONF_RST_WE_EX | CONF_RST_WE_CPU | CONF_RST_WE_BOD0 | CONF_RST_WE_BOD1 | CONF_RST_WE_BOD2 | CONF_RST_WE_LPM | CONF_RST_WE_CSC | CONF_RST_WE_MEM | CONF_RST_WE_IWDT | CONF_RST_WE_WWDT | CONF_RST_WE_ADC | CONF_RST_WE_CMP0 | CONF_RST_WE_CMP1 | CONF_RST_WE_CMP2 | CONF_RST_WE_CMP3
#define CONF_RST_AHB    0x00000000
#define CONF_RST_APB0   0x00000000
#define CONF_RST_APB1   0x00000000
//*** <<< end of configuration section >>>    ***

static const unsigned int CONF_RST_InitConfig[] =
{
    CONF_RST_STA,   // RST_STA 0 not use
    CONF_RST_INT,   // RST_INT 1 not use
    CONF_RST_KEY,   // RST_KEY 2 not use
    CONF_RST_CR0,   // RST_CR0 3
    CONF_RST_CE,    // RST_CE 4
    CONF_RST_WE,    // RST_WE 5
    CONF_RST_AHB,   // RST_AHB 6
    CONF_RST_APB0,  // RST_APB0 7
    CONF_RST_APB1,  // RST_APB1 8
};


/**
 * @name	Function announce
 *   		
 */
///@{  
void RST_Init (void);
///@}

#endif  // _MG32_RST_INIT_H
