///////////////////////////////////////////////////
//
//	FILE:       MPC89_UART_to_RS232.c
//	AUTHOR:     Neo (Hsin-Chih Lin)
//	COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//	CREATED:    2008.4.7
//	PURPOSE:    Demo UART to RS232 Function
//
///////////////////////////////////////////////////

#include "REG_MPC89L51-515.H"
//#include "debug.h"
#define BAUDRATE    B_9600
#define B_2400      0
#define B_4800      1
#define B_9600      2
#define B_19200     3
//11Mhz can't support 38400 baud rate
#define B_57600     4

///////////////////////////////////////////////////
//
//	Function:Init_UART()
//  Initial UART at Mode 1 and use Timer1 at mode 2
//
///////////////////////////////////////////////////
void Init_Uart(void)
{
    TMOD=0x20;                                  //Set Timer1 Mode 2
    SCON=0x50;                                  //Set UART Mode 1
#if (BAUDRATE == B_2400)
    TH1=0xf4;                                   //  11MHz / 12 / 32 / 2400 = 11.93 => 12
    TL1=0xf4;                                   //  TH = 256-12 = 0xf4
#elif (BAUDRATE == B_4800)
    PCON=0x80;                                  //  Set SMOD = 1
    TH1=0xf4;                                   //  11MHz / 12 / 16 / 4800 = 11.93 => 12
    TL1=0xf4;                                   //  TH = 256-12 = 0xf4
#elif (BAUDRATE == B_9600)
    PCON=0x80;                                  //  Set SMOD = 1
    TH1=0xfa;                                   //  11MHz / 12 / 16 / 9600 = 5.96 => 6
    TL1=0xfa;                                   //  TH = 256-6 = 0xfa
#elif (BAUDRATE == B_19200)
    PCON=0x80;                                  //  Set SMOD = 1
    TH1=0xfd;                                   //  11MHz / 12 / 16 / 19200 = 2.98 => 3
    TL1=0xfd;                                   //  TH = 256-3 = 0xfd
#elif (BAUDRATE == B_57600)
    PCON=0x80;                                  //  Set SMOD = 1
    TH1=0xff;                                   //  11MHz / 12 / 16 / 57600 = 0.99 => 1
    TL1=0xff;                                   //  TH = 256-1 = 0xff
#endif
    TR1 =1;                                     //Start Timer1
}
///////////////////////////////////////////////////
//
//	Function:Output()
//  Output to RS232
//
///////////////////////////////////////////////////
void Output(unsigned char d)
{
    if(d>9 & d<16)
        SBUF = d + 0x37;
    else if(d<10)
        SBUF = d + 0x30;
    else if(d==0xaa)    //NewLine
        SBUF = 0x0a;
    else if(d==0xdd)    //Return
        SBUF = 0x0d;
    else
        SBUF = d;
    while(TI == 0){}    //Write transmitting has been finished
    TI = 0;
}
///////////////////////////////////////////////////
//
//	Function:OutputHex()
//  Output HEX to Char and a space
//
///////////////////////////////////////////////////
void OutputHex(unsigned char Uart_Data)
{
    unsigned char DataH,DataL;
    DataH = Uart_Data >> 4;
    DataL = Uart_Data & 0x0f;
    Output(DataH);
    Output(DataL);
    Output(0x20);       //Space
}
///////////////////////////////////////////////////
//
//	Function:OutputDec()
//  Output Dec to Char and a space
//
///////////////////////////////////////////////////
void OutputDec(unsigned char Uart_Data)
{
    unsigned char DataH,DataM,DataL;
    DataL = Uart_Data % 10;
    Uart_Data = Uart_Data / 10;
    DataM = Uart_Data % 10;
    DataH = Uart_Data /10;
    if(DataH == 0)
        Output(0x20);
    else
        Output(DataH);
    if((DataH == 0)&(DataM == 0))
        Output(0x20);
    else
        Output(DataM);
    Output(DataL);
    Output(0x20);       //Space
}
///////////////////////////////////////////////////
//
//	Function:OutputTxt()
//  Output string to Char and a space
//
///////////////////////////////////////////////////
void OutputTxt(unsigned char *Uart_Data,unsigned char strlen)
{
    unsigned char i;
    Output(0xaa);
    Output(0xdd);
    for(i=0;i<strlen;i++)
        Output(Uart_Data[i]);
}
///////////////////////////////////////////////////
//
//	Function:UART_Int()
//  UART interrupt 
//  Get user input 1 or 2
//
///////////////////////////////////////////////////
unsigned char state;
void UART_Int(void) interrupt 4
{
    if(RI)
    {                   //check if interrupt caused by RI ?
        RI=0;           //clear RI
        if(SBUF=='1')
            state = 1;
        if(SBUF=='2')
            state = 2;
    }

}
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
void main(void)
{
	unsigned char i,j;
    unsigned char txt[3][21]={  "1 : Show hexadecimal.",
                                "2 : Show decimalism. ",
                                " Please input 1 or 2:"};
    Init_Uart();                //Initial UART
    IE = 0x90;                  //enable serial interrupt
    state = 3;
	while (1) 
    {
        switch(state)
        {
            case 0:
                break;
            case 1:
                ES = 0;
                for(i=0;i<16;i++)
                {
                    for(j=0;j<16;j++)
                        OutputHex(i*16+j);
                    Output(0xaa);
                    Output(0xdd);
                }
                state = 3;
                ES = 1;
                break;
            case 2:
                ES = 0;
                for(i=0;i<16;i++)
                {
                    for(j=0;j<16;j++)
                        OutputDec(i*16+j);
                    Output(0xaa);
                    Output(0xdd);
                }
                state = 3;
                ES = 1;
                break;
            case 3:
                ES = 0;
                OutputTxt(&txt[0],21);
                OutputTxt(&txt[1],21);
                OutputTxt(&txt[2],21);
                Output(0xaa);
                Output(0xdd);
                state = 0;
                ES = 1;
                break;
        }
	}
}

