///////////////////////////////////////////////////
//
//	FILE:		MPC82_UART_to_RS232.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2008.4.8
//	PURPOSE:	Demo UART to RS232 Function
//
///////////////////////////////////////////////////
#include "REG_MPC89L51-515.INC"
#include "DEBUG.INC"

BRT     EQU     0FAH    //baud rate 9600
STATE   EQU     30H
i       EQU     31H
j       EQU     32H
strlen  EQU     33H
	    ORG		0000H	
	    JMP		START
	    ORG		0023H	
	    JMP		UART_INT
	    ORG		50H
MSG_TABLE:
        DB      '1',' ',':','S','h','o','w',' ','h','e','x','a','d','e','c','i','m','a','l','.'
        DB      '2',' ',':','S','h','o','w',' ','d','e','c','i','m','a','l','i','s','m','.',' '
        DB      ' ','P','l','e','a','s','e',' ','i','n','p','u','t',' ','1',' ','o','r',' ','2'

///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
START:
;MOV		SP,#50H
;Debug_clear_LCD
;Debug_show_msg_to_LCD #00H
        LCALL   INIT_UART
        MOV     IE,#080H
        MOV     STATE,#03H
LOOP:
        MOV     A,STATE
        JZ      LOOP
        DEC     A
        JZ      SHOW_HEX
        DEC     A
        JZ      SHOW_DEC
        DEC     A
        JZ      SHOW_MSG
        SJMP    LOOP
SHOW_HEX:
        CLR     ES
        MOV     i,#0H
FOR_I:
        MOV     j,#0H
FOR_J:
        MOV     A,i
        SWAP    A
        ANL     A,#0F0H
        ADD     A,j
        MOV     R1,A
        LCALL   OUTPUT_HEX
        INC     j
        MOV     A,j
        CLR     C
        SUBB    A,#010H
        JC      FOR_J
        MOV     R7,#0AAH
        LCALL   OUTPUT
        MOV     R7,#0DDH
        LCALL   OUTPUT
        INC     i
        MOV     A,i
        CLR     C
        SUBB    A,#010H
        JC      FOR_I
        MOV     STATE,#03H
        SETB    ES
        LJMP    LOOP
SHOW_DEC:
        CLR     ES
        MOV     i,#00H
FOR_II:
        MOV     A,i
        CLR     C
        SUBB    A,#010H
        JNC     END_FOR1
        MOV     j,#00H
FOR_JJ:
        MOV     A,j
        CLR     C
        SUBB    A,#010H
        JNC     END_JJ
        MOV     A,i
        SWAP    A
        ANL     A,#0F0H
        MOV     R7,A
        MOV     A,R7
        ADD     A,j
        MOV     R7,A
        LCALL   OUTPUT_DEC
        INC     j
        SJMP    FOR_JJ
END_JJ:
        MOV     R7,#0AAH
        LCALL   OUTPUT
        MOV     R7,#0DDH
        LCALL   OUTPUT
        INC     i
        SJMP    FOR_II
END_FOR1:
        MOV     STATE,#03H
        SETB    ES
        LJMP    LOOP
SHOW_MSG:
        CLR     ES
		MOV		DPTR,#MSG_TABLE
        MOV     R5,#14H
        LCALL   OUTPUT_TXT
		MOV		DPTR,#MSG_TABLE	+ 14H 
        MOV     R5,#14H
        LCALL   OUTPUT_TXT
		MOV		DPTR,#MSG_TABLE	+ 28H 
        MOV     R5,#14H
        LCALL   OUTPUT_TXT
        MOV     R7,#0AAH
        LCALL   OUTPUT
        MOV     R7,#0DDH
        LCALL   OUTPUT
        MOV     state,#00H
        SETB    ES
        LJMP    LOOP
        RET     
///////////////////////////////////////////////////
//
//  UART Interrupt
//
///////////////////////////////////////////////////
UART_INT:
        PUSH    ACC
        PUSH    PSW
        JNB     RI,BREAK
        CLR     RI
        MOV     A,SBUF
        CJNE    A,#031H,CHECK_NEXT
        MOV     state,#01H
CHECK_NEXT:
        MOV     A,SBUF
        CJNE    A,#032H,BREAK
        MOV     state,#02H
BREAK:
        POP     PSW
        POP     ACC
        RETI    

///////////////////////////////////////////////////
//
//  Initial UART at Mode 1 and use Timer1 at mode 2
//  We set buad rete is 9600
//  11MHz / 12 / 16 / 9600 = 5.96 => 6
//  TH = 256-6 = 0xFA
//
///////////////////////////////////////////////////
INIT_UART:
        MOV     TMOD,#020H                          //Set Timer1 Mode 2
        MOV     SCON,#050H                          //Set UART Mode 1
        MOV     PCON,#080H                          //Set SMOD = 1
        MOV     TH1,#BRT                            //Set UART to operate at buad rate 9600
        MOV     TL1,#BRT
        SETB    TR1                                 //Start Timer1
        RET
///////////////////////////////////////////////////
//
//      Function:OutputDec()
//  Output Dec to Char and a space
//  Data input from R7
//  
///////////////////////////////////////////////////
OUTPUT_DEC:  
        MOV     A,R7
        MOV     B,#0AH
        DIV     AB
        MOV     R6,B        ;DataL is R6
        MOV     A,R7
        MOV     B,#0AH
        DIV     AB
        MOV     R7,A
        MOV     B,#0AH
        DIV     AB
        MOV     R5,B        ;DataM is R5
        MOV     A,R7
        MOV     B,#0AH
        DIV     AB
        MOV     R4,A        ;DataH is R4
        JNZ     SHOW_H_BYTE ;If A != 0 jmp
        MOV     R7,#020H
        LCALL   OUTPUT
        SJMP    M_BYTE
SHOW_H_BYTE:
        MOV     A,R4
        MOV     R7,A
        LCALL   OUTPUT
M_BYTE:
        MOV     A,R5
        JNZ     SHOW_M_BYTE
        MOV     A,R4
        JNZ     SHOW_M_BYTE
        MOV     R7,#020H
        LCALL   OUTPUT
        SJMP    SHOW_L_BYTE
SHOW_M_BYTE:
        MOV     A,R5
        MOV     R7,A
        LCALL   OUTPUT
SHOW_L_BYTE:
        MOV     A,R6
        MOV     R7,A
        LCALL   OUTPUT
        MOV     R7,#020H
        LCALL   OUTPUT
        RET     
///////////////////////////////////////////////////
//
//	Function:OutputHex()
//  Output HEX to Char and a space
//  Data input from R1
///////////////////////////////////////////////////
OUTPUT_HEX:
        MOV     A,R1
        SWAP    A
        ANL     A,#0FH
        MOV     R7,A
        LCALL   OUTPUT
        MOV     A,R1
        ANL     A,#0FH
        MOV     R7,A
        LCALL   OUTPUT
        MOV     R7,#020H
        LCALL   OUTPUT
        RET
///////////////////////////////////////////////////
//
//	Function:Output()
//  Output to RS232
//  Data input from R7
///////////////////////////////////////////////////
OUTPUT:
        MOV     A,R7
        SETB    C
        SUBB    A,#09H
        JC      IF_1           //IF < 9 JMP 1
        MOV     A,R7
        CLR     C
        SUBB    A,#010H
        JNC     IF_1           //IF > 16 JMP 1
        MOV     A,R7
        ADD     A,#037H
        MOV     SBUF,A
        SJMP    TI_LOOP
IF_1:
        MOV     A,R7
        CLR     C
        SUBB    A,#0AH
        JNC     IF_2
        MOV     A,R7
        ADD     A,#030H
        MOV     SBUF,A
        SJMP    TI_LOOP
IF_2:
        CJNE    R7,#0AAH,IF_3
        MOV     SBUF,#0AH
        SJMP    TI_LOOP
IF_3:
        CJNE    R7,#0DDH,IF_4
        MOV     SBUF,#0DH
        SJMP    TI_LOOP
IF_4:
        MOV     SBUF,R7
TI_LOOP:
        JNB     TI,TI_LOOP
        CLR     TI
        RET
///////////////////////////////////////////////////
//
//      Function:OutputTxt()
//  Output string to Char and a space
//  Input strlen R5 & string point DPTR
//
///////////////////////////////////////////////////
OUTPUT_TXT:
        MOV     R7,#0AAH
        LCALL   OUTPUT
        MOV     R7,#0DDH
        LCALL   OUTPUT
		MOV		A,#0H
TXT_LOOP:
		MOV		R4,A
		MOVC	A,@A+DPTR
        MOV     R7,A
        LCALL   OUTPUT
		MOV		A,R4
		INC		A
        DJNZ    R5,TXT_LOOP
        RET     
    	END
