///////////////////////////////////////////////////
//
//	FILE:		MPC89_Interrupt_Demo.c
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2008.4.17
//	PURPOSE:	Demo Interrupt config
//
///////////////////////////////////////////////////

//#define MPC82x54//and MPC82x52
//#define MPC82G516
//if not define either is MPC89 series

#ifdef MPC82x54
#include "REG_MPC82L54.H"
#else
#ifdef MPC82G516
#include "REG_MPC82G516.H"
#else
#include "REG_MPC89L51-515.H"
#endif
#endif
///////////////////////////////////////////////////
//
//	Function:Init_IRQ()
//  Description:
//              Initial interrupt setting
//
///////////////////////////////////////////////////
void Init_IRQ()
{
    EA      =   0x01;   //Enable All Interrupt
    EX0     =   0x01;   //Enable External Interrupt 0
    ET0     =   0x01;   //Enable Timer Interrupt 0
    EX1     =   0x01;   //Enable External Interrupt 1
    ET1     =   0x01;   //Enable Timer Interrupt 1
    ES      =   0x01;   //Enable Serial Interrupt
#ifdef MPC82x54
    ESPIADC =   0x01;   //Enable SPI and ADC Interrupt
    EPCALVD =   0x01;   //Enable PCA and LVD Interrupt
#else
    ET2     =   0x01;   //Enable Timer Interrupt 2
    EX2     =   0x01;   //Enable External Interrupt 2
    EX3     =   0x01;   //Enable External Interrupt 3
#endif
#ifdef MPC82G516
    AUXIE   |=  0x01;   //Enable SPI Interrupt
    AUXIE   |=  0x02;   //Enable ADC Interrupt
    AUXIE   |=  0x04;   //Enable PCA Interrupt
    AUXIE   |=  0x08;   //Enable LVI Interrupt
    AUXIE   |=  0x10;   //Enable UART 2 Interrupt
    AUXIE   |=  0x20;   //Enable KBI Interrupt
#endif
}
void Main()
{
    Init_IRQ();
}
void External_Interrupt_0() interrupt 0
{
}
void Timer_Interrupt_0() interrupt 1
{
}
void External_Interrupt_1() interrupt 2
{
}
void Timer_Interrupt_1() interrupt 3
{
}
void Serial_Interrupt() interrupt 4
{
}
#ifdef MPC82x54
void SPI_ADC_Interrupt() interrupt 5
{
}
void PCA_LVF_Interrupt() interrupt 6
{
}
#else//MPC89 or MPC82G516
void Timer_Interrupt_2() interrupt 5
{
}
void External_Interrupt_2() interrupt 6
{
}
void External_Interrupt_3() interrupt 7
{
}
#endif
#ifdef MPC82G516
///////////////////////////////////////////////////
//
//	Function:SPI_Interrupt()
//  Description:
//              Serial peripheral interrupt
//
///////////////////////////////////////////////////
void SPI_Interrupt() interrupt 8
{
}
///////////////////////////////////////////////////
//
//	Function:ADC_Interrupt()
//  Description:
//              A/D converter interrupt
//
///////////////////////////////////////////////////
void ADC_Interrupt() interrupt 9
{
}
///////////////////////////////////////////////////
//
//	Function:PCA_Interrupt()
//  Description:
//              Program counter array interrupt
//
///////////////////////////////////////////////////
void PCA_Interrupt() interrupt 10
{
}
///////////////////////////////////////////////////
//
//	Function:LVI_Interrupt()
//  Description:
//              Low-Voltage interrupt
//
///////////////////////////////////////////////////
void LVI_Interrupt() interrupt 11
{
}
///////////////////////////////////////////////////
//
//	Function:UART2_Interrupt()
//  Description:
//              Secondary UART interrupt
//
///////////////////////////////////////////////////
void UART2_Interrupt() interrupt 12
{
}
///////////////////////////////////////////////////
//
//	Function:KBI_Interrupt()
//  Description:
//              Keypad interrupt
//
///////////////////////////////////////////////////
void KBI_Interrupt() interrupt 13
{
}
#endif
