///////////////////////////////////////////////////
//
//	FILE:		MPC89_Interrupt_Demo.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2008.4.17
//	PURPOSE:	Demo Interrupt config
//
///////////////////////////////////////////////////
//#define MPC82x54//and MPC82x52
//#define MPC82G516
//if not define either is MPC89 series

#ifdef MPC82x54
#include "REG_MPC82L54.INC"
#else
#ifdef MPC82G516
#include "REG_MPC82G516.INC"
#else
#include "REG_MPC89L51-515.INC"
#endif
#endif

    ORG	    0000H	
    JMP	    START
    ORG	    0003H
    JMP     EXTERNAL_INTERRUPT_0
    ORG	    000BH
    JMP	    TIMER_INTERRUPT_0
    ORG	    0013H
    JMP     EXTERNAL_INTERRUPT_1
    ORG	    001BH
    JMP	    TIMER_INTERRUPT_1
    ORG	    0023H
    JMP	    SERIAL_INTERRUPT
#ifdef MPC82x54
    ORG     002BH
    JMP     SPI_ADC_INTERRUPT
    ORG     002BH
    JMP     PCA_LVF_INTERRUPT
#else
    ORG	    002BH
    JMP	    TIMER_INTERRUPT_2
    ORG	    0033H
    JMP     EXTERNAL_INTERRUPT_2
    ORG	    003BH
    JMP     EXTERNAL_INTERRUPT_3
#endif
#ifdef MPC82G516
    ORG	    0043H
    JMP     SPI_INTERRUPT
    ORG	    004BH
    JMP     ADC_INTERRUPT
    ORG	    0053H
    JMP     PCA_INTERRUPT
    ORG	    005BH
    JMP     LVI_INTERRUPT
    ORG	    0063H
    JMP     UART2_INTERRUPT
    ORG	    006BH
    JMP     KBI_INTERRUPT
#endif
    ORG	    0100H
START:
    SETB    EA          //Enable All Interrupt
    SETB    EX0         //Enable External Interrupt 0
    SETB    ET0         //Enable Timer Interrupt 0
    SETB    EX1         //Enable External Interrupt 1
    SETB    ET1         //Enable Timer Interrupt 1
    SETB    ES          //Enable Serial Interrupt
#ifdef MPC82x54
    SETB    ESPIADC     //Enable SPI and ADC Interrupt
    SETB    EPCALVD     //Enable PCA and LVD Interrupt
#else
    SETB    ET2         //Enable Timer Interrupt 2
    SETB    EX2         //Enable External Interrupt 2
    SETB    EX3         //Enable External Interrupt 3
#endif
#ifdef MPC82G516
    ORL     AUXIE,#01H  //Enable SPI Interrupt
    ORL     AUXIE,#02H  //Enable ADC Interrupt
    ORL     AUXIE,#04H  //Enable PCA Interrupt
    ORL     AUXIE,#08H  //Enable LVI Interrupt
    ORL     AUXIE,#10H  //Enable UART 2 Interrupt
    ORL     AUXIE,#20H  //Enable KBI Interrupt
#endif
LOOP:
    JMP     LOOP
EXTERNAL_INTERRUPT_0:
    RETI
TIMER_INTERRUPT_0:
    RETI
EXTERNAL_INTERRUPT_1:
    RETI
TIMER_INTERRUPT_1:
    RETI
SERIAL_INTERRUPT:
    RETI
#ifdef MPC82x54
SPI_ADC_INTERRUPT:
    RETI
PCA_LVF_INTERRUPT:
    RETI
#else
TIMER_INTERRUPT_2:
    RETI
EXTERNAL_INTERRUPT_2:
    RETI
EXTERNAL_INTERRUPT_3:
    RETI
#endif
#ifdef MPC82G516
SPI_INTERRUPT:
    RETI
ADC_INTERRUPT:
    RETI
PCA_INTERRUPT:
    RETI
LVI_INTERRUPT:
    RETI
UART2_INTERRUPT:
    RETI
KBI_INTERRUPT:
    RETI
#endif
    END
