/*********************************************************************
*    Project: MG82F5B32-DEMO
*			MG82F5B32 LQFP32_V10 EV Board (TH156A)
*			CpuCLK=12MHz, SysCLK=12MHz
*    Description:
*			UART1Mode4 (SPI Master)
*			SPICLK <-->TXD1	P13
*			MOSI   <-->RXD1 P12
*			MISO   <-->S1MI P10
*			NSS    <-->     P11	
*    Note:
*			
*    Creat time:
*    Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F5Bxx.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F5B32.H"
#include ".\include\API_Uart_BRGRL_MG82F5B32.H"

/*************************************************
*Set SysClk (MAX.50MHz)
*Selection:
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.32MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P25
#define LED_R		P26
#define LED_G_1		P27

#define SPI_NSS		P11

// Clock polarity(CPOL)
#define SPICLK_LOW	0	// SPICLK  Low
#define SPICLK_HIGH	1	// SPICLK  High
#define SPI_CPOL  SPICLK_LOW	

// Data order
#define LSB	0	// LSB
#define MSB	1	// MSB
#define SPI_DORD	MSB

// Clock source
#define SPI_CLK_SYSCLK_4	0	// SYSCLK/4
#define SPI_CLK_SYSCLK_12	1	// SYSCLK/12
#define SPI_CLOCK	SPI_CLK_SYSCLK_4

/*************************************************
*Function:     	void DelayXus(u16 xUs)
*Description:   	delay,unit:us
*Input:     		u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     	void DelayXms(u16 xMs)
*Description:    delay,unit:ms
*Input:     		u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   	void InitPort()
*Description:	Initialize IO Port
*Input:   
*Output:   		
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2OpenDrain(0xFF);				// Set P2 as open drain
	PORT_EnP24P25P26P27PullHigh();			// Enable P24,P25,P26,P27 pull-high
	PORT_SetP1PushPull(BIT1|BIT2|BIT3);		// Set P13(SPICLK),P12(MOSI),P11(nSS) as push pull
	PORT_SetP1OpenDrain(BIT0);				// Set P10(MISO) as open drain
	PORT_EnP10P11P12P13PullHigh();			// Enable P10,P11,P12,P13 pull-high
}
/***********************************************************************************
*Function:   	BYTE Uart1SPITransceiver(BYTE ToSend)
*Description:   	UART1 SPI Master transmit and receive data
*Input:   		BYTE ToSend
*Output:     
*************************************************************************************/
BYTE Uart1SPITransceiver(BYTE ToSend)
{
	u8 x;
#if (SPI_CPOL==SPICLK_LOW)									
	P13 = 0;					// SPICLK  Low
#else	
	P13 = 1;					// SPICLK  High
#endif
	SFR_SetPage(1);

#if (SPI_DORD==MSB)
	BOREV=ToSend;
	S1BUF=BOREV;
#else
	S1BUF=ToSend;
#endif
	while(TI1==0);
	TI1=0;
#if (SPI_DORD==MSB)
	BOREV=S1BUF;
	x=BOREV;
#else
	x=S1BUF;
#endif
	SFR_SetPage(0);
	return x;
}

/***********************************************************************************
*Function:   	void InitUart1_SPI_Master(void)
*Description:   	Initialize Uart1, SPI Master
*Input:   
*Output:     
*************************************************************************************/
void InitUart1_SPI_Master(void)
{
#if (SPI_CPOL==SPICLK_LOW)									
	P13 = 0;					// SPICLK  Low
#else	
	P13 = 1;					// SPICLK  High
#endif
	UART1_SetModeSPIMaster();			// UART0 Mode: SPI-Master
#if (SPI_CLOCK == SPI_CLK_SYSCLK_4)
	UART1_SetSPIClock_SYSCLKDiv4(); 	// Clock source: SYSCLK/4
#else
	UART1_SetSPIClock_SYSCLKDiv12();	// Clock source: SYSCLK/12
#endif
	

	
}

/***********************************************************************************
*Function:       void InitSystem(void)
*Description:    Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart1_SPI_Master();
}

void main()
{
	InitSystem();
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;	
	while(1)
	{
		DelayXms(100);
		LED_G_0 = !LED_G_0;	
		SPI_NSS=0;
		Uart1SPITransceiver(0x05);	
		SPI_NSS=1;
	}

}


