#include "GLOBAL.H"
#include "USB.H"
#include "MCU.H"


//-----USB.C-----//
extern EP0INFO Ep0;
extern void USB_Int( void );


BYTE T0Cnt;                                      // Timer0 Count

BYTE Wdt;


void Delay_Xms( BYTE X )
  { TR0 = CLR;                                   // Disable Timer0
  
    T0Cnt = X;                                   // X*1ms = Xms
    
    TL0 = T0_1MSL;
    TH0 = T0_1MSH;
    TR0 = SET;                                   // Enable Timer0
    while( T0Cnt );
  }


void Reboot_Mcu( BYTE Cmd )
  { ISPCR = Cmd;
  }


void INT_USB(void) interrupt 15 using 3          // 
  { WDTCR = Wdt;                                 // Reset Watch Dog Timer
    USB_Int();
  }


void INT_KB(void) interrupt 13 using 2           // 
  { WDTCR = Wdt;
  
    KBCON = 0x00;                                // Clear KP Interrupt Flag
    KBMASK = 0x00;                               // Will Disable KP Interrupt
  }


void INT_TIMER0(void) interrupt 1 using 1        // Timer0 Interrupt
  { WDTCR = Wdt;                                 // Reset Watch Dog Timer
    
    TR0 = CLR;                                   // Disable Timer0
    
    if ( T0Cnt )
      { T0Cnt--;
        TL0 = T0_1MSL;
        TH0 = T0_1MSH;
        TR0 = SET;                               // Enable Timer0
      }
  }


void Initial_Mcu( void )
  { IE  = 0x00;	                                 // disable all interrupt
    
    EIE1 = ( EUSB | EKB );                       // Enable USB and KB int
    EIP1L = 0x20;                                // KB high priority
    
    PSW = 0x00;	                                 // bank 0
    IP  = 0x12;	                                 // hi priority: UART / Timer0
    
    TMOD = 0x11;                                 // Set Timer0/1 in Mode1/2 ( 16/8 bit )
    TR0 = 0;                                     // Desable Timer0
    ET0 = 1;                                     // Enable Timer0 interrupt
    
    Wdt = 0x17;
    WDTCR = Wdt;
    
    CKCON0 |= ENCKM;                             // Enable Clock Multiplier

    EA  = 1;                                     // Enable all interrupt
    
    Delay_Xms( 10 ); 
	
    CKCON0 |= ENUSB;                             // Enable USB clock for USB fucntion
    
    Delay_Xms( 250 );
  }