#include "REG_MG84FG516.H"
#include "Define.H"
#include "Extern.H"
#include "SPI.H"


extern BYTE OutLen;
extern XBYTE OutBuffer[SPI_MAX];

extern SPI Spi;


void INT_SPI(void) interrupt 8 using 2
  { if ( Spi.Mode == SPI_SLAVER )                // In Slaver Mode
      { OutBuffer[Spi.In_Addr] = SPDAT;          // Return DATA to Master
        SPDAT = OutBuffer[Spi.In_Addr];          // Only for TEST
        Spi.In_Addr++;
      	Spi.Data_Cnt++;
      	if ( Spi.In_Addr == SPI_MAX )            // Top of " OutBuffer "
      	  Spi.In_Addr = 0;                       // Reset " In_Addr " from 0
      }
    else                                         // In Master Mode
      Spi.Tx_Busy = CLR;
    
    SPSTAT |= SPIF;                              // Write 1 to clear
  }