#include "EasyCOM.H"


void USB_Event( void );
void UART_Event( void );

//BYTE OutLen = 0;
//BYTE OutBuffer[64];

void main( void )
  { Initial();                                   // Do not remove
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
            USB_Send_Data_To_PC( InLen , InBuffer );
            USB_Read_Data_Complete();            // Do not remove
          }
        
        // To do..
        
        /* Will send data to PC ?? If yes , enable the following function call */
        
        /* In order to gain the best performance, the value of "OutLen" should be  
           the multiple of 63. ( Exp: OutLen = 63, 126, 189, and ... ) */
        // USB_Send_Data_To_PC( OutLen , OutBuffer );
        
        USB_Event();                             // Check USB power event
        
        UART_Event();                            // Check Uart Line/Modem event
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
  }


void UART_Error( void )
  { Com.State = 0x00;
    // To do
    /*
    Rx Carrier occur ?
    Com.State |= UART_RX_CARRIER;
    
    Tx Carrier occur ?
    Com.State |= UART_TX_CARRIER;
    
    Break occur ?
    Com.State |= UART_BREAK;
    
    Ring signal occur ?
    Com.State |= UART_RING_SIGNAL;
    
    Fram error occur ?
    Com.State |= UART_FRAM_ERROR;
    
    Parity check error occur ?
    Com.State |= UART_PARITY_ERROR;
    
    Over run occur ?
    Com.State |= UART_OVER_RUN;
    */
  }


void UART_Event( void )                          // Do not remove
  { if ( Com.LC.Flag )                           // Line codeing setting by Host ( PC )
      { switch( Com.LC.BaudRate.DW )             // Com.LC.BaudRate.B[3] = LSB , Com.LC.BaudRate.B[0] = MSB
          { case 1200:   // To do
                         break;
            case 2400:   // To do
                         break;
            case 4800:   // To do
                         break;
            case 9600:   // To do
                         break;
            case 19200:  // To do
                         break;
            case 38400:  // To do
                         break;
            case 57600:  // To do
                         break;
            case 115200: // To do
                         break;
            case 7200:   // To do
                         break;
            case 14400:  // To do
                         break;
          }
        Com.LC.Flag = CLR;                       // Release this flag
      }
    if ( Com.LS.Flag )                           // Line state setting by Host ( PC )
      { // To do ( Depend on " Com.LS.State " )
      	Com.LS.Flag = CLR;                       // Release this flag
      }
    if ( Com.SB.Flag )                           // Send break by Host ( PC )
      { // To do ( Depend on " Com.SB.Time.W " )
      	Com.SB.Flag = CLR;                       // Release this flag
      }
    
    UART_Error();                                // To do
    if ( Com.State )
      USB_Send_UartState_To_PC( Com.State );
  }