/**
 * @file    UserMisc.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the misc firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __USERMISC_H
#define __USERMISC_H

#ifdef __cplusplus
 extern "C" {
#endif



/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include "mg32f10x.h"

/* Exported types ------------------------------------------------------------*/
/** 
  * @brief  Status structures definition  
  */  
typedef enum 
{
    MG32_OK       = 0x00U,
    MG32_ERROR    = 0x01U,
    MG32_BUSY     = 0x02U,
    MG32_TIMEOUT  = 0x03U
}MG32_StatusTypeDef;

/** 
  * @brief  Lock structures definition  
  */
typedef enum 
{
    MG32_UNLOCKED = 0x00U,
    MG32_LOCKED   = 0x01U  
}MG32_LockTypeDef;


/* Exported constants --------------------------------------------------------*/
/** @defgroup Exported_Constants Exported Constants
  * @{
  */

/** @defgroup TICK_FREQ Tick Frequency
  * @{
  */
typedef enum
{
    MG32_TICK_FREQ_10HZ         = 100U,
    MG32_TICK_FREQ_100HZ        = 10U,
    MG32_TICK_FREQ_1KHZ         = 1U,
    MG32_TICK_FREQ_DEFAULT      = MG32_TICK_FREQ_1KHZ
}MG32_TickFreqTypeDef;


/** @defgroup CORTEX_SysTick_clock_source CORTEX SysTick clock source
  * @{
  */
#define SYSTICK_CLKSOURCE_HCLK_DIV8    (0x00000000U)
#define SYSTICK_CLKSOURCE_HCLK         (0x00000004U)


/* Exported macro ------------------------------------------------------------*/
#define MG32_MAX_DELAY      0xFFFFFFFFU

/* Exported functions --------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void MG32_NVIC_SetPriority(IRQn_Type IRQn, uint32_t PreemptPriority, uint32_t SubPriority);
void MG32_NVIC_EnableIRQ(IRQn_Type IRQn);
void MG32_NVIC_DisableIRQ(IRQn_Type IRQn);


void MG32_NVIC_SystemReset(void);


uint32_t MG32_SYSTICK_Config(uint32_t TicksNumb);
uint32_t MG32_NVIC_GetPriority(IRQn_Type IRQn);
void MG32_NVIC_SetPendingIRQ(IRQn_Type IRQn);
void MG32_NVIC_ClearPendingIRQ(IRQn_Type IRQn);
void MG32_SYSTICK_CLKSourceConfig(uint32_t CLKSource);
void MG32_SYSTICK_Callback(void);
void MG32_SYSTICK_IRQHandler(void);


MG32_StatusTypeDef MG32_InitTick(uint32_t TickPriority);
void MG32_IncTick(void);
uint32_t MG32_GetTick(void);
uint32_t MG32_GetTickPrio(void);
MG32_StatusTypeDef MG32_SetTickFreq(MG32_TickFreqTypeDef Freq);
MG32_TickFreqTypeDef MG32_GetTickFreq(void);
void MG32_Delay(uint32_t Delay);
void MG32_SuspendTick(void);
void MG32_ResumeTick(void);


#ifdef __cplusplus
}
#endif

#endif /* __USERMISC_H */


