/**
 * @file    CmdSet.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the CmdSet firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __CMDSET_H
#define __CMDSET_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"

//#include "MG32x02z_ChipInit.h" //載入MG32x02z晶片初始化定義檔；AMO;2018.03.10	
//#include "MG32x02z_DRV.h"
//#include "PrtDriver.h"
//#include "Sample.h"            //載入MG32x02z晶片外設基本功能應用API函數檔；AMO;2018.03.10	
#include "string.h"

//#include "RcvBuf.h"
//#include "Interface.h"
#include "PrtBuf.h"
//#include "PrtHead.h"
//#include "Hw_config.h"
#include "BarCode.h"
#include "CmdSet.h"
#include "BarCode_app.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
extern uint32_t URT_data;
extern uint32_t Test_motor_step;

/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define EOT     0x04
#define ENQ     0x05
#define GS      0x1d
#define HT      0x09
#define LF      0x0a
#define FF      0x0c
#define CRx     0x0d
#define DLE     0x10
#define DC      0x11
#define ESC     0x1b
#define FS      0x1c
#define US      0x1f

#define LSB     1
#define BIT0    LSB
#define BIT1    2
#define BIT01   3
#define BIT2    4
#define BIT3    8
#define BIT23   12
#define BIT4    16
#define BIT5    32
#define BIT6    64
#define BIT56   96
#define BIT7    128

#define LINE_SPACE  6


/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

extern void ExecuteCmd(uint8_t data);
extern void ESC_ATInit(void);
extern void GS_k(void);

#ifdef __cplusplus
}
#endif

#endif /* __CMDSET_H */

