



//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode_app.c］
//=========================================================================================================
//* File Name     :barcode_app.C
//* Description   : 条码的相关处理C文件
//=========================================================================================================


/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "BarCode_app.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/


//#define  SIZE_3
//#define BYTE_LEN  8

//#define CLR_WDG   //清理看门狗，如果有这这加上宏，如果没有可去掉

#ifdef  SIZE_3       //如果定义了3寸 
#define LINE_DOTS    640  //3寸的点数
#else
#define LINE_DOTS    384  //2寸的点数
#endif

//#define PRINT_QUEUE_SIZE  24  //打印队列的长度
//#define PAGES                 //自定义大小
//#define PAGES_SIZE            //自定义大小
//uint16_t CursorX;             //X坐标值
//uint8_t aPrintBuf[PAGES][PAGES_SIZE];    //打印缓存区

/*typedef struct Tag_SPrint 
{
    uint8_t  Mode;          //打印的模式 
    uint8_t  PrintRow;      //打印PrintRow点行
    uint8_t  SpaceRow;      //走纸SpaceRow点行
    uint8_t  AllRow;        //所有的行
    uint8_t  WideAmp;       //宽的放大倍数 
    uint8_t  HihgAmp;       //高的放大倍数  
    u16 Dph;                //打印缓冲区序号
}TagSPrint;  

TagSPrint PrintQueue[PRINT_QUEUE_SIZE];   //打印队列，大小为20 */

//TagSPrint * pPrintQueueIn  = PrintQueue; //打印队列的入队指针
//TagSPrint * pPrintQueueOut = PrintQueue; //打印队列的出队指针

//u16 PrintBuf_Head = 0;  //打印缓冲区的头
//u16 PrintBuf_Tail = 0;  //打印缓冲区的尾 

//code39的编码库
const uint16_t aCode39[44][2] = 
{
    0x30,0x0A6D,    //0   0       101001101101
    0x31,0x0D2B,    ////  11      110100101011
    0x32,0x0B2B,    //2// 2       101100101011
    0x33,0x0D95,    //3// 3       110110010101
    0x34,0x0A6B,    //4// 4       101001101011
    0x35,0x0D35,    //5   5       110100110101
    0x36,0x0B35,    //6   6       101100110101
    0x37,0x0A5B,    //7   7       101001011011
    0x38,0x0D2D,    //8   8       110100101101
    0x39,0x0B2D,    //9   9       101100101101
    0x41,0x0D4B,    //10  A       110101001011
    0x42,0x0B4B,    //11  B       101101001011
    0x43,0x0DA5,    //12  C       110110100101
    0x44,0x0ACB,    //13  D       101011001011
    0x45,0x0D65,    //14  E       110101100101
    0x46,0x0B65,    //15  F       101101100101
    0x47,0x0A9B,    //16  G       101010011011
    0x48,0x0D4D,    //17  H       110101001101
    0x49,0x0B4D,    //18  I       101101001101
    0x4a,0x0ACD,    //19  J       101011001101
    0x4b,0x0D53,    //20  K       110101010011
    0x4c,0x0B53,    //21  L       101101010011
    0x4d,0x0DA9,    //22  M       110110101001
    0x4e,0x0AD3,    //23  N       101011010011
    0x4f,0x0D69,    //24  O       110101101001
    0x50,0x0B69,    //25  P       101101101001
    0x51,0x0AB3,    //26  Q       101010110011
    0x52,0x0D59,    //27  R       110101011001
    0x53,0x0B59,    //28  S       101101011001
    0x54,0x0AD9,    //29  T       101011011001
    0x55,0x0CAB,    //30  U       110010101011
    0x56,0x09AB,    //31  V       100110101011
    0x57,0x0CD5,    //32  W       110011010101
    0x58,0x096B,    //33  X       100101101011
    0x59,0x0CB5,    //34  Y       110010110101
    0x5a,0x09B5,    //35  Z       100110110101
    0x2d,0x095B,    //36  -       100101011011
    0x2e,0x0CAD,    //37  .       110010101101
    0x20,0x09AD,    //38  SPACE   100110101101
    0x24,0x0925,    //39  $       100100100101
    0x2f,0x0929,    //40  /       100100101001
    0x2b,0x0949,    //41  +       100101001001
    0x25,0x0A49,    //42  %       101001001001
    0x2a,0x096D     //n/a *       100101101101
};  

//code128的编码库
const uint16_t aCode128[107] = 
{
    0x06CC, 0x066C, 0x0666, 0x0498, 0x048C, 0x044C, 0x04C8, 0x04C4, 0x0464, 0x0648, 0x0644, 0x0624, 0x059C, 0x04DC, 0x04CE, 0x05CC,
    0x04EC, 0x04E6, 0x0672, 0x065C, 0x064E, 0x06E4, 0x0674, 0x076E, 0x074C, 0x072C, 0x0726, 0x0764, 0x0734, 0x0732, 0x06D8, 0x06C6,
    0x0636, 0x0518, 0x0458, 0x0446, 0x0588, 0x0468, 0x0462, 0x0688, 0x0628, 0x0622, 0x05B8, 0x058E, 0x046E, 0x05D8, 0x05C6, 0x0476,
    0x0776, 0x068E, 0x062E, 0x06E8, 0x06E2, 0x06EE, 0x0758, 0x0746, 0x0716, 0x0768, 0x0762, 0x071A, 0x03BA, 0x0642, 0x078A, 0x0530,
    0x050C, 0x04B0, 0x0486, 0x042C, 0x0426, 0x0590, 0x0584, 0x04D0, 0x04C2, 0x0434, 0x0432, 0x0612, 0x0650, 0x07BA, 0x0614, 0x047A,
    0x053C, 0x04BC, 0x049E, 0x05E4, 0x04F4, 0x04F2, 0x07A4, 0x0794, 0x0792, 0x06DE, 0x06F6, 0x07B6, 0x0578, 0x051E, 0x045E, 0x05E8,
    0x05E2, 0x07A8, 0x07A2, 0x05DE, 0x05EE, 0x075E, 0x07AE, 0x0684, 0x0690, 0x069C, 0x18eb
};

//EAN13码奇偶校验 
const uint8_t aEanParity[10]={0x00, 0x0b, 0x0d, 0x0e, 0x13, 0x19, 0x1c, 0x15, 0x16, 0x1a}; //0表示ODD, 1表示EVEN 
 
//EAN13的编码库
const uint8_t aEan[33]=
{
  //0     1     2     3     4     5     6     7     8     9
    0x0d, 0x19, 0x13, 0x3d, 0x23, 0x31, 0x2f, 0x3b, 0x37, 0x0b,  //Left ODD
    0x27, 0x33, 0x1b, 0x21, 0x1d, 0x39, 0x05, 0x11, 0x09, 0x17,  //Left EVEN(第5个由0x1e改为0x1d)
    0x72, 0x66, 0x6c, 0x42, 0x5c, 0x4e, 0x50, 0x44, 0x48, 0x74,  //Right
    0x05, //START FLAG
    0x0a, //MID   FLAG
    0x05  //END   FLAG
};     

//UPCE码奇偶校验 
const uint8_t aUpceParity[10] = {0x38, 0x34, 0x32, 0x31, 0x2C, 0x26, 0x23, 0x2A, 0x29, 0x25}; ////0表示ODD, 1表示EVEN

//UPCE的编码库
const uint8_t aUpce[22]=
{             
  //0     1     2     3     4     5     6     7     8     9
    0x0d, 0x19, 0x13, 0x3d, 0x23, 0x31, 0x2f, 0x3b, 0x37, 0x0b,    //奇
    0x27, 0x33, 0x1b, 0x21, 0x1d, 0x39, 0x05, 0x11, 0x09, 0x17,    //偶
    0x05, //START FLAG
    0x15  //END   FLAG
};

//code93的编码库(含校验字符10(数字) + 26(大小字母) +7(特殊字符) +5(2模校验码)+1(结束符))
const uint16_t aCode93[49] = 
{
    0x0114, 0x0148, 0x0144, 0x0142, 0x0128, 0x0124, 0x0122, 0x0150, 0x0112, 0x010A,
    0x01A8, 0x01A4, 0x01A2, 0x0194, 0x0192, 0x018A, 0x0168, 0x0164, 0x0162, 0x0134,
    0x011A, 0x0158, 0x014C, 0x0146, 0x012C, 0x0116, 0x01B4, 0x01B2, 0x01AC, 0x01A6,
    0x0196, 0x019A, 0x016C, 0x0166, 0x0136, 0x013A, 0x012E, 0x01D4, 0x01D2, 0x01CA,
    0x016E, 0x0176, 0x01AE, 0x0126, 0x01DA, 0x01D6, 0x0132, 0x015E, 0x0001
};  

//CodaBar的编码库(含校验字符10(数字) + 6(特殊字符) + 4(A/B/C/D))
const uint8_t aCodaBar[20] = 
{
    0x03, 0x06, 0x09, 0x60, 0x12, 0x42, 0x21, 0x24, 0x30, 0x48,  //0~9
    0x0C, 0x18, 0x45, 0x51, 0x54, 0x15, 0x1A, 0x29, 0x0B, 0x0E   //特殊字符/A/B/C/D
};  

//ITF的编码库
const uint8_t aITF[12] = 
{
  //0     1     2     3     4     5     6     7     8     9
    0x06, 0x11, 0x09, 0x18, 0x05, 0x14, 0x0C, 0x03, 0x12, 0x0A, //0~9
    0x0A, 0x1D  //起始符及结束符
};  

//#define PM_NORMAL    0          //正常打印模式
//#define VOID_PAGE    0xfffe     //无打印页
uint32_t GetUpceDat(uint8_t Dat);
uint32_t GetCode93Dat(uint8_t Dat);
uint32_t GetCode39Dat(uint8_t Dat);
uint32_t GetCode128Dat(uint8_t Dat);
uint32_t GetEanDat(uint8_t Dat);
//uint32_t GetEan8Dat(uint8_t Dat);
void PrintOneBarCode39(void);
void PrintOneBarCode128(void);
void PrintOneBarEan8(void);
void PrintOneBarEan13(void);
void PrintOneBarUPCA(void);
void PrintOneBarUPCE(void);
void PrintOneBarITF(void);
void PrintOneBarCodaBar(void);
void PrintOneBarCode93(void);


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode_app.c］

//=========================================================================================================
// Function:     PrintQueueIn
//Description:  打印队列的写指针后移动
//=========================================================================================================
//void PrintQueueIn(void)
//{

//}

//=========================================================================================================
//Name:        SetByteFromEnd
//Description: 改变一个字节的低几位
//Input:       *pDat       - 要改变的字节的指针
//             ucResLen    - 剩下的长度
//             ucactionLen - 实际要写入的长度
//             ucDat       - 低位要写入的新内容
//=========================================================================================================
void SetByteFromLow(uint8_t* pDat, uint8_t ucResLen, uint8_t ucactionLen, uint8_t ucDat) //完全沒有使用到;AMO;2018.05.25
{ 
   (*pDat) = ((*pDat) & (0xff << ucResLen)) | (ucDat << (ucResLen - ucactionLen));
}  
  
//=========================================================================================================
//Name:        SetByteFromEnd
//Description: 改变一个字节的高几位
//Input:       pDat  - 要改变的字节的指针 
//             ucLen - 写入的长度
//             ucDat - 低位要写入的新内容
//=========================================================================================================
void SetByteFromHigh(uint8_t* pDat, uint8_t ucLen, uint8_t ucDat) //完全沒有使用到;AMO;2018.05.25
{ 
 (*pDat) = ((*pDat) & (0xff >> ucLen)) | (ucDat << (8 - ucLen));  
}

//=========================================================================================================
//Name:        GetCutByte
//Description: 从传入指针所指向的数据中，截取指定长度的数据，
//Input:       Pdat  - 数据的指针
//             ucLen - 截取的长度 
//             ucSelfLen - 经过处理之后的数据本身长度
//             每移位后，数据本身的长度都会减少    
//Return:      返回截取的8BIT长度的数据
//=========================================================================================================
uint8_t GetCutByte(int Dat, uint8_t ucLen, uint8_t ucSelfLen) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t ret =0;
    ret =  ((uint8_t)( Dat >> (ucSelfLen - ucLen))) & (0xff >> (8 - ucLen));
    return ret;    
} 

//=========================================================================================================
//   Function:      DatLineToPrintBuf
//   Description:   输出一个字符的条码到打印缓冲区
//=========================================================================================================
void DatLineToPrintBuf(int ulDat, uint8_t ucDatLen)//,uint16_t usCurX,uint8_t ucline) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t temp, bit, cData, wide;

    for(bit = 0; bit < ucDatLen; bit++)
    {
        temp = ((ulDat >> (ucDatLen - bit - 1) ) & 0x01 );
        if(temp)
            cData = 0xff;
        else
            cData = 0x00;
        for(wide = 0; wide < tag_OneBar.WideAmp; wide++)//填充放大倍数
        {
            PrtBuf[cCurrentFillRow].ByteLine[0].BasePrtLine[iCurrentFillColumn] = cData;
            iCurrentFillColumn++;
        }
    }
 }
 
//=========================================================================================================
//  Function:       BarOut
//  Description:    输出一个字符的条码到打印缓冲区
//  Input:          Dat:输入的字符数据
//=========================================================================================================
uint8_t  BarOut(uint8_t Dat,uint8_t style) //完全沒有使用到;AMO;2018.05.25
{ 
    uint8_t  ucTmpLen;    //一行的BIT个数 
//    uint16_t usTmpCurX;   //临时的X光标  
    int ulTmpRowCh = 0 ;        //一行数据的内容 
         
    if(style == CODE39)   
    { 
    ucTmpLen =  CODE39_LEN;   ////一个code39条码的长度 12个基本单元，由 1表示 暗，0 表示亮

        ulTmpRowCh = GetCode39Dat(Dat); //获取字符对应的码元信息(如 0 对应 101001101101)

        if (ERROR_CHAR == ulTmpRowCh) 
        {
            return ERROR_CHAR;      
        }  
    }
    else if(style == ITF) 
    {
        if(Dat == ITF_BLACK_WITDH)  //宽条
        {
            ucTmpLen = ITF_WIDTH_LEN;
            ulTmpRowCh = (uint32_t)0x03;
        }
        else    //窄条
        {
            ucTmpLen = ITF_NARROW_LEN;
            ulTmpRowCh = (uint32_t)0x01; 
        }
    }
    else if(style == CODE93)
    {
        if(Dat == CODE93_LASTONEDOT)    //如果是最后一位的话用一个点表示
        {
            ucTmpLen = CODE93_LASTLEN;
        }
        else
        {
            ucTmpLen = CODE93_LEN;
        }
        ulTmpRowCh = GetCode93Dat(Dat); //输入的是ID号 
    }
    else if(style == CODABAR)
    {
        if(Dat == CODABAR_BLACK_SINGLE)
        {
            ucTmpLen = CODABAR_THIN_LEN;
            ulTmpRowCh = (uint32_t)0x01;
        }
        else
        {
            ucTmpLen = CODABAR_THICK_LEN;
            ulTmpRowCh = (uint32_t)0x03;
        }
    }
    else if(style == UPCE)
    {
        if(Dat == UPCE_START)
        {
            ucTmpLen = UPCE_START_LEN;
        }
        else if(Dat == UPCE_END)
        {
            ucTmpLen = UPCE_END_LEN;
        }
        else
        {
            ucTmpLen = UPCE_LEN;
        }
        ulTmpRowCh = GetUpceDat(Dat);   //输入的是转换后的对应值 
    }
    else if(style == CODE128)
    {   
        if ( CODE128_START_STOP == Dat )
        {
            ucTmpLen = CODE128_END_LEN;  //CODE128的结束符长度为13，与普通起始符长度和码元长度11不同
        }
        else    
        {
            ucTmpLen = CODE128_LEN;     //普通起始符长度和码元长度11
        }
        ulTmpRowCh = GetCode128Dat(Dat);   //获取128码元信息
    }
    else if((style == EAN13) || (style == EAN8))
    {
        if( (EAN_START == Dat) || (EAN_END == Dat) ) //EAN8和EAN13的起始符号，长度，字元信息都一样
        {
            ucTmpLen = EAN_SEG_LEN;   // EAN8和EAN13的起始符号长度都是 3
        }
        else if (EAN_MID == Dat) 
        {
            ucTmpLen = EAN_MID_LEN;    // EAN8和EAN13的中间符号长度都是 5
        }
        else
        {
            ucTmpLen = EAN_LEN;        // EAN8和EAN13的码元信息都是7
        }
        ulTmpRowCh  =  GetEanDat(Dat); //获取对应的码元信息 
    }

//    usTmpCurX = iCurrentFillColumn;//CursorX;                                  //获取坐标信息

    DatLineToPrintBuf(ulTmpRowCh,ucTmpLen);//,usTmpCurX,0);  //把对应码元信息发送到点行中去

    if ( CODE39 == style )                 //发送完一个码元之后，坐标X的值要往后移动 
    {
        //CursorX += (CODE39_LEN+CODE_GAP);  //  因为CODE39与其他条码不同，码元之间有一个 空隙 GAP 隔开
        iCurrentFillColumn += CODE_GAP * tag_OneBar.WideAmp;
    } 
    else
    {
        ;//CursorX += ucTmpLen;                //移动码元所占的长度即可
    }

    if (iCurrentFillColumn >= LINE_DOTS) //如果条码此时长度溢出纸张长度，报警出错
    {
         return ERROR_LEN;
    }
    else
    {
         return SUCSS_BAR1; 
    }
}     

//=========================================================================================================
//Name:        GetCode39Dat
//Description: 获取39条码
//Return:      返回码元信息
//=========================================================================================================
uint32_t GetCode39Dat(uint8_t Dat) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i;

    for(i = 0; i < sizeof(aCode39) / sizeof(aCode39[0]); i++)
    {
         if(aCode39[i][0] == Dat)
         {
              return aCode39[i][1];  //返回码元信息   
         }
    } 

    return ERROR_CHAR; 
}

//=========================================================================================================
//Name:         Code93CharToId
//Description:  输入的CODE93字符转换为对应的ID
//Others:       参照编码规则详解
//=========================================================================================================
uint8_t Code93CharToId(uint8_t Dat)  //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i;

    if(Dat == 32)
    {
        i = 38;
    }
    else
    if(Dat == 36)
    {
        i = 39;
    }
    else
    if(Dat == 37)
    {
        i = 42;
    }
    else
    if(Dat == 43)
    {
        i = 41;
    }
    else
    if(Dat == 45)
    {
        i = 36;
    }
    else
    if(Dat == 46)
    {
        i = 37;
    }
    else
    if(Dat == 47)
    {
        i = 40;
    }
    else
    if((Dat <= 57) && (Dat >= 48))  //10个数字
    {
        i = Dat - 48;
    }
    else
    if((Dat <= 90) && (Dat >= 65))  //26个大小字母
    {
        i = Dat - 55;
    }
    else    //如果输入不合法
    {
        return CODE93_INPUT_ERROR;
    }
    
    return i; 
}

//=========================================================================================================
//Name:        	GetCode93Dat         
//Description: 获取93条码
//Input:       	Dat -输入为ID号
//Return:      CHECKSUM
//=========================================================================================================
uint32_t GetCode93Dat(uint8_t Dat) //完全沒有使用到;AMO;2018.05.25
{
    return aCode93[Dat];
}

//=========================================================================================================
//Name:         CodaBarCharToId         
//Description:  输入的CodaBar字符转换为对应的ID  
//Others:       参照编码规则详解
//=========================================================================================================
uint8_t CodaBarCharToId(uint8_t Dat) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i;

    if(Dat == '$')
    {
        i = 11;
    }
    else
    if(Dat == '+')
    {
        i = 15;
    }
    else
    if(Dat == '-')
    {
        i = 10;
    }
    else
    if(Dat == '.')
    {
        i = 14;
    }
    else
    if(Dat == '/')
    {
        i = 13;
    }
    else
    if((Dat <= '9') && (Dat >= '0'))
    {
        i = Dat - 48;
    }
    else
    if(Dat == ':')
    {
        i = 12;
    }
    else
    if((Dat <= 'D') && (Dat >= 'A'))
    {
        i = Dat - 49;
    }
    else
    {
        return CODABAR_INPUT_ERROR;
    }
    
    return i;
}

//=========================================================================================================
//Name:         GetUpceDat
//Description:  获取Upce条码
//Input:        Dat -
//Output:       void   
//Return:       CHECKSUM
//=========================================================================================================
uint32_t GetUpceDat(uint8_t Dat)  //完全沒有使用到;AMO;2018.05.25
{
    return aUpce[Dat];
}

//=========================================================================================================
//Name:        	GetCode128Dat         
//Description: 获取128条码
//Return:      CHECKSUM
//Others: 	 具体的数字分界点的含义参考CODE128编码规则 
//=========================================================================================================
uint8_t GetCode128Id(uint8_t Dat) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i=0;

    if (Dat < 32)
    {
       i= 64+Dat;
    }  
    else
    if (Dat < 96)
    {
       i= Dat-32;
    }
    else
    if (Dat < 127)
    {
       i = 64+(Dat-96);     
    } 
    else
    if ((Dat >= 200) && (Dat <= 211))
    {
       i = 95 +(Dat-200); 
    }
    else
    {   
       return 0;   
    }
 
    return i;  
}

//=========================================================================================================
//Name:         GetCode128Dat    
//Description:  获取128条码
//Return:       CHECKSUM
//Others:       具体的数字分界点的含义参考CODE128编码规则 
//=========================================================================================================
uint32_t GetCode128Dat(uint8_t Dat) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i;

    if (Dat < 32)
    {
       i= 64+Dat;
    }
    else
    if (Dat < 96)
    {
       i= Dat-32;
    }
    else
    if (Dat < 127)
    {
       i = 64+(Dat-96);
    } 
    else
    if ( (Dat >= 200) && (Dat <= 211))
    {
       i = 95 + (Dat - 200); 
    }
    else
    {
       return 0;   
    }
    return aCode128[i];
}

//=========================================================================================================
//Name:        GetEanDat
//Description: 获取ean13条码
//Return:      ean13的条码
//=========================================================================================================
uint32_t GetEanDat(uint8_t Dat)  //完全沒有使用到;AMO;2018.05.25
{
   return aEan[Dat]; 
}    

//=========================================================================================================
//Name:         RightShift         
//Description:  数组右移K位，左边补零
//=========================================================================================================
void RightShift(uint8_t *Array, uint8_t n, uint8_t k) //完全沒有使用到;AMO;2018.05.25
{
    uint8_t i;

    while(k--)  
    {
        for(i = n - 1; i > 0; i--)  
        {
            Array[i] = Array[i - 1];  
        }
        Array[0] = '0'; //左边补零
    }
}

//=========================================================================================================
//Name:         PrintOneBarCode93
//Description:  打印Code93  条码
//=========================================================================================================
void PrintOneBarCode93(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t i,j; 
    uint16_t  usChkC = 0, usChkK = 0;
    uint32_t ulChkSumId = 0;

    if(((tag_OneBar.ucNum + 4) * CODE93_LEN + CODE93_LASTLEN) * tag_OneBar.WideAmp > LINE_DOTS)	//起始符各1位、校验码2位
    {
        PrintStr("error", 1);               //超过宽度报警
        //PrintStr("设置错误!超出宽度", 1); //超过宽度报警
        return;
    }

    for(i = 0; i < tag_OneBar.ucNum; i++)
    {
        if(Code93CharToId(tag_OneBar.aBarDat[i]) == CODE93_INPUT_ERROR)
        {
            PrintStr("error", 1);
            //PrintStr("设置错误!字元不支持",1);  //不在 字元支持符里
            return;
        }
    }

//  for(i = 0; i < tag_OneBar.ucHigh; i++)  //打印高度在此设置
    {
        /*if(pPrintQueueIn->Dph == VOID_PAGE)
        {
            pPrintQueueIn->Mode     = PM_NORMAL;  //正常打印模式，此处与条码无关系
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp; //高度放大系数，无条码无关
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp; //条码宽度设置
            pPrintQueueIn->PrintRow = 1;                  //申请一行
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;    //总的申请行数
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请打印缓存区
            if(pPrintQueueIn->Dph == VOID_PAGE)
            { 
                return;  //失败返回
            }
        } */

        //CursorX = tag_OneBar.usLeftSpace;         //定义光标X的位置
        BarOut(CODE93_START_END, CODE93);           //起始符*,此时输入的是ID号
        ulChkSumId = 0; //校验和清空

        for(j = 0; j < tag_OneBar.ucNum; j++)       //条码信息,此时输入的是ID号
        {
            BarOut(Code93CharToId(tag_OneBar.aBarDat[j]), CODE93);      //此时输入的是ID号
            ulChkSumId += (tag_OneBar.ucNum - j)*Code93CharToId(tag_OneBar.aBarDat[j]);
        }

        usChkC = ulChkSumId%47; //计算校验C码
        BarOut(usChkC, CODE93); //输出 校验C码
        ulChkSumId = 0;

        for(j = 0; j < tag_OneBar.ucNum; j++)       //条码信息,此时输入的是ID号
        {
            ulChkSumId += (tag_OneBar.ucNum + 1 - j)*Code93CharToId(tag_OneBar.aBarDat[j]);
        }

        ulChkSumId += usChkC;
        usChkK = ulChkSumId%47;  //计算校验K码
        BarOut(usChkK, CODE93);  //输出 校验K码
        BarOut(CODE93_START_END, CODE93);  //结束符*,此时输入的是ID号
        BarOut(CODE93_LASTONEDOT, CODE93); //结束比起始多一个 1 条纹
        //PrintQueueIn();  //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarUPCE
//Description:  打印UPCE  条码
//=========================================================================================================
void PrintOneBarUPCE(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t  i,j,k;
    //uint16_t usCharCusX;
    uint8_t  ucParity;
    uint8_t a,b;

    if(tag_OneBar.ucNum != 6)       //必须输入6个字元
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!字元个数不为6",1);
        return;
    }

    for (i = 0; i < 6; i++)
    {
        /*if(i == 0)
        {
            if(tag_OneBar.aBarDat[i] != '0')  //输入的第一位不为0，报警出错
            {
                PrintStr("设置错误!第一位不为0", 1);
                return;
            }
        }
        else 
        {*/
            if((tag_OneBar.aBarDat[i] < '0') || (tag_OneBar.aBarDat[i] > '9'))
            {
                PrintStr("error", 1);
                //PrintStr("设置错误!字元不支持", 1);        //不在 0~9的码元 ，报警出错
                return;
            }
        //}
    }
    RightShift(tag_OneBar.aBarDat, tag_OneBar.ucNum + 1, 1);//  数组右移1位，左边补零
    if((6*UPCE_LEN + UPCE_START_LEN + UPCE_END_LEN) * tag_OneBar.WideAmp > LINE_DOTS)
    {
            PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1);    //长度出错报警 
        return;
    }
    /**********生成校验码算法 add by yxm***********/
    a = (tag_OneBar.aBarDat[1] + tag_OneBar.aBarDat[3] + tag_OneBar.aBarDat[5] - 0x90);
    b = (tag_OneBar.aBarDat[2] + tag_OneBar.aBarDat[4] + tag_OneBar.aBarDat[6] - 0x90) * 3;
    if((a + b) % 10)
    {
        tag_OneBar.aBarDat[7] = 10 - (a + b) % 10;
    }
    else
    {
        tag_OneBar.aBarDat[7] = 0;
    }
    //SerialSendByte(tag_OneBar.aBarDat[7]);
    //1、奇数位相加乘3后
    //2、偶数位相加
    //1+2后，10 - (1 + 2) % 10的结果即为校验码
    /***************************************************/
    /*if(pPrintQueueIn->Dph == VOID_PAGE)
    {
        pPrintQueueIn->Mode     = PM_NORMAL;               //正常打印
        pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;      //此处设置对条码设置无意义
        pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;      //条码宽度在此设置
        pPrintQueueIn->PrintRow = 1;                       //申请一个点行
        pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;  //总的申请行数
        pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow);  //申请需要的行数
        
        if(pPrintQueueIn->Dph == VOID_PAGE)
        {
            return;     //申请失败返回
        }
    } */

    //CursorX = tag_OneBar.usLeftSpace;                     //定义X坐标的初始值
    BarOut(UPCE_START, UPCE);                               //开始符101
    ucParity = aUpceParity[tag_OneBar.aBarDat[7]];          //最后一位决定奇偶

    for(j = 1; j < 7; j++)                                  //6个具体条码信息
    {
        k = (ucParity >> (6 - j))&0x01;
        BarOut((10*k + (tag_OneBar.aBarDat[j] - '0')), UPCE);
    }

    BarOut(UPCE_END, UPCE);                                 //结束符010101
    //PrintQueueIn();                                       //入队，打印
}

//=========================================================================================================
//Name:         PrintOneBarITF
//Description:  打印ITF条码
//=========================================================================================================
void PrintOneBarITF(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t i, j, k; 
    // uint16_t usCharCusX;

    for(i = 0; i < tag_OneBar.ucNum; i++) 
    {
        if((tag_OneBar.aBarDat[i] < '0') || (tag_OneBar.aBarDat[i] > '9'))
        {
            PrintStr("error", 1);
            //PrintStr("设置错误!字元不支持", 1);  //ITF码元只支持 0~9 
            return;
        }
    }

    if(tag_OneBar.ucNum%2 == 1)     //如果是奇数第一位补零，ITF必须由偶数位组成
    {
        tag_OneBar.ucNum += 1;      //数量加一变为偶数
        RightShift(tag_OneBar.aBarDat, tag_OneBar.ucNum, 1);    //左边补0，其余位右移一位
    }

    if((tag_OneBar.ucNum * (2 * 3 + 2) + 9) * tag_OneBar.WideAmp > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1); //宽度溢出纸张报警
        return;
    }

    //for(i = 0; i < tag_OneBar.ucHigh; i++)     //条码打印高度在此设置
    {
        /*if(pPrintQueueIn->Dph == VOID_PAGE)
        {
            pPrintQueueIn->Mode     = PM_NORMAL;            //正常打印
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;   //此处设置对条码设置无意义
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;   //条码宽度在此设置
            pPrintQueueIn->PrintRow = 1;                    //申请一个点行
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;  //总的申请行数

            if(pPrintQueueIn->Dph == VOID_PAGE)
            {
                return;   //申请失败返回
            }
        } */
    
        //CursorX = tag_OneBar.usLeftSpace;    //定义X坐标的初始值  
    
        for(j = 0; j < 4; j++)	//ITF起始符  1010
        {
            if((aITF[ITF_START] >> (3 - j)) & 0x01)
            {
                BarOut(ITF_BLACK_NARROW, ITF); 
            }
            else
            {
                //CursorX += 1; 
                iCurrentFillColumn += 1 * tag_OneBar.WideAmp;
            }
        }

        for(j = 0; j < tag_OneBar.ucNum; j += 2)    //打印规定数量字符条码信息
        {
            //以2个字符为一组输入，第一个以条输入，第二个以空输入  
            for(k = 0; k < 5; k++)
            {
                //第一个字符输入的是 窄条或者宽条 
                if((aITF[tag_OneBar.aBarDat[j] - '0'] >> (4 - k))&0x01)
                {
                    BarOut(ITF_BLACK_WITDH, ITF);  
                }
                else
                {
                    BarOut(ITF_BLACK_NARROW, ITF); 
                }

                //第一个字符输入的是 窄空或者宽空 
                if((aITF[tag_OneBar.aBarDat[j + 1] - '0'] >> (4 - k))&0x01)
                {
                    //CursorX += ITF_WIDTH_LEN;
                    iCurrentFillColumn += ITF_WIDTH_LEN * tag_OneBar.WideAmp;
                }
                else
                {
                    //CursorX += 1;
                    iCurrentFillColumn += 1 * tag_OneBar.WideAmp;
                }
                
            }
            
        }

        for(j = 0; j < 5; j++)	//ITF结束符  1101 
        {
            if((aITF[ITF_END] >> (4 - j)) & 0x01)
            {
                BarOut(ITF_BLACK_NARROW, ITF);
            }
            else
            {  
                //CursorX += 1;
                iCurrentFillColumn += 1 * tag_OneBar.WideAmp;
            }
        }
        //PrintQueueIn();     //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarCodaBar
//Description:  打印CodaBar条码
//=========================================================================================================
void PrintOneBarCodaBar(void)  //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t  i,j, k; 
    // uint16_t usCharCusX; 
    // uint32_t ulChkSumId = 0;

    for(i = 0; i < tag_OneBar.ucNum; i++) 
    {
        if((i == 0) || (i == tag_OneBar.ucNum - 1))
        {
            if((tag_OneBar.aBarDat[i] < 'A') || (tag_OneBar.aBarDat[i] > 'D'))
            {
                PrintStr("error", 1);
                //PrintStr("设置错误!起始符或终止符不在A~D", 1); //起始符号不再 A~D判断为错误
                return;
            }
        }
        else
        {
            if(CodaBarCharToId(tag_OneBar.aBarDat[i]) == CODABAR_INPUT_ERROR)
            {
                PrintStr("error", 1);
                //PrintStr("设置错误!字元不支持",1);   //字元不支持报警
                return;
            }
        }
    }
    
    if(tag_OneBar.ucNum * 7 * tag_OneBar.WideAmp>LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度", 1); //超过宽度报警
        return;
    }
    //for(i = 0; i < tag_OneBar.ucHigh; i++)
    {
        /*if(pPrintQueueIn->Dph == VOID_PAGE)
        {
            pPrintQueueIn->Mode     = PM_NORMAL; //正常打印
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;       //此处设置对条码设置无意义
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;       //条码宽度在此设置
            pPrintQueueIn->PrintRow = 1;                        //申请一个点行
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;  //总的申请行数
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请需要的行数
            
            if(pPrintQueueIn->Dph == VOID_PAGE)
            {
                return; //申请失败返回
            }
        }*/

        //CursorX = tag_OneBar.usLeftSpace;         //定义X坐标的初始值  

        for(j = 0; j < tag_OneBar.ucNum; j++)       //打印所有的码元
        {
        
            for(k = 0; k < 7; k++)  //每个条码有7位
            {
            
                if(k%2)	//偶数位上用 白线条 
                {
                    if((aCodaBar[CodaBarCharToId(tag_OneBar.aBarDat[j])] >> (6 - k))&0x01)
                    {
                        //CursorX += 2;
                        iCurrentFillColumn += 2 * tag_OneBar.WideAmp;
                    }
                    else
                    {
                        //CursorX += 1;
                        iCurrentFillColumn += 1 * tag_OneBar.WideAmp;
                    }
                }
                else    //奇数位上用 黑线条
                {
                    if((aCodaBar[CodaBarCharToId(tag_OneBar.aBarDat[j])] >> (6 - k))&0x01)
                    {
                        BarOut(CODABAR_BLACK_DOUBLE, CODABAR);
                    }
                    else
                    {
                        BarOut(CODABAR_BLACK_SINGLE, CODABAR);
                    } 
                }
            }
            //CursorX += 1; //字符之间分隔符
            iCurrentFillColumn += 1 * tag_OneBar.WideAmp;
        }
    
        //PrintQueueIn();     //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarUPCA
//Description:  打印UPCA条码
//Others:       EAN13与UPCA区别在于:
//              EAN13必须输入12个字元
//              UCPA必须输入11个字元
//=========================================================================================================
void PrintOneBarUPCA(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t  i, j, k;
    // uint16_t usCharCusX;
    uint8_t  ucChkSum = 0;

    if (tag_OneBar.ucNum != 11)    //UPCA必须打11个字元，否则错误
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!字元个数不为11",1);
        return;
    }

    for (i = 0; i < 11; i++)
    {
        if ((tag_OneBar.aBarDat[i] < '0') || (tag_OneBar.aBarDat[i] > '9'))  //只能打0~9的数字
        {
            //PrintStr("设置错误!字元不在0~9",1);
            return;
        }
    }

    if ((2 * EAN_SEG_LEN + EAN_MID_LEN + 12 * EAN_LEN) * tag_OneBar.WideAmp > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1);
        return;
    }

    for (k = 0; k < 11; k++) //计算校验码
    {
        if (k%2) 
        {
            ucChkSum +=  1 * (tag_OneBar.aBarDat[k] - '0');
        }
        else
        {
            ucChkSum +=  3 * (tag_OneBar.aBarDat[k] - '0');
        }
    } 
   
    ucChkSum = ucChkSum % 10; 
    ucChkSum = (10 - ucChkSum) == 10 ? 0:(10-ucChkSum);

    tag_OneBar.aBarDat[11] = ucChkSum + '0';    //校验码放入数组

    // for ( i=0; i<tag_OneBar.ucHigh; i++ )
    {
        /*if (VOID_PAGE == pPrintQueueIn->Dph)
        {
            pPrintQueueIn->Mode     = PM_NORMAL;
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;
            pPrintQueueIn->PrintRow = 1;
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow);
            
            if (VOID_PAGE == pPrintQueueIn->Dph)
            {
                return;
            }
        }*/

        //CursorX  = tag_OneBar.usLeftSpace;

        BarOut(EAN_START, EAN13);   //开始符

        for (j = 0; j < 6; j++)     //前6个数字
        {
            BarOut((tag_OneBar.aBarDat[j] - '0'), EAN13);  
        }

        BarOut(EAN_MID,EAN13);  //中间符

        for (j = 6; j < 11; j++)    //后6个数字
        {
            BarOut(20 + tag_OneBar.aBarDat[j] - '0', EAN13); 
        }

        BarOut(20 + ucChkSum, EAN13);   //校验符
        BarOut(EAN_END, EAN13);         //结束符

        //PrintQueueIn();     //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarCode39
//Description:  打印39条码 
//=========================================================================================================
void PrintOneBarCode39(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t i,j ;
    // uint16_t usCharCusX;

    //超出纸张的范围告警
    if (((tag_OneBar.ucNum + 2) * CODE39_LEN) * tag_OneBar.WideAmp > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度", 1);
        return;
    }

    //不在码元支持的范围内报警
    for (i = 0; i<tag_OneBar.ucNum; i++)
    {
        if (ERROR_CHAR == GetCode39Dat(tag_OneBar.aBarDat[i]))
        {
            PrintStr("error", 1);
            //PrintStr("设置错误!字元不支持", 1);
            return;
        }
    }

    if((2 + tag_OneBar.ucNum) * tag_OneBar.WideAmp * 12 > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度", 1); //超过宽度报警
        return;
    }

    //for (i=0;i<tag_OneBar.ucHigh;i++)   //条码要打印多高在此设置 
    {
        /*if ( VOID_PAGE == pPrintQueueIn->Dph )
        {
            pPrintQueueIn->Mode     = PM_NORMAL;                //正常打印
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;       //此处设置对条码设置无意义
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;       //条码宽度在此设置
            pPrintQueueIn->PrintRow = 1;                        //申请一个点行
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;  //总的申请行数
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请需要的行数

            if (VOID_PAGE == pPrintQueueIn->Dph)  
            {
                return;
            }
        }  */

        //CursorX = tag_OneBar.usLeftSpace;         //定义X坐标的初始值
        BarOut('*',CODE39);                         //CODE39码以*开始

        for (j = 0; j < tag_OneBar.ucNum; j++)
        {   
            BarOut(tag_OneBar.aBarDat[j],CODE39);   //真正要打印的 字元信息  
        }

        BarOut('*',CODE39);                         //CODE39码以*结束
        //PrintQueueIn();                           //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarCode128
//Description:  打印128条码
//=========================================================================================================
void PrintOneBarCode128(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t j;
    // uint16_t usCharCusX; 
    int ulChkSumId =0;
    uint8_t  ucChkDat; 

    if (((tag_OneBar.ucNum + 2) * CODE128_LEN + CODE128_END_LEN) * tag_OneBar.WideAmp > LINE_DOTS )
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1);  //超出纸张的范围告警
        return;     
    }

    //for (i=0; i<tag_OneBar.ucHigh; i++)  //条码要打印多高在通过tag_OneBar.ucHigh来设置
    {
        /*if ( VOID_PAGE == pPrintQueueIn->Dph )
        {
            pPrintQueueIn->Mode     = PM_NORMAL;            //正常打印模式，与条码部分无关系
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;   //高度系数，与条码部分无关系
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;   //宽度系数，一条暗条纹或者亮条纹的宽度在此设置
            pPrintQueueIn->PrintRow = 1;                    //申请一行即可
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow; //总的申请行
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请打印缓存区的行数
            
            if (VOID_PAGE == pPrintQueueIn->Dph)
            {
                return;
            }
        }*/

        //CursorX = tag_OneBar.usLeftSpace;    //重新定义X坐标值 
        ulChkSumId = 0; //校验码清空

        if (tag_OneBar.aBarDat[0] < 32)                 //32在ASSII表之前为特殊控制字符，按照CODE128的标准选择A模式才能打印，不过在打印机行业中一般
                                                        //要打印实实在在的字符，所以控制字符很少用，一般情况用B模式即可
        {
            BarOut(CODE128_START_A,CODE128);             //A模式起始符
            ulChkSumId += GetCode128Id(CODE128_START_A); //把字符累加
        }
        else
        {
            BarOut(CODE128_START_B,CODE128);             //B模式起始符
            ulChkSumId += GetCode128Id(CODE128_START_B); //把字符累加
        }

        for (j=0;j<tag_OneBar.ucNum;j++)                //输出真正要打印的码元信息
        {
            BarOut(tag_OneBar.aBarDat[j],CODE128);
            ulChkSumId += (j+1)*GetCode128Id(tag_OneBar.aBarDat[j]); //检验码的累加
        }

        ucChkDat = (ulChkSumId%103)<95 ? ((ulChkSumId%103)+32) : ((ulChkSumId%103)+105); //计算出检验码

        BarOut(ucChkDat,CODE128);   //输出CODE128验证码
          
        BarOut(CODE128_START_STOP,CODE128);  //输出CODE128结束符

        //PrintQueueIn();                 //入队，打印
    }
}

//=========================================================================================================
//Name:         PrintOneBarEan8
//Description:  打印EAN8条码
//=========================================================================================================
void PrintOneBarEan8(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t  i,j,k;
    //uint16_t usCharCusX;
    uint8_t  ucChkSum = 0;

    if (tag_OneBar.ucNum != 7)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!字元个数不为7",1);  //EAN8必须为7个信息码元，校验码由软件自己计算
        return;  
    } 
    
    for (i = 0; i < 7; i++)
    {
        if ((tag_OneBar.aBarDat[i] < '0') || (tag_OneBar.aBarDat[i] > '9'))
        {
            PrintStr("error", 1);
            //PrintStr("设置错误!字元不在0~9",1);   //码元只能输入0~9 
            return;   
        }
    }

    if ((2 * EAN_SEG_LEN + EAN_MID_LEN + 8 * EAN_LEN) * tag_OneBar.WideAmp > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1);    //超出纸张告警   
        return;
    }

    for (k = 0; k < 7; k++) //计算校验码
    {
        if (k % 2) 
        {
            ucChkSum += 1 * (tag_OneBar.aBarDat[k] - '0');  //偶数乘以1，而EAN13是偶数乘以3
        }
        else
        {
            ucChkSum += 3 * (tag_OneBar.aBarDat[k] - '0');  //奇数乘以3，而EAN13是奇数乘以1
        }
    } 

    ucChkSum = ucChkSum % 10; 
    ucChkSum = (10 - ucChkSum) == 10 ? 0:(10 - ucChkSum);   //计算出最终的校验码

    tag_OneBar.aBarDat[7] = ucChkSum + '0';	//校验码放入数组

    //for (i = 0; i < tag_OneBar.ucHigh; i++) 
    {
        /*if (VOID_PAGE == pPrintQueueIn->Dph)
        {  
            pPrintQueueIn->Mode     = PM_NORMAL;          //正常打印模式，与条码部分无关系
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp; //高度系数，与条码部分无关系
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp; //宽度系数，一条暗条纹或者亮条纹的宽度在此设置
            pPrintQueueIn->PrintRow = 1;                    //申请一行即可
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;  //总的申请行    
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请打印缓存区的行数
            
            if (VOID_PAGE == pPrintQueueIn->Dph)
            {
                return;  //申请不到返回
            }
        
        } */

        //CursorX  = tag_OneBar.usLeftSpace;

        BarOut(EAN_START,EAN8);         //开始符

        for ( j = 0; j < 4; j++ )       //前4个数字
        {
            BarOut((tag_OneBar.aBarDat[j] - '0'), EAN8);
        }

        BarOut(EAN_MID,EAN8);           //中间符 

        for ( j = 4; j < 7; j++ )       //后面3个数字
        {
            BarOut(20 + tag_OneBar.aBarDat[j] - '0', EAN8); 
        }

        BarOut(20+ucChkSum,EAN8);       //校验符
        BarOut(EAN_END,EAN8);           //结束符
        //PrintQueueIn();               //入队，打印
    }
} 


//=========================================================================================================
//Name:         PrintOneBarEan13
//Description:  打印EAN13条码
//=========================================================================================================
void PrintOneBarEan13(void) //BarCode.C有使用到;AMO;2018.05.25
{
    uint8_t  i, j, k;
//  uint16_t usCharCusX;
    uint8_t  ucParity;
    uint8_t  ucChkSum = 0;

    if (tag_OneBar.ucNum != 12)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!字元个数不为12",1);  //  EAN13必须输入12个码元，验证码由程序自动生成   
        return;
    }

    for (i=0; i<12; i++)
    {
        if ((tag_OneBar.aBarDat[i] < '0') || (tag_OneBar.aBarDat[i] > '9'))
        {
            PrintStr("error", 1);
            //PrintStr("设置错误!字元不在0~9",1);   //码元只能输入0~9
            return;
        }
    } 

    if ((2*EAN_SEG_LEN + EAN_MID_LEN + 12*EAN_LEN)*tag_OneBar.WideAmp > LINE_DOTS)
    {
        PrintStr("error", 1);
        //PrintStr("设置错误!超出宽度",1);     //超出纸张告警
        return;
    }

    for (k = 0; k < 12; k++) //计算EAN13的校验码
    {
        if (k%2)
        {
            ucChkSum += 3 * (tag_OneBar.aBarDat[k] - '0');  //偶数乘以3，而EAN8是偶数乘以1
        }
        else
        {
            ucChkSum += 1 * (tag_OneBar.aBarDat[k] - '0');  //奇数乘以1 ，而EAN8是奇数乘以3
        }
    } 

    ucChkSum = ucChkSum % 10; 
    ucChkSum = (10 - ucChkSum) == 10 ? 0:(10 - ucChkSum);      //最终的校验码

    tag_OneBar.aBarDat[12] = ucChkSum + '0';    //校验码放入数组的最后一位	

//  for (i = 0; i < tag_OneBar.ucHigh; i++)
    {
        /*if (VOID_PAGE == pPrintQueueIn->Dph)
        {
            pPrintQueueIn->Mode     = PM_NORMAL;           //正常打印模式，与条码部分无关系
            pPrintQueueIn->HihgAmp  = tag_OneBar.HighAmp;  //高度系数，与条码部分无关系
            pPrintQueueIn->WideAmp  = tag_OneBar.WideAmp;  //宽度系数，一条暗条纹或者亮条纹的宽度在此设置
            pPrintQueueIn->PrintRow = 1;                   //申请一行即可
            pPrintQueueIn->AllRow   = pPrintQueueIn->PrintRow;
            pPrintQueueIn->Dph      = MallocPrintBuf(pPrintQueueIn->AllRow); //申请打印缓存区的行数

            if (VOID_PAGE == pPrintQueueIn->Dph)
            {
                return;    //申请不到缓存区返回
            }
        }*/

//      CursorX  = tag_OneBar.usLeftSpace;    //重新定义X坐标值 

        ucParity = aEanParity[tag_OneBar.aBarDat[0] - '0'];

        BarOut(EAN_START, EAN13);  //开始符

        for (j = 1; j < 7; j++)           //前6个数字
        {
            k = (ucParity>>(6 - j)) & 0x01; 
            BarOut((10*k) + (tag_OneBar.aBarDat[j] - '0'), EAN13);
        }

        BarOut(EAN_MID,EAN13);  //中间符

        for (j=7; j<12; j++)    //后5个数字
        {
            BarOut(20 + tag_OneBar.aBarDat[j] - '0', EAN13);  //这里加个20是为了在 aEan数组中偏移20个字节
        }

        BarOut(20 + ucChkSum, EAN13);       //校验符 ，这里加个20是为了在 aEan数组中偏移20个字节
        BarOut(EAN_END, EAN13);             //结束符

        //PrintQueueIn();                   //入队，打印
    }
}

//=========================================================================================================
//Function:     PrintOneBar
//Description:  打印一维条码
//input:        style - 打印方式
//=========================================================================================================
/*void PrintOneBar(uint8_t style)
{
    switch (style) 
    {
        case UPCA:
            PrintOneBarUPCA();
            break;

        case UPCE:
            PrintOneBarUPCE();
            break;

        case EAN13:
            PrintOneBarEan13();
            break;

        case EAN8:
            PrintOneBarEan8();
            break;

        case CODE39:
            PrintOneBarCode39();
            break;

        case ITF:
            PrintOneBarITF();
            break;

        case CODABAR:
            PrintOneBarCodaBar();
            break;

        case CODE93:
            PrintOneBarCode93();
            break;

        case CODE128:
            PrintOneBarCode128();
            break;
    }
}*/

