/**
 * @file    BarCode.h
 * @author  megawin Application Team
 * @version V0.0.0
 * @date    18-February-2021
 * @brief   This file contains all the functions prototypes for the BarCode firmware
 *          main code.
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BARCODE_H
#define __BARCODE_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "UserMisc.h"
#include "PrtBuf.h"
#include "BarCode_app.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode.h］
typedef struct  
{
    //uint8_t   ucWide;         //条码的宽
    //uint8_t   ucHigh;         //条码的高
    uint8_t   WideAmp;        //宽的放大系数
    //uint8_t   HighAmp;        //高的放大系数 
    uint8_t   ucNum;          //条码的碼元个数
    uint8_t   aBarDat[256];    //碼元缓存区,可以根据实际情况 变为更大或者更小        
    //uint16_t  usLeftSpace;    //左边距           
}TagOneBar;  


extern TagOneBar  tag_OneBar;  

extern void PrintBarCode_UPCA(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_UPCE(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_EAN13(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_JAN8(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_CODE39(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_ITF(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_CODEBAR(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_CODE93(uint8_t *barcodeBuf, uint8_t length);
extern void PrintBarCode_CODE128(uint8_t *barcodeBuf, uint8_t length);
//extern void PrintBarCode_EAN8(uint8_t *barcodeBuf, uint8_t length);


#ifdef __cplusplus
}
#endif

#endif /* __BARCODE_H */

