/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "RG6281F.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/





//=====================================================================================================================
// ●PA0腳位(PIN.45)，使用熱敏打印模組進紙偵測PRINT_Paper_ADC腳，並設定腳位為AIO(Analog input)，使用在ADC讀取
// ●PA1腳位(PIN.46)，使用熱敏打印模組進紙偵測PRINT_Thermal_ADC腳，並設定腳位為AIO(Analog input)，使用在ADC讀取
#define PRINT_Paper_ADC     //PA0   //Check-Ok;AMO;2018.05.25
#define PRINT_Thermal_ADC   //PA1   //Check-Ok;AMO;2018.05.25

// ●PD2腳位(PIN.35)，使用熱敏打印模組資料控制PRINT_SPI_MOSI腳，並設定腳位為PPO(Output Push-pull)
// ●PD1腳位(PIN.34)，使用熱敏打印模組資料控制PRINT_SPI_CLK腳，並設定腳位為PPO(Output Push-pull)
#define TPH_DI_high()       //PD2
#define TPH_DI_low()        //PD2
#define TPH_CLK_high();     //PD1
#define TPH_CLK_low();      //PD1


// ●PD3腳位(PIN.36)，使用熱敏打印模組資料控制PRINT_LAT腳，並設定腳位為PPO(Output Push-pull)
#define LAT_on()            //PD3 = 1    //Check-Ok;AMO;2018.05.25
#define LAT_off()           //PD3 = 0    //Check-Ok;AMO;2018.05.25

//[Thermal Print Head,TPH]:
// ●PD7腳位(PIN.37)，使用熱敏打印模組加熱控制STB456腳，並設定腳位為PPO(Output Push-pull)
// ●PD8腳位(PIN.38)，使用熱敏打印模組加熱控制STB123腳，並設定腳位為PPO(Output Push-pull)
#define PrtStb456_on()      //PD7 = 1
#define PrtStb456_off()     //PD7 = 0
#define PrtStb123_on()      //PD8 = 1
#define PrtStb123_off()     //PD8 = 0

//[MOTOR]:
// ●PA8腳位(PIN.01)，使用熱敏打印模組馬達控制Motor A+腳，並設定腳位為PPO(Output Push-pull)
// ●PA9腳位(PIN.02)，使用熱敏打印模組馬達控制Motor A-腳，並設定腳位為PPO(Output Push-pull)
// ●PA10腳位(PIN.03)，使用熱敏打印模組馬達控制Motor B+腳，並設定腳位為PPO(Output Push-pull)
// ●PA11腳位(PIN.04)，使用熱敏打印模組馬達控制Motor B-腳，並設定腳位為PPO(Output Push-pull)
#define Motor1_on()         //PA8 = 1    //Check-Ok;AMO;2018.05.25
#define Motor1_off()        //PA8 = 0    //Check-Ok;AMO;2018.05.25
#define Motor2_on()         //PA9 = 1    //Check-Ok;AMO;2018.05.25
#define Motor2_off()        //PA9 = 0    //Check-Ok;AMO;2018.05.25
#define Motor3_on()         //PA10 = 1    //Check-Ok;AMO;2018.05.25
#define Motor3_off()        //PA10 = 0    //Check-Ok;AMO;2018.05.25
#define Motor4_on()         //PA11 = 1   //Check-Ok;AMO;2018.05.25
#define Motor4_off()        //PA11 = 0   //Check-Ok;AMO;2018.05.25


/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

static SPI_InitTypeDef SPI_InitStructure;

void RG6281F_Initial(void)
{
  // ADC  Tempture Sensor, Paper Detect
    /* PA0 Thermal Sensor,  PA1 Paper Detect */
    GPIO_Init(GPIOA, GPIO_Pin_0, GPIO_MODE_ANA | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOA, GPIO_Pin_1, GPIO_MODE_ANA | GPIO_OTYPE_OD | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

  // TM Initial for Heater / Moto
    /* Heater, Moto */
    // Heater
    // PB10 STB 0/1/2  PB11 STB 3/4/5
    // PB10 STB 0/1    PB11 STB 4/5         PB2 STB 2/3 
    // PB10 STB 0, PC6 STB 1, PB2 STB 2, PC7 STB 3, PB11 STB 4, PC8 STB 5
    GPIO_Init(GPIOB, GPIO_Pin_10, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_11, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOB, GPIO_Pin_2, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_7, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    // GPIO_Init(GPIOC, GPIO_Pin_8, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);

    // Moto PB6 A, PB7 nA, PB8 B, PB9 nB
    GPIO_Init(GPIOB, GPIO_Pin_6, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_7, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_8, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);
    GPIO_Init(GPIOB, GPIO_Pin_9, GPIO_MODE_OUT | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF0);


    /* SPIM2 to Thermal Print Head */ 
    // PB12 NSS  PB13 CLK  PB14 MOSI  PB15 MISO
    GPIO_Init(GPIOB, GPIO_Pin_12, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_13, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_14, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_15, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

    /* SPI configuration */
    SPI_DeInit(SPIM2);
    SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    SPI_InitStructure.SPI_BaudRatePrescaler = 96;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    SPI_Init(SPIM2, &SPI_InitStructure);
    SPI_ITConfig(SPIM2, 0xFF, DISABLE);
    SPI_TxFIFOThresholdConfig(SPIM2, 2);
    SPI_RxFIFOThresholdConfig(SPIM2, 1);
    SPI_NSSConfig(SPIM2, SPI_NSS_0, ENABLE);


    /* SPIM2-2 to Ext Connect*/
    // PC0 NSS  PC1 CLK  PC2 MOSI  PC3 MISO
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    // GPIO_Init(GPIOC, GPIO_Pin_0, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

    /* SPI configuration */
    // SPI_DeInit(SPIM2);
    // SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    // SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    // SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    // SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    // SPI_InitStructure.SPI_BaudRatePrescaler = 96;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    // SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    // SPI_Init(SPIM2, &SPI_InitStructure);
    // SPI_ITConfig(SPIM2, 0xFF, DISABLE);
    // SPI_TxFIFOThresholdConfig(SPIM2, 2);
    // SPI_RxFIFOThresholdConfig(SPIM2, 1);
    // SPI_NSSConfig(SPIM2, SPI_NSS_0, ENABLE);

}









//=========================================================================================================
//Thermal_PRINT??1BYTE???
//=========================================================================================================
void THMPRINT_Send_1Byte(uint8_t Byte_data)
{
    uint8_t i;
    for(i = 0; i < 8; i ++)
    {
        if(Byte_data & 0x80)
        {
            TPH_DI_high();
        }
        else
        {
            TPH_DI_high();
        }
        TPH_CLK_high();
        __NOP();
        TPH_CLK_low();
        __NOP();
        Byte_data = Byte_data << 1;
    }
}

//=========================================================================================================
//* Function name:     SendnBytes_To_Head
//* Descriptions :     向打印头发送一点行的数据
//=========================================================================================================
void SendnBytes_To_Head(uint8_t *pData, uint8_t nByte)
{
    uint8_t i;

    for(i = 0; i < nByte; i++)
    {
        THMPRINT_Send_1Byte(*pData);
        pData++;
    }
}


//=========================================================================================================
//* Function name:     LFMotorPhaseSet
//* Descriptions :     电机相位控制函数
//=========================================================================================================
void LFMotorPhaseSet(uint8_t Phase) //Check-Ok;AMO;2018.05.25
{
//          B   A    B    A
//   step1  1   1    0    0
//   step2  0   1    1    0
//   step3  0   0    1    1
//   step4  1   0    0    1

    switch (Phase)
    {
        case 1:// 4
            Motor1_off();
            Motor2_on();
            Motor3_off();
            Motor4_on();
            break; 
        case 2:// 3
            Motor1_off();
            Motor2_on();
            Motor3_on();
            Motor4_off();
            break; 
        case 3:// 2
            Motor1_on();
            Motor2_off();
            Motor3_on();
            Motor4_off();
            break;
        case 4:// 1
            Motor1_on();
            Motor2_off();
            Motor3_off();
            Motor4_on();
            break;
        case 0://Close
            default:
            Motor1_off();
            Motor2_off();
            Motor3_off();
            Motor4_off();
            break;
    }
}

//=========================================================================================================
//* Function name:    PrtStbStatus    
//* Descriptions :    STB1--STB6 使能/失能函数
//=========================================================================================================
void PrtStbAllStatus(uint8_t Status)
{
    if(Status == 1)
    {
      PrtStb123_on();//Stb123 on
      PrtStb456_on();//Stb456 on
    }
    else
    {
      PrtStb123_off();//Stb123 off
      PrtStb456_off();//Stb456 off
    }
}


//=========================================================================================================
//* Function name:   ADC_Configuration    
//* Descriptions :   AD配置
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void ADC_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    ADC_InitTypeDef ADC_InitStructure;

    ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
    ADC_InitStructure.ADC_ScanConvMode = ENABLE;
    ADC_InitStructure.ADC_ContinuousConvMode = DISABLE; //不连续转换
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
    ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
    ADC_InitStructure.ADC_NbrOfChannel = 2;
    ADC_Init(ADC1, &ADC_InitStructure);

    ADC_RegularChannelConfig(ADC1, ADC_Channel_8, 1, ADC_SampleTime_55Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_9, 2, ADC_SampleTime_55Cycles5);
    ADC_Cmd(ADC1, ENABLE);
    ADC_DMACmd(ADC1, ENABLE);
    ADC_ResetCalibration(ADC1);
    while(ADC_GetResetCalibrationStatus(ADC1));
    ADC_StartCalibration(ADC1);
    while(ADC_GetCalibrationStatus(ADC1));

    ADC_SoftwareStartConvCmd(ADC1, ENABLE);
}
*/

//=========================================================================================================
//* Function name:   DMA_Configuration    
//* Descriptions :   DMA配置   用于传送AD值
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void DMA_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    DMA_InitTypeDef  DMA_InitStructure;

    DMA_DeInit(DMA1_Channel1);
    DMA_InitStructure.DMA_PeripheralBaseAddr = ADC1_DR_Address;
    DMA_InitStructure.DMA_MemoryBaseAddr = (uint32_t)&AD_Value;
    DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
    DMA_InitStructure.DMA_BufferSize = 2;
    DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
    DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
    DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
    DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
    DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
    DMA_InitStructure.DMA_Priority = DMA_Priority_High;
    DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
    DMA_Init(DMA1_Channel1, &DMA_InitStructure);

    DMA_Cmd(DMA1_Channel1, ENABLE);
}
*/


