/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "Flash25C.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*///[FLASH]:
//PC25VF080B 8Mbit SPI Serial Flash op code
#define FLASH_WriteStatusReg    0x01
#define FLASH_ByteProgram       0x02
#define FLASH_ReadData          0x03
#define FLASH_WriteDisable      0x04
#define FLASH_ReadStatusReg     0x05
#define FLASH_WriteEnable       0x06
#define FLASH_FastReadData      0x0B
#define FLASH_4KSectorErase     0x20
#define FLASH_EnWriteSR         0x50
#define FLASH_AAIWordProgram    0xAD
#define FLASH_ChipErase         0xC7
#define FLASH_DeviceID          0xAB

/* Private macro -------------------------------------------------------------*/
// ●PB0腳位(PIN.9)，使用外部字庫讀取SPI通訊FLASH_SPI_CS腳，並設定腳位為PPO(Output Push-pull)
// ●PB1腳位(PIN.10)，使用外部字庫讀取SPI通訊FLASH_SPI_MISO腳，並設定腳位為ODO(Output Open-Drive)
// ●PB2腳位(PIN.11)，使用外部字庫讀取SPI通訊FLASH_SPI_CLK腳，並設定腳位為PPO(Output Push-pull)
// ●PB3腳位(PIN.12)，使用外部字庫讀取SPI通訊FLASH_SPI_MOSI腳，並設定腳位為PPO(Output Push-pull)
#define FLASH_SPI_CS_high()     //PB0      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_CS_low()      //PB0      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_MISO_high()   //PB1      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_MISO_low()    //PB1      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_SCK_high()    //PB2      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_SCK_low()     //PB2      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_MOSI_high()   //PB3      //Check-Ok;AMO;2018.05.25
#define FLASH_SPI_MOSI_low()    //PB3      //Check-Ok;AMO;2018.05.25

/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
//PCT25VF080B
uint8_t SPI_Read_StatusReg(void);
uint8_t SPI_Read_ID1(void);
uint8_t SPI_Read_Byte(uint32_t Dst_Addr);
uint8_t SPI_FastRead_Byte(uint32_t Dst_Addr);
//uint8_t SPI_Get_Byte(void);;AMO註解;AMO;2018.05.25

void SPI_EnWrite_StatusReg(void);
void SPI_Write_StatusReg(uint8_t byte);
void SPI_Write_Enable(void);
void SPI_Write_Disable(void);
void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
void SPI_FastRead_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte);
void SPI_Write_2Bytes(uint32_t Dst_Addr, uint8_t Data1, uint8_t Data2);
void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes);
//void SPI_Erase_Chip(void);//沒用到;AMO註解;AMO;2018.05.25
void SPI_Erase_Sector(uint32_t Dst_Addr);
void SPI_Wait_Busy(void);
//void SPI_Send_Byte(uint8_t out);//;AMO註解;AMO;2018.05.25


//=====================================================================================================================
//=====================================================================================================================
//=====================================================================================================================
//=====================================================================================================================
//=====================================================================================================================
static SPI_InitTypeDef SPI_InitStructure;

void Flash25C_Initial(void)
{
  // SPI Initial
  // S.W SPI
    /* QSPI */
    // PA4 NSS  PA5 CLK  PA6 MOSI IO0  PA7 MISO IO1  PB0 IO2  PB1 IO3
    GPIO_Init(GPIOA, GPIO_Pin_4, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOA, GPIO_Pin_5, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOA, GPIO_Pin_6, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOA, GPIO_Pin_7, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_2, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);
    GPIO_Init(GPIOB, GPIO_Pin_3, GPIO_MODE_AF | GPIO_OTYPE_PP | GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF5);

    /* QSPI configuration */
    SPI_DeInit(QSPI);
    SPI_InitStructure.SPI_TransferMode = SPI_TransferMode_TxAndRx;
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
    SPI_InitStructure.SPI_BaudRatePrescaler = 40;   /* In order to avoid TX FIFO underflow or RX FIFO overflow, SPI_BaudRatePrescaler needs to bigger */
    SPI_InitStructure.SPI_FrameFormat = SPI_FrameFormat_SPI;
    SPI_Init(QSPI, &SPI_InitStructure);
    SPI_NSSConfig(QSPI, SPI_NSS_0, ENABLE);
}


//=========================================================================================================
//* Function name:   SPI_Configuration
//* Descriptions :   SPI配置 用于读取外部FLASH
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void SPI_Configuration(void)//Check-Ok;AMO;2018.05.25
{
    SPI_InitTypeDef   SPI_InitStructure;
    //用於熱感打印模組資料輸入;AMO;2018.05.25
    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; //SPI1设置为两线全双工;AMO;2018.05.25
    SPI_InitStructure.SPI_Mode = SPI_Mode_Master;                      //设置SPI1为主模式;AMO;2018.05.25
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;                  //SPI发送接收8位帧结构;AMO;2018.05.25
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;                        //串行时钟在不操作时，时钟为高电平;AMO;2018.05.25
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;                       //第二个时钟沿开始采样数据;AMO;2018.05.25
    SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;                          //NSS信号由软件（使用SSI位）管理;AMO;2018.05.25
    SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_8; 
    SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;                 //数据传输从MSB位开始;AMO;2018.05.25
    SPI_InitStructure.SPI_CRCPolynomial = 7;                           //CRC值计算的多项式;AMO;2018.05.25
    SPI_Init(SPI1, &SPI_InitStructure);
    SPI_Cmd(SPI1,ENABLE);


  //用於FLASH晶片讀取;AMO;2018.05.25
    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex; //SPI1设置为两线全双工;AMO;2018.05.25
    SPI_InitStructure.SPI_Mode = SPI_Mode_Master;                      //设置SPI1为主模式;AMO;2018.05.25
    SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;                  //SPI发送接收8位帧结构;AMO;2018.05.25
    SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;                        //串行时钟在不操作时，时钟为高电平;AMO;2018.05.25
    SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;                       //第二个时钟沿开始采样数据;AMO;2018.05.25
    SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;                          //NSS信号由软件（使用SSI位）管理;AMO;2018.05.25
    SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2; 
    SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;                 //数据传输从MSB位开始;AMO;2018.05.25
    SPI_InitStructure.SPI_CRCPolynomial = 7;                           //CRC值计算的多项式;AMO;2018.05.25
    SPI_Init(SPI2, &SPI_InitStructure);
    SPI_Cmd(SPI2,ENABLE);

    SPI_EnWrite_StatusReg(); //Enable
    SPI_Write_StatusReg(0x00); //Write 0x00
    SPI_Write_Disable();
}
*/

//=========================================================================================================
//FLASH_SPI初始化
//=========================================================================================================
void FLASH_SPI_Initial(void)
{
    FLASH_SPI_CS_high();;
    FLASH_SPI_MISO_high();
    FLASH_SPI_SCK_high();
    FLASH_SPI_MOSI_low(); 
}

//=========================================================================================================
//FLASH_SPI寫入8BIT的資料
//=========================================================================================================
void FLASH_SPI_WRITE_8BIT(uint8_t Byte_data)
{
//    uint8_t i;
//    FLASH_SPI_SCK_high();
//    for(i = 0; i < 8; i++)
//    {
//        FLASH_SPI_SCK = 0;
//        if(Byte_data & 0x80)
//        {
//            FLASH_SPI_MOSI = 1;
//        }
//        else
//        {
//            FLASH_SPI_MOSI = 0;
//        }
//        __NOP();
//        //Delay(1);
//        FLASH_SPI_SCK = 1;
//        __NOP();
//        //Delay(1);
//        Byte_data = Byte_data << 1;
//    }
//    FLASH_SPI_MOSI = 1;
//    FLASH_SPI_SCK = 1;
}

//=========================================================================================================
//FLASH_SPI讀取8BIT的資料
//=========================================================================================================
uint8_t FLASH_SPI_READ_8BIT(void)
{
//    uint8_t i;
    uint8_t Byte_data;
//        
//    FLASH_SPI_SCK = 1;
//    Byte_data = 0;
//    for(i = 0; i < 8; i++)
//    {
//        FLASH_SPI_SCK = 0;
//        __NOP();
//        //Delay(1);
//        Byte_data = Byte_data << 1;
//        if(FLASH_SPI_MISO == 1)
//        {
//            Byte_data = Byte_data | 0x01;
//        }
//        FLASH_SPI_SCK = 1;
//        __NOP();
//        //Delay(1);
//    
//    }
    return Byte_data;
}

//=========================================================================================================
//* Function name:    FLASH_ReadProtection    
//* Descriptions :    Flsah读保护
//=========================================================================================================
/*//沒使用，註解;AMO;2018.06.20
void FLASH_ReadProtection(void)
{
    if(FLASH_GetReadOutProtectionStatus() == RESET)
    {
        FLASH_Unlock();
        FLASH_ReadOutProtection(ENABLE);
        NVIC_SystemReset();
    }
}
*/

//=========================================================================================================
//SPI_FLASH晶片寫入1BYTE的資料
//=========================================================================================================
void FLASH_SPI_Send_1Byte(uint8_t SPI_Data)
{
    //FLASH_SPI_CS = 0;        //EN = 0; OFF = 1
    FLASH_SPI_WRITE_8BIT(SPI_Data);
    //FLASH_SPI_CS = 1;        //EN = 0; OFF = 1
}

//=========================================================================================================
//SPI_FLASH晶片讀取1BYTE的資料 
//=========================================================================================================
uint8_t FLASH_SPI_Read_1Byte(void)
{
    uint8_t Buf_DATA;

    FLASH_SPI_MISO_high();
    //FLASH_SPI_CS = 0;        //EN = 0; OFF = 1
    Buf_DATA = FLASH_SPI_READ_8BIT();
    //FLASH_SPI_CS = 1;        //EN = 0; OFF = 1
    return  Buf_DATA;
}


//=========================================================================================================
//SPI_EnWrite_StatusReg
//=========================================================================================================
void SPI_EnWrite_StatusReg(void)
{
    SPI_Wait_Busy();
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_EnWriteSR);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
}

//=========================================================================================================
//SPI_Read_StatusReg
//=========================================================================================================
uint8_t SPI_Read_StatusReg(void)
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadStatusReg);
    //SPI_Send_Byte(FLASH_ReadStatusReg);//AMO註解;AMO;2018.05.25
    byte = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20	
    FLASH_SPI_CS_high();        //EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//SPI_Write_StatusReg
//=========================================================================================================
void SPI_Write_StatusReg(uint8_t byte)
{
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteStatusReg);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
    SPI_Wait_Busy();
}

//=========================================================================================================
//SPI_Write_Enable
//=========================================================================================================
void SPI_Write_Enable(void)
{
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteEnable);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
}

//=========================================================================================================
//SPI_Write_Disable
//=========================================================================================================
void SPI_Write_Disable(void)
{
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_WriteDisable);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
}

//=========================================================================================================
//SPI_Read_ID1
//=========================================================================================================
uint8_t SPI_Read_ID1(void)
{
    uint8_t byte;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_DeviceID);
    FLASH_SPI_Send_1Byte(0);
    FLASH_SPI_Send_1Byte(0);
    FLASH_SPI_Send_1Byte(0);
    byte = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    byte = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    FLASH_SPI_CS_high();        //EN = 0；OFF = 1
    return byte;
}

//=========================================================================================================
//从片外读1个字节
//=========================================================================================================
uint8_t SPI_Read_Byte(uint32_t Dst_Addr)//从片外读1个字节  //Check-Ok;AMO;2018.05.25
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadData);
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte((uint8_t)(Dst_Addr & 0xFF));
    byte = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    FLASH_SPI_CS_high();        //EN = 0；OFF = 1
    return byte;
}

//=========================================================================================================
//从片外读n个字节
//=========================================================================================================
void SPI_Read_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//从片外读n个字节
{
    uint32_t i = 0;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    for (i = 0; i < nBytes; i ++)
    {
        Data[i] = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    }
    FLASH_SPI_CS_high();        //EN=0；OFF=1
}

//=========================================================================================================
//从片外读1个字节
//=========================================================================================================
uint8_t SPI_FastRead_Byte(uint32_t Dst_Addr)//从片外读1个字节
{
    uint8_t byte = 0;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_FastReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(0xFF);	// dummy byte
    byte = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    FLASH_SPI_CS_high();       //EN=0；OFF=1
    return byte;
}

//=========================================================================================================
//从片外读n个字节
//=========================================================================================================
void SPI_FastRead_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//从片外读n个字节  //Check-Ok;AMO;2018.05.25
{
    uint32_t i = 0;
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_FastReadData);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(0xFF);	// dummy byte
    for (i = 0; i < nBytes; i ++)
    {
        Data[i] = FLASH_SPI_Read_1Byte();//;AMO;2018.06.20
    }
    FLASH_SPI_CS_high();        //EN=0；OFF=1
}

//=========================================================================================================
//往片外写1个字节数据
//=========================================================================================================
void SPI_Write_Byte(uint32_t Dst_Addr, uint8_t byte)//往片外写1个字节数据  //Check-Ok;AMO;2018.05.25
{
    SPI_Wait_Busy();
    SPI_Write_Enable();
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_ByteProgram);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(byte);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
    SPI_Wait_Busy();
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//往片外写2个字节数据
//=========================================================================================================
void SPI_Write_2Bytes(uint32_t Dst_Addr, uint8_t Data1, uint8_t Data2)//往片外写2个字节数据
{
    SPI_Wait_Busy();
    SPI_Write_Enable();
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_AAIWordProgram);
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
    FLASH_SPI_Send_1Byte(Data1);
    FLASH_SPI_Send_1Byte(Data2);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
    SPI_Wait_Busy();
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//往片外写n个字节数据
//=========================================================================================================
void SPI_Write_nBytes(uint32_t Dst_Addr, uint8_t *Data, uint32_t nBytes)//往片外写n个字节数据
{
    uint32_t i;
    uint8_t byte;
    SPI_Wait_Busy();
    SPI_Write_Enable();
    for(i = 0; i < nBytes; i++)
    {
        FLASH_SPI_CS_low();        //EN=0；OFF=1
        FLASH_SPI_Send_1Byte(FLASH_AAIWordProgram);
        if(i == 0)
        {
            FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFFFF) >> 16));
            FLASH_SPI_Send_1Byte(((Dst_Addr & 0xFFFF) >> 8));
            FLASH_SPI_Send_1Byte(Dst_Addr & 0xFF);
        }
        byte = Data[i];
        FLASH_SPI_Send_1Byte(byte);
        i++;
        byte = Data[i];
        FLASH_SPI_Send_1Byte(byte);
        FLASH_SPI_CS_high();        //EN=0；OFF=1
        SPI_Wait_Busy();
    }
    SPI_Write_Disable();
    SPI_Wait_Busy();
}

//=========================================================================================================
//擦除整片
//=========================================================================================================
/*//沒用到;AMO註解;AMO;2018.05.25
void SPI_Erase_Chip(void)//擦除整片
{
    SPI_Write_Enable(); // set WEL
    SPI_Wait_Busy();
    FLASH_CS_RESET;
    SPI_Send_Byte(FLASH_ChipErase);
    FLASH_CS_SET;
    SPI_Wait_Busy();
}
*/

//=========================================================================================================
//擦除一块的数据 
//=========================================================================================================
void SPI_Erase_Sector(uint32_t Dst_Addr)//擦除一块的数据  //Check-Ok;AMO;2018.05.25
{
    SPI_Write_Enable();	// set WEL //下達flash寫入指令;AMO;2018.05.25
    FLASH_SPI_CS_low();        //EN=0；OFF=1
    FLASH_SPI_Send_1Byte(FLASH_4KSectorErase);
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFFFF) >> 16));
    FLASH_SPI_Send_1Byte((uint8_t)((Dst_Addr & 0xFFFF) >> 8));
    FLASH_SPI_Send_1Byte((uint8_t)Dst_Addr & 0xFF);
    FLASH_SPI_CS_high();        //EN=0；OFF=1
    SPI_Wait_Busy();//0x03，表示正在Erase/Write處理中，處理完則離開繼續;AMO;2018.05.25
}

//=========================================================================================================
//SPI_Wait_Busy 
//=========================================================================================================
void SPI_Wait_Busy(void)
{
    while (SPI_Read_StatusReg() == 0x03);//0x03，表示正在Erase/Write處理中;AMO;2018.05.25
}

//=========================================================================================================
//SPI_Send_Byte(uint8_t out)
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
void SPI_Send_Byte(uint8_t out)//spi 发送一个字节
{
    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);

    SPI_I2S_SendData(SPI2, out);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) != RESET);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_RXNE) == RESET);
    SPI_I2S_ReceiveData(SPI2);
}
*/

//=========================================================================================================
//SPI_Get_Byte(void)
//=========================================================================================================
/*//AMO註解;AMO;2018.05.25
uint8_t SPI_Get_Byte(void)//spi 接收一个字节
{
    uint8_t in=0x55;

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);

    SPI_I2S_SendData(SPI2, in);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) != RESET);

    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_RXNE) == RESET);
    in= SPI_I2S_ReceiveData(SPI2);
    return in;
}
*/

