
//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode.c］
//=========================================================================================================
//* File Name     : BarCode.c
//* Description   : BarCode  Operation
//=========================================================================================================

/* Wizards- ------------------------------------------------------------------*/
/* Includes ------------------------------------------------------------------*/
#include "BarCode.h"

/* Exported types ------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions prototypes ---------------------------------------------*/


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode.c］
//=========================================================================================================
//* File Name     : BarCode.c
//* Description   : BarCode  Operation
//=========================================================================================================
/*
typedef struct  
{
    //uint8_t     ucWide;           //条码的宽
    //uint8_t     ucHigh;           //条码的高
    uint8_t     WideAmp;          //宽的放大系数
    //uint8_t     HighAmp;          //高的放大系数
    uint8_t     ucNum;            //条码的碼元个数
    uint8_t     aBarDat[256];     //碼元缓存区,可以根据实际情况 变为更大或者更小
    //uint16_t    usLeftSpace;      //左边距
}TagOneBar;
*/

TagOneBar  tag_OneBar;  

void PrintBarCode_UPCA(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_UPCE(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_EAN13(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_JAN8(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_CODE39(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_ITF(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_CODEBAR(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_CODE93(uint8_t *barcodeBuf, uint8_t length);
void PrintBarCode_CODE128(uint8_t *barcodeBuf, uint8_t length);
//void PrintBarCode_EAN8(uint8_t *barcodeBuf, uint8_t length);


//◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆◆
//［BarCode.c］
//=========================================================================================================
//* Function name:     PrintBarCode_EAN13 
//* Descriptions :     打印EAN13码
//=========================================================================================================
void PrintBarCode_EAN13(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;
    //if(length>12 || length<11)
    //{
        //return;
    //}
    for(i = 0; i < length; i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(tag_OneBar.aBarDat[i] < '0'||tag_OneBar.aBarDat[i] > '9')
        //{
            //return;
        //}
    }
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - length)/2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = ((95*BarCode.cWidth+iPrtLeftMargin)/SFONT_WIDTH - length)/2;//计算打印位置
            break;
        default:
            iLong = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - length)/2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    tag_OneBar.ucNum = length;
    PrintOneBarEan13();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i <length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

//=========================================================================================================
//* Function name:     PrintBarCode_UPCA 
//* Descriptions :     打印UPC-A码
//=========================================================================================================
void PrintBarCode_UPCA(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;

    /*if(length>12 || length<11)
    {
        return;
    }*/
    for(i = 0;i < length;i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        /*if(tag_OneBar.aBarDat[i] < '0'||tag_OneBar.aBarDat[i] > '9')
        {
            return;
        }*/
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 12 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 12 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 12 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i <length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarUPCA();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0;i <length;i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

//=========================================================================================================
//* Function name:     PrintBarCode_UPCE 
//* Descriptions :     打印UPC-E码
//=========================================================================================================
void PrintBarCode_UPCE(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;
    //if(length>12 || length<11)
    //{
        //return;
    //}
    for(i = 0;i < length;i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(tag_OneBar.aBarDat[i] < '0'||tag_OneBar.aBarDat[i] > '9')
        //{
            //return;
        //}
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = (((6 * UPCE_LEN + UPCE_START_LEN + UPCE_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = (((6 * UPCE_LEN + UPCE_START_LEN + UPCE_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = (((6 * UPCE_LEN + UPCE_START_LEN + UPCE_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong;i > 0;i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i <length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong;i > 0;i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarUPCE();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i <length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;

}

//=========================================================================================================
//* Function name:    PrintBarCode_JAN8
//* Descriptions :     打印JAN8码
//=========================================================================================================
void PrintBarCode_JAN8(uint8_t *barcodeBuf, uint8_t length) 
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;
    //if(length>8 || length<7)
    {
        //return;
    }
    for(i = 0; i < length; i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(tag_OneBar.aBarDat[i] < '0'||tag_OneBar.aBarDat[i] > '9')
        {
        //  return;
        }
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 8 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length)/2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 8 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length)/2;//计算打印位置
            break;
        default:
            iLong = (((2 * EAN_SEG_LEN + EAN_MID_LEN + 8 * EAN_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length)/2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0;i <length;i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarEan8();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

//=========================================================================================================
//* Function name:    PrintBarCode_CODE39
//* Descriptions :     打印CODE39码
//=========================================================================================================
void PrintBarCode_CODE39(uint8_t *barcodeBuf, uint8_t length)
{
	uint8_t i;
	uint32_t iLong;
	uint8_t bHRIFontSize;
	uint8_t bHRIOnBarCode = 0;
	uint8_t bHRIUnderBarCode = 0;
	uint32_t  iAddr;
	//if(length>255 || length<1)
	{
		//return;
	}
	for(i = 0;i < length;i ++)
	{
		tag_OneBar.aBarDat[i] = barcodeBuf[i];
		//if((45<=tag_OneBar.aBarDat[i] <=57)||(65<=tag_OneBar.aBarDat[i] <=90)||(tag_OneBar.aBarDat[i]==32)||
		//	(tag_OneBar.aBarDat[i]==36)||(tag_OneBar.aBarDat[i]==37)||(tag_OneBar.aBarDat[i]==42)||(tag_OneBar.aBarDat[i]==43))
		//{
		//	;
		//}
		//else
		//{
		//	return;
		//}
	}
	tag_OneBar.ucNum = length;
	bHRIFontSize = bFont12x24;
	switch(BarCode.cFont)
	{
		case 0:
			bFont12x24 = 1;
			iLong = (((2+tag_OneBar.ucNum)*12*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - length)/2;//计算打印位置
			break;
		case 1:
			bFont12x24 = 0;
			iLong = (((2+tag_OneBar.ucNum)*12*BarCode.cWidth+iPrtLeftMargin)/SFONT_WIDTH - length)/2;//计算打印位置
			break;
		default:
			iLong = (((2+tag_OneBar.ucNum)*12*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - length)/2;//计算打印位置
			break;
	}
	
	switch(BarCode.cFontPosition)
	{
		case 1:
			bHRIOnBarCode = 1;
			break;
		case 2:
			bHRIUnderBarCode = 1;
			break;
		case 3:
			bHRIOnBarCode = 1;
			bHRIUnderBarCode = 1;
			break;
		default:
			bHRIOnBarCode = 0;
			bHRIUnderBarCode = 0;
			break;
	}
	if(bHRIOnBarCode == 1)//打印HRI字符
	{					
		if(bAlign == Align_Left)
		{
			for(i = iLong;i > 0;i --)
			{
				iAddr = CalculateAsciiAddr(' ');
				GetAsciiZimo(iAddr);
				FillPrtBufAscii();
			}
		}
		for(i = 0;i <length;i++)
		{
			iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
			GetAsciiZimo(iAddr);
			FillPrtBufAscii();
		}
		if(bAlign == Align_Right)
		{
			for(i = iLong;i > 0;i --)
			{
				iAddr = CalculateAsciiAddr(' ');
				GetAsciiZimo(iAddr);
				FillPrtBufAscii();
			}
		}
		StartupPrint(1);
	}
	//BarCodeEan13(cBarCodeBuf);//打印条码
	tag_OneBar.WideAmp = BarCode.cWidth;
	//tag_OneBar.ucNum = length;
	PrintOneBarCode39();
	bHaveFilledBarCode = 1;
	StartupPrint(1);
	//BarCodeInit();
	//bHaveFilledBarCode = 0;
	if(bHRIUnderBarCode == 1)//打印HRI字符
	{
		//i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
		if(bAlign == Align_Left)
		{
			for(i = iLong;i > 0;i --)
			{
				iAddr = CalculateAsciiAddr(' ');
				GetAsciiZimo(iAddr);
				FillPrtBufAscii();
			}
		}
		for(i = 0;i <length;i++)
		{
			iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
			GetAsciiZimo(iAddr);
			FillPrtBufAscii();
		}
		if(bAlign == Align_Right)
		{
			for(i = iLong;i > 0;i --)
			{
				iAddr = CalculateAsciiAddr(' ');
				GetAsciiZimo(iAddr);
				FillPrtBufAscii();
			}
		}
		StartupPrint(1);
	}
	bFont12x24 = bHRIFontSize;

}

//=========================================================================================================
//* Function name:    PrintBarCode_ITF
//* Descriptions :     打印ITF码
//=========================================================================================================
void PrintBarCode_ITF(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;
    
    //if(length > 255 || length < 1 || ((length%2) != 0))
    //{
        //return;
    //}
    for(i = 0; i < length; i++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(48 <= tag_OneBar.aBarDat[i] <= 57)
        //{
        //  ;
        //}
        //else
        //{
        //  return;
        //}
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = (((tag_OneBar.ucNum * (2 * 3 + 2) + 9) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = (((tag_OneBar.ucNum * (2 * 3 + 2) + 9) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = (((tag_OneBar.ucNum * (2 * 3 + 2) + 9) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarITF();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}


//=========================================================================================================
//* Function name:    PrintBarCode_CODEBAR
//* Descriptions :     打印codebar码
//=========================================================================================================
void PrintBarCode_CODEBAR(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;

    //if(length > 255 || length < 1)
    //{
        //return;
    //}
    for(i = 0; i < length; i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if((45<=tag_OneBar.aBarDat[i] <=58)||(65<=tag_OneBar.aBarDat[i] <=68)||(tag_OneBar.aBarDat[i]==36)||
        //	tag_OneBar.aBarDat[i]==43)
        //{
        //	;
        //}
        //else
        //{
        //	return;
        //}
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = ((tag_OneBar.ucNum * (7 + 3) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = ((tag_OneBar.ucNum * (7 + 3) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = ((tag_OneBar.ucNum * (7 + 3) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarCodaBar();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

//=========================================================================================================
//* Function name:    PrintBarCode_CODE93
//* Descriptions :     打印CODE93码
//=========================================================================================================
void PrintBarCode_CODE93(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t iAddr;

    if(length > 255 || length < 1)
    {
        return;
    }
    for(i = 0; i < length; i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(tag_OneBar.aBarDat[i] <= 127)
        //{
        //    ;
        //}
        //else
        //{
        //    return;
        //}
    }

    bHRIFontSize = bFont12x24;
    tag_OneBar.ucNum = length;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = ((((tag_OneBar.ucNum + 4) * CODE93_LEN + CODE93_LASTLEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = ((((tag_OneBar.ucNum + 4) * CODE93_LEN + CODE93_LASTLEN) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = ((((tag_OneBar.ucNum + 4) * CODE93_LEN + CODE93_LASTLEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }
    
    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i --)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    PrintOneBarCode93();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin) / ASCII_WIDTH - cTemp) / 2;  //计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

//=========================================================================================================
//* Function name:    PrintBarCode_CODE128
//* Descriptions :     打印CODE128码
//=========================================================================================================
void PrintBarCode_CODE128(uint8_t *barcodeBuf, uint8_t length)
{
    uint8_t i;
    uint32_t iLong;
    uint8_t bHRIFontSize;
    uint8_t bHRIOnBarCode = 0;
    uint8_t bHRIUnderBarCode = 0;
    uint32_t  iAddr;

    //if(length>255 || length<2)
    //{
        //return;
    //}
    for(i = 0; i < length; i ++)
    {
        tag_OneBar.aBarDat[i] = barcodeBuf[i];
        //if(tag_OneBar.aBarDat[i] <= 127)
        //{
        //    ;
        //}
        //else
        //{
        //    return;
        //}
    }
    tag_OneBar.ucNum = length;
    bHRIFontSize = bFont12x24;
    switch(BarCode.cFont)
    {
        case 0:
            bFont12x24 = 1;
            iLong = ((((tag_OneBar.ucNum + 2) * CODE128_LEN + CODE128_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
        case 1:
            bFont12x24 = 0;
            iLong = ((((tag_OneBar.ucNum + 2) * CODE128_LEN + CODE128_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / SFONT_WIDTH - length) / 2;//计算打印位置
            break;
        default:
            iLong = ((((tag_OneBar.ucNum + 2) * CODE128_LEN + CODE128_END_LEN) * BarCode.cWidth + iPrtLeftMargin) / ASCII_WIDTH - length) / 2;//计算打印位置
            break;
    }

    switch(BarCode.cFontPosition)
    {
        case 1:
            bHRIOnBarCode = 1;
            break;
        case 2:
            bHRIUnderBarCode = 1;
            break;
        case 3:
            bHRIOnBarCode = 1;
            bHRIUnderBarCode = 1;
            break;
        default:
            bHRIOnBarCode = 0;
            bHRIUnderBarCode = 0;
            break;
    }
    if(bHRIOnBarCode == 1)//打印HRI字符
    {
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    //BarCodeEan13(cBarCodeBuf);//打印条码
    tag_OneBar.WideAmp = BarCode.cWidth;
    //tag_OneBar.ucNum = length;
    PrintOneBarCode128();
    bHaveFilledBarCode = 1;
    StartupPrint(1);
    //BarCodeInit();
    //bHaveFilledBarCode = 0;
    if(bHRIUnderBarCode == 1)//打印HRI字符
    {
        //i = ((95*BarCode.cWidth+iPrtLeftMargin)/ASCII_WIDTH - cTemp)/2;//计算打印位置
        if(bAlign == Align_Left)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        for(i = 0; i < length; i++)
        {
            iAddr = CalculateAsciiAddr(tag_OneBar.aBarDat[i]);
            GetAsciiZimo(iAddr);
            FillPrtBufAscii();
        }
        if(bAlign == Align_Right)
        {
            for(i = iLong; i > 0; i--)
            {
                iAddr = CalculateAsciiAddr(' ');
                GetAsciiZimo(iAddr);
                FillPrtBufAscii();
            }
        }
        StartupPrint(1);
    }
    bFont12x24 = bHRIFontSize;
}

