
#define		uCHAR	unsigned char
#define		uINT	unsigned short

#include "REG_MG82G5Exx.H"




void INT_INT0(void)	interrupt	0	using	1
{
	P34 = ~P34;
	IE0 = 0;					//clear interrupt flag
}

void INT_INT1(void)	interrupt	2	using	1
{
	P35 = ~P35;
	IE1 = 0;					//clear interrupt flag
}

void INT_INT2(void)	interrupt	6	using	1
{
	P36 = ~P36;
	IE2 = 0;					//clear interrupt flag
}

void INT_INT3(void)	interrupt	7	using	1
{
	P37 = ~P37;
	IE3 = 0;					//clear interrupt flag
}

void Initial_INT0(void)
{
	XICFG &= ~(INT0IS1 | INT0IS0);	//Select INT0 input @P32
	SFRPI = 0x01;
	XICFG1 &= ~INT0IS2;
	SFRPI = 0x00;
	AUXR0 &= ~INT0H;				//INT0 trigger on low level or falling edge
	IE0 = 0;
	IT0 = 1;					//Trigger INT0 on falling edge.
	EX0 = 1;
}

void Initial_INT1(void)
{
	XICFG &= ~(INT1IS1 | INT1IS0);	//Select INT1 input @P33
	SFRPI = 0x01;
	XICFG1 &= ~INT1IS2;
	SFRPI = 0x00;
	AUXR0 &= ~INT1H;				//INT1 trigger on low level or falling edge
	IE1 = 0;
	IT1 = 1;					//Trigger INT1 on falling edge.
	EX1 = 1;
}

void Initial_INT2(void)
{
	P4M0 |= 0x08;				//Enable P43 Open-Drain with pull-up resistor.
	SFRPI = 0x01;
	XICFG1 &= ~(INT2IS1 | INT2IS0);			//Select INT2 input @P43
	SFRPI = 0x02;
	XICFG2 &= ~INT2IS2;
	SFRPI = 0x00;
	INT2H = 0;					//INT2 trigger on low level or falling edge
	IE2 = 0;
	IT2 = 1;					//Trigger INT2 on falling edge.
	EX2 = 1;
}

void Initial_INT3(void)
{
	P4M0 |= 0x04;				//Enable P42 Open-Drain with pull-up resistor.
	SFRPI = 0x02;
	XICFG2 &= ~(INT3IS2 | INT3IS1 | INT3IS0);			//Select INT3 input @P42
	SFRPI = 0x00;
	INT3H = 0;					//INT3 trigger on low level or falling edge
	IE3 = 0;
	IT3 = 1;					//Trigger INT3 on falling edge.
	EX3 = 1;
}

void main(void)
{
	Initial_INT0();
	Initial_INT1();
	Initial_INT2();
	Initial_INT3();
	EA = 1;

	while(1);
}
