//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
#include <math.h>
//********************************************************************************
//								       RAM
//********************************************************************************
//datawqܶqbe128r`]0x00~0x7F^a}Ŷ
//idatawqܶqb]0x00~0xFF^a}Ŷ
//xdatawqܶqhObW~XiRAMŶ]@~0xF000~0xF1FFŶAŶjp]ӲAS~RAM^

//datawqܶqt׳̧֡AidataAxdatae̺C
//`QϥΪܼƥdata/idataŧi; `ϥΪܼƥxdataŧi.

struct{
	unsigned char Current_offset:1;			//1 = qyե.	
	unsigned char CloseLoopFlag:1;
	unsigned char ZeroPointFlag:1;
	unsigned char ZeroPointFlagOld:1;
	unsigned char MOTOR_PWM_ENABLE:1;		//1 = PWMX.
	unsigned char MOTOR_OFF_FLAG:1;			//1 = UFFO.
	unsigned char Break_flag:1;
}FLAG;

uint8 	MotorState = 0;
uint8 	MotorFaultState = 0;	//બA; 1=Lt, 2=t, 3=IQLj, 4=IQLp
uint8 	MotorDir = 0;						//0=R, 1=CW, 2=CCW
xdata 	uint8 	CCWFlag = CW_CCW;			//0=CW, 1=CCW


//Speed
//uint8   SpeedNum = 0;
int16 	SpeedCmd = 0;
int16 	SpeedCmdTemp = 0;
idata 	int16 	EstimatedSpeed;

//Current
int16 	CurrentCmd = 0;
int16 	CurrentCmdTemp = 0;

int16 	Ibus_avg = 0;

//Temperature
uint16 Temperature_avg = 0;

//VSP
uint16 Vsp_avg;

//uint16 VbusOffset;
uint16 Vbus_avg = 0;
uint16 Vbus_avg_old = 0;

xdata uint16 	CloseLoopDelayCount = 0;

xdata int16 	LatestTheta = 0;

xdata int16 	TailwindSpeed = 0;

xdata uint8 	AngleState = 0;
xdata uint8 	AngleStateOld = 0;
xdata int8 		AngleStateCehckCount = 0;

xdata uint16 	BreakPwmDuty = 0;

//Count
xdata uint16 	IQ_Parking_cnt 			= 0;
xdata uint16 	RampDelayCount 			= 0;
xdata uint16 	TailwindCount 			= 0;
xdata uint16 	TailwindTimeOut 		= 0;
xdata uint8  	MotorStartRetryCount 	= 0;

//IQ,ID
xdata int16 	IqOutTemp = 0;
xdata int16 	IdOutTemp = 0;

//BEMF
xdata int16 BmfU;
xdata int16 BmfV;
xdata int16 BmfW;
xdata int16 BmfVW_Sub;
xdata uint16 abs_BmfVW_Sub;
xdata int16 BmfVW_Sum_Pos_ZeroPoint;
xdata int16 BmfVW_Sum_Neg_ZeroPoint;
xdata uint16 BmfBreakCount = 0;
xdata int8 ZeroPointDebounceCnt;
xdata int8 ZeroPointCnt;
xdata int8 ZeroPointCheck = 0;

//PLL
xdata int16 PllOutTemp = 0;

//RF
//idata uint8 SpeedNum_temp = 0;


xdata	uint16	ABS_break_time = 0;
xdata	uint16	Motor_standstill_judgment_cnt = 0;

//xdata 	unsigned char	vbus_high_sw;
//xdata	unsigned int 	PowerCmd;
//xdata	signed int		POWER_TARGET_VALUES;

//********************************************************************************
//								   	tשRO
//********************************************************************************	
#if (VSP_TRI == 1)
	void Vsp_Fun (void){
		#if (dSlope_control == 1)
			if(Vsp_avg > CMD_START_VAL){
		#endif
		
		#if (dStage_control == 1)
			if(Vsp_avg > 102){
		#endif
		
			if(FLAG.MOTOR_PWM_ENABLE==0)
				FLAG.MOTOR_PWM_ENABLE = 1;
				
			#if (CURRENT_CONTROL == 1)
					#if (dStage_control == 1)
					if(Vsp_avg <= 220)
						CurrentCmd = IQ_SIXTH_VALUE;
					else if(Vsp_avg <= 320)
						CurrentCmd = IQ_FIFTH_VALUE;
					else if(Vsp_avg <= 450)
						CurrentCmd = IQ_FOURTH_VALUE;
					else if(Vsp_avg <= 530)
						CurrentCmd = IQ_THIRD_VALUE;
					else if(Vsp_avg <= 650)
						CurrentCmd = IQ_SECOND_VALUE;
					else
						CurrentCmd = IQ_MAX_LIMIT_VALUE;
				#endif

				#if (dSlope_control == 1)	
				CurrentCmd = (int)((float) Vsp_avg * IQ_GAIN);
				#endif
			#endif
			
			#if (SPEED_CONTROL == 1)
				#if (dStage_control == 1)
					if(Vsp_avg < 100)
						SpeedCmd = 0;
					else if(Vsp_avg <= 300)
						SpeedCmd = VSP_SPEED_1;
					else if(Vsp_avg <= 500)
						SpeedCmd = VSP_SPEED_2;
					else if(Vsp_avg <= 700)
						SpeedCmd = VSP_SPEED_3;
					else if(Vsp_avg <= 900)
						SpeedCmd = VSP_SPEED_4;
					else
						SpeedCmd = VSP_SPEED_5;

				#endif
				
				#if (dSlope_control == 1)
					SpeedCmd = ((SPEED_STEP * (Vsp_avg - CMD_START_VAL)) / 1023) + SPEED_MIN_LIMIT_VALUE;	
				#endif
			#endif
		}
		else{
			#if (dSlope_control == 1)
				if(Vsp_avg < CMD_STOP_VAL){
			#endif
		
			#if (dStage_control == 1)
				if(Vsp_avg < 80){
			#endif
		
				if(MotorState == M_RUN){
					#if (CURRENT_CONTROL == 1)
						if(CurrentCmd > 100)
							CurrentCmd -= 10;
					#endif
					
					#if (SPEED_CONTROL == 1)
						if(SpeedCmd > SPEED_MIN_LIMIT_VALUE)
							SpeedCmd -= 10;
					#endif
					
					else{
						FLAG.MOTOR_PWM_ENABLE = 0; // Motor Stop
						MotorErrorState = 0;
						CurrentCmd = 0;
						SpeedCmd = 0;
						//SpeedNum = 0;
					}
				}
				else{
					FLAG.MOTOR_PWM_ENABLE = 0;
					MotorErrorState = 0;
					CurrentCmd = 0;
					SpeedCmd = 0;
					//SpeedNum = 0;
				}
			}
		}
	}
#endif
//********************************************************************************
//								    b
//********************************************************************************
void Break_Fun (void){
	#if (BREAK_FUNCTION == 1)
	  MOTOR_CONT1 &= ~(MPWMDUSEL);// Enable PWM User Mode
		PWM_SetBreak();
		if(BreakPwmDuty < BREAK_DUTY_VALUE) BreakPwmDuty++;
			PWM_Duty(BreakPwmDuty);
	#else
		MOTOR_CONT1 &= ~(MPWMDUSEL);// Enable PWM User Mode
		PWM_SetBreakForce();
		if(BreakPwmDuty < BREAK_DUTY_VALUE) BreakPwmDuty++;
			PWM_Duty(BreakPwmDuty);
	#endif
}
//********************************************************************************
//							    Square Parking set
//********************************************************************************
#if(SQUARE_PARKING == 1)
void Phase_Duty_Setup(uint8 Phase, uint16 Duty){
	if(Phase == 0){    // upvd
		MPWMCONT1 = ForceLow << 2 | ActiveLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ForceLow << 4 | ForceHi << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = Duty;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
	}
	else if(Phase == 1)    // upwd
	{
		MPWMCONT1 = ForceLow << 2 | ActiveLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceHi << 6 | ForceLow << 4 | ForceLow << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = Duty;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
	}
	else if(Phase == 2)    // vpwd
	{
		MPWMCONT1 = ForceLow << 2 | ForceLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceHi << 6 | ForceLow << 4 | ForceLow << 2 | ActiveLow; // z,w,y,v
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = Duty;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
	}
	else if(Phase == 3)    // vpud
	{
		MPWMCONT1 = ForceHi << 2 | ForceLow;   // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ForceLow << 4 | ForceLow << 2 | ActiveLow; // z,w,y,v
		SYNC = 0x55;
			
		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;
		
		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = Duty;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = 0;
		SYNC = 0x55;
	}
	else if(Phase == 4)    // wpud
	{	
		MPWMCONT1 = ForceHi << 2 | ForceLow;	  // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ActiveLow << 4 | ForceLow << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = Duty;
		SYNC = 0x55;
	}
	else if(Phase == 5)    // wpvd
	{
		MPWMCONT1 = ForceLow << 2 | ForceLow; // x,u
		SYNC = 0x55;
		MPWMCONT2 = ForceLow << 6 | ActiveLow << 4 | ForceHi << 2 | ForceLow; // z,w,y,v
		SYNC = 0x55;

		SFR_PAGE = 1; // PWM Duty U
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 2; // PWM Duty V
		MPWMDATA = 0;
		SYNC = 0x55;

		SFR_PAGE = 3; // PWM Duty W
		MPWMDATA = Duty;
		SYNC = 0x55;
	}
}
#endif



