/*********************************************************************
*    Project: MG82F6D16-DEMO
*            MG82F6Dxx	SSOP28 EV Board (TH189A)
*			CpuCLK=12MHz, SysCLK=12MHz
*    Description:
*			CMP,P10 as the positive input,P11 as the negative input
*    Note:
* 
*    Creat time:
*    Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D16.H"
#include ".\include\API_Uart_BRGRL_MG82F6D16.H"


/*************************************************
*Set SysClk (MAX.50MHz)
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.25MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26


/***********************************************************************************
*Function:   	void INT_AC0(void)
*Description:	AC0  Interrupt handler
		 
*Input:   
*Output:     
*************************************************************************************/
void INT_AC0(void) interrupt INT_VECTOR_AC0
{
	if((AC0CON&AC0F)==AC0F)
	{
		LED_R=!LED_R;
		AC0CON=AC0CON&(~AC0F);		// clear AC0 interrupt flag
	}
}

/*************************************************
*Function: 		char putchar (char c)   
*Description: 	send for printf
*Input:    		char c
*Output:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*Function:     	void DelayXus(u8 xUs)
*Description:   	dealy,unit:us
*Input:     		u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     	void DelayXms(u16 xMs)
*Description:    dealy,unit:ms
*Input:     		u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}


/***********************************************************************************
*Function:  		void InitUart0_S0BRG(void)
*Description:   	Initialize Uart0, The source of baud rate was S0BRG
*Input:   
*Output:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{	
	UART0_SetAccess_S0CR1();			// Enable access S0CR1 
	UART0_SetMode8bitUARTVar();			// UART0 Mode: 8-bit, Variable B.R.
	UART0_EnReception();				// Enable reception
	UART0_SetBRGFromS0BRG();			// B.R. source:S0BRG
	UART0_SetS0BRGBaudRateX2();			// B.R. x2
	UART0_SetS0BRGSelSYSCLK();			// S0BRG clock source: SYSCLK

    // Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_12000000_1T);
	
	UART0_EnS0BRG();					// Enable S0BRG
}


/***********************************************************************************
*Function:   	void InitPort(void)
*Description:  	Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);			// Set P22,P24,P26 as Push-Pull,For LED.
	PORT_SetP1AInputOnly(BIT0|BIT1);  			// Set P10,P11 as Analog-Input-Only,For CMP input.
}

/***********************************************************************************
*Function:   	void InitCMP(void)
*Description:   	Initialize CMP
*Input:   
*Output:     
*************************************************************************************/
void InitCMP(void)
{
	AC0_Enable();										// Enable CMP0
	AC0_SetInterruptMode_Rising();						// Set interrupt mode:Rising edge
	AC0_SetPosInputP10();								// Positive: P10
	AC0_SetNegaReferenceVoltage_AC0NI();				// Negative: P11
}

/***********************************************************************************
*Function:   	void InitInterrupt(void)
*Description:   	Initialize Interrupt
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnAC0();										// Enable CMP0 interrupt
}	


/***********************************************************************************
*Function:   	void InitSystem(void)
*Description:   	Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{

	InitPort();
	InitUart0_S0BRG();
	InitCMP();
	InitInterrupt();
}



void main()
{
    InitSystem();
	
	printf("\nHello");
	
	LED_G_1=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;LED_G_0=1;

	INT_EnAll();									// Enable global interrupt
    while(1)
    {
		DelayXms(200);
		LED_G_0=!LED_G_0;
    }
}


