/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			T2 mode: 8bit PWM, output to P31 
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46


#define IO_T2_PWM_OUT	P31

#define T2_PWM_STEP_MAX	200		//  step(2~256): 200

#define T2_PWM_DUTY_0	((256-T2_PWM_STEP_MAX)+0)	
#define T2_PWM_DUTY_10	((256-T2_PWM_STEP_MAX)+(10*T2_PWM_STEP_MAX)/100)	
#define T2_PWM_DUTY_30	((256-T2_PWM_STEP_MAX)+(30*T2_PWM_STEP_MAX)/100)	
#define T2_PWM_DUTY_60	((256-T2_PWM_STEP_MAX)+(60*T2_PWM_STEP_MAX)/100)	
#define T2_PWM_DUTY_80	((256-T2_PWM_STEP_MAX)+(80*T2_PWM_STEP_MAX)/100)	

/***********************************************************************************
*Function:void DelayXus(u8 xUs)
*Description:dealy,unit:us
*Input:u8 Us -> *1us  (1~255)
*Output:     
*************************************************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/***********************************************************************************
*Function:void DelayXms(u16 xMs)
*Description:dealy,unit:ms
*Input:u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitTimer2(void)
*Description:Initialize Timer2	
*Input:   
*Output:     
*************************************************************************************/
void InitTimer2(void)
{
	TM_SetT2Mode_8bitPWM();							// T2 mode: 8bit PWM	
	TM_SetT2Clock_SYSCLKDiv12();					// T2 clock source: SYSCLK/12
	
	TM_SetT2LowByte(T2_PWM_DUTY_10);				// T2 low byte	(duty)  			
	TM_SetT2RLLowByte(T2_PWM_DUTY_10);				// T2 low byte reload  (duty) 
	
	TM_SetT2HighByte(256-T2_PWM_STEP_MAX);			// T2 high byte	(freq)  
	TM_SetT2RLHighByte(256-T2_PWM_STEP_MAX);		// T2 high byte	reload (freq)
	
	TM_EnableT2();									// Enable T2

	//TM_EnableT2CKO_Invert();
	TM_SetT2CKOT2EX_P31P30();						// Set T2CKO output to P31
	TM_DisT2CKO();									// disable T2CKO output
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{

	IO_T2_PWM_OUT=1;
	
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 as Open-Drain with pull-up resistor,for LED
}

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitPort();
	InitClock();
	
	InitTimer2();			


}


void main()
{
	
    InitSystem();
	
 	LED_G_0=0;LED_R=0;LED_G_1=0;
	DelayXms(1000);
 	LED_G_0=1;LED_R=1;LED_G_1=1;

					
    while(1)
    {
    	LED_R=0;
    	LED_G_1=0;
    	TM_SetT2LowByte(T2_PWM_DUTY_0);
    	TM_SetT2RLLowByte(T2_PWM_DUTY_0);
    	DelayXms(1);
    	TM_EnT2CKO();
    	LED_G_1=1;
    	DelayXms(2);

    	LED_G_1=0;
    	TM_SetT2RLLowByte(T2_PWM_DUTY_10);
    	LED_G_1=1;
    	DelayXms(2);

    	LED_G_1=0;
    	TM_SetT2RLLowByte(T2_PWM_DUTY_30);
    	LED_G_1=1;
    	DelayXms(2);

    	LED_G_1=0;
    	TM_SetT2RLLowByte(T2_PWM_DUTY_60);
     	LED_G_1=1;
    	DelayXms(2);

    	LED_G_1=0;
    	TM_SetT2RLLowByte(T2_PWM_DUTY_80);
    	LED_G_1=1;
    	DelayXms(2);

    	LED_G_1=0;
    	TM_SetT2RLLowByte(0xFF);
    	LED_G_1=1;
    	DelayXms(2);

    	// Duty 100% 
    	LED_G_1=0;			
		TM_DisT2CKO();		
		IO_T2_PWM_OUT=0;
    	LED_G_1=1;
    	DelayXms(2);

		// Disable output
    	LED_R=1;
    	LED_G_1=0;
		TM_DisT2CKO();
		IO_T2_PWM_OUT=1;
    	LED_G_1=1;
		DelayXms(10);
    	
    }
}


