/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=8MHz, SysCLK=8MHz
*Description:
*			TWSI0 (SCL/P33, SDA/P46)Slave interrupt
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		8000000
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_R		P32
//#define LED_G_0		P33
//#define LED_G_1		P46

#define TWI0_SCL		P33
#define TWI0_SDA		P46


#define SLAVE_ADDRESS	0xA0
#define TEST_BUF_SIZE	16

#define	TWI_OV_TIME_MAX			20

u8	TWI0OvTime;
bit bTWI0Error;
bit bTWI0ADFlag;

bit bTWI0RXFlag;

WordTypeDef TWI0RegAddr;
xdata u8 TWI0Buf[TEST_BUF_SIZE];
u8 TWI0Inx;
bit bES0;
u8 LedTime;

/***********************************************************************************
*Function:   void INT_T0(void)
*Description:T0 Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;
	if(TWI0OvTime!=0) 
	{
		TWI0OvTime--;
		if(TWI0OvTime==0) bTWI0Error=TRUE;
	}
	if(LedTime!=0) LedTime--;
}


/***********************************************************************************
*Function:   void INT_TWI0(void)
*Description:TWI0 Interrupt handler
*Input:   
*Output:     
*************************************************************************************/
void INT_TWI0() interrupt INT_VECTOR_TWI0
{
	_push_(SFRPI);
	SFR_SetPage(0);
	if(SISTA==0x80)
	{ // 0x80: DATA has been received. ACK has been returned.
		TWI0OvTime = TWI_OV_TIME_MAX;			// restore TWI0 overtime
		if(bTWI0ADFlag==0)
		{// Reg Address
			if(TWI0Inx==0)
			{
				TWI0RegAddr.B.BHigh=SIDAT;
				TWI0Inx++;
			}
			else 
			{
				TWI0RegAddr.B.BLow=SIDAT;
				bTWI0ADFlag=1;					// The next byte is Data
				TWI0Inx=0;
			}
		}
		else
		{
			TWI0Buf[TWI0Inx]=SIDAT;				// Save received data into buffer
			TWI0Inx++;
			if(TWI0Inx>=TEST_BUF_SIZE) 
			{
				bTWI0RXFlag=TRUE;
				TWI0Inx=0;
				TWI0OvTime = 0; 				// buffer is full,set overtime to zero
			}
		}
	}
	else if((SISTA==0x60)||(SISTA==0x68))
	{// 0x60,0x68: Own SLA+W has been received. ACK has been returned
		bTWI0ADFlag=0;					// The next two byte is Reg address
		TWI0Inx=0;
		TWI0OvTime = TWI_OV_TIME_MAX;			// restore TWI0 overtime
	}
	else if((SISTA==0xA8)||(SISTA==0xB0))
	{// 0x60,0x68: Own SLA+R has been received. ACK has been returned
		TWI0Inx=0;						// Set buffer index to zero
		goto _IIC_SET_SIDAT;
	}
	else if((SISTA==0xB8)||(SISTA==0xC0)||(SISTA==0xC8))
	{
        // 0xB8:  Data byte in SIDAT has been transmitted ACK has been received
		// 0xC0:  Data byte or Last data byte in SIDAT has been transmitted Not ACK has been received
		// 0xC8:  Last Data byte in SIDAT has been transmitted ACK has been received
_IIC_SET_SIDAT:
		TWI0OvTime = TWI_OV_TIME_MAX;			// restore TWI0 overtime
		if(TWI0Inx>=TEST_BUF_SIZE) 
		{
			TWI0Inx=0;
			TWI0OvTime = 0; 				// buffer is full,set overtime to zero
		}
		SIDAT=TWI0Buf[TWI0Inx]; 				// Load data to send
		TWI0Inx++;
	}
	TWI0_SCL=0;
	SICON=SICON|(AA);						// Set AA
	SICON=SICON&(~SI);						// clear TWI0 interrupt flag
	TWI0_SCL=1;

	_pop_(SFRPI);
}


/***********************************************************************************
*Function:   void SendByte(u8 tByte)
*Description:Uart send byte
*Input:u8 tByte: the data to be send 
*Output:
*************************************************************************************/
void SendByte(u8 tByte)
{
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
*Function:   void SendStr(u8* PStr)
*Description:Uart send string
*Input:u8* PStr: the string to be send  
*Output:
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
*Function:   void SendHex(u8 ToSend)
*Description:Uart send data for HEX
*Input:u8 ToSend: the data to be send  
*Output:
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitUart0_S0BRG(void)
*Description:   Initialize Uart0, The source of baud rate was S0BRG
*Input:   
*Output:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// Set SFR 0xB9 address to access S0CR1
	UART0_SetMode8bitUARTVar();			// 8-bit, Variable B.R.
	UART0_EnReception();				// Enable reception
	UART0_SetBRGFromS0BRG();			// B.R. source: S0BRG
	UART0_SetS0BRGBaudRateX2();			// S0BRG x2
	UART0_SetS0BRGSelSYSCLK();			// S0BRG clock source:SYSCLK
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_8000000_1T);

	UART0_EnS0BRG();					// Enable S0BRG
}

/***********************************************************************************
*Function:   void InitTimer0(void)
*Description:Initialize Timer0
*Input:   
*Output:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// TIMER0 Mode: 16-bit
	TM_SetT0Clock_SYSCLKDiv12();			// TIMER0 Clock source: SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);						// Set TL0 value
	TM_SetT0HighByte(TIMER_12T_1ms_TH);					// Set TH0 value

	TM_EnableT0();							// Enable T0
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as Quasi-Bidirectional,for RXD/TXD,LED,TWI0_SCL
	PORT_SetP4OpenDrainPu(BIT6);				// Set P46 Open-Drain with pull-up resistor,for TWI0:SDA
}

/***********************************************************************************
*Function:   void InitTWI0_Slave(void)
*Description:Initialize TWI0 Slave mode
*Input:   
*Output:     
*************************************************************************************/
void InitTWI0_Slave()
{
	TWI0_Clear();
	TWI0_SetClock(TWI0_CLK_SYSCLK_32);
	TWI0_SetSCLSDAP33P46();
	TWI0_Enable();
	TWI0_SetSlaveAddr(SLAVE_ADDRESS);
	TWI0_SendACK();
}

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}



/***********************************************************************************
*Function:   void InitInterrupt(void)
*Description:   Initialize Interrupt 
*Input:   
*Output:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();				// Enable T0 interrupt
	INT_EnTWI0();				// Enable TWI0 interrupt
}	

/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTWI0_Slave();
	InitTimer0();
	InitUart0_S0BRG();
	InitInterrupt();

	INT_EnAll();			//  Enable global interrupt
}

void main()
{
	u8 i;
    InitSystem();


 	SendStr("\nStart");
 	
	LED_R=0;
	DelayXms(1000);
	LED_R=1;

	TWI0OvTime = 0; 				// Clear overtime

    while(1)
    {
    	if(LedTime==0)
    	{
			LED_R = !LED_R;
			if(LED_R==0)
			{
				LedTime=20;
			}
			else
			{
				LedTime=250;
			}
    	}
    	if(bTWI0RXFlag==TRUE)
    	{
			LED_R=1;
			SendStr("\nTWI0 RX 0x");
			SendHex(TWI0RegAddr.B.BHigh);
			SendHex(TWI0RegAddr.B.BLow);
			for(i=0;i<TEST_BUF_SIZE;i++)
			{
				SendByte(' ');
				SendHex(TWI0Buf[i]);
			}
			bTWI0RXFlag=FALSE;
			LED_R=1;
			LedTime=250;
    	}
    	
    	if(bTWI0Error==TRUE)
    	{
    		bTWI0Error=FALSE;
			// Error,reset TWI0
			LED_R=0;
			InitTWI0_Slave();
			DelayXms(50);
			LED_R=1;
			LedTime=250;
    	}
    }
}


