/*********************************************************************
*Project:MG82F6B08_001_104-DEMO
*			MG82F6B08_001_104 SOP16_V11 EV Board (TH221A)
*			CpuCLK=11.0592MHz, SysCLK=22.1184MHz
*Description:
*			CPUCLK=SYSCLK (22.1184MHz)
*			PCA clock: SYSCLK
*			CH0(P30),CH1(P33),CH2(P31),CH3(P46)
*			4 Channel,Edge aligned,8bit 256
*			PWM freq: 22.1184MHz/256=86.4KHz
*
*			P10 as input to control PWM output.P10=1: Enable,  P10=0: Disable
*Note:
*
*Creat time:
*Modify:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6B08_001_104.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6B08_001_104.H"
#include ".\include\API_Uart_BRGRL_MG82F6B08_001_104.H"


/*************************************************
*Set SysClk (MAX.24MHz)
*Selection: 
*	8000000,16000000
*	11059200,22118400
*************************************************/
#define MCU_SYSCLK		22118400
/*************************************************/
/*************************************************
*Set CpuClk (MAX.16MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
//#define MCU_CPUCLK		(MCU_SYSCLK)
#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define TIMER_12T_10ms_TH	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) /256) 			
#define TIMER_12T_10ms_TL	((65536-(u16)(float)(10000*((float)(MCU_SYSCLK)/12/(float)(1000000)))) %256)

#define LED_R		P32
#define LED_G_0		P33
#define LED_G_1		P46

idata WordTypeDef wDuty[4];

/*************************************************
*Function:     void DelayXus(u8 xUs)
*Description:  delay,unit:us
*Input:     u8 Us -> *1us  (1~255)
*Output:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*Function:     void DelayXms(u16 xMs)
*Description:delay,unit:ms
*Input:     u16 xMs -> *1ms  (1~65535)
*Output:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*Function:   void InitPort(void)
*Description:   Initialize IO Port
*Input:   
*Output:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP4PushPull(BIT6);						// Set P46 as push-pull
	PORT_SetP3PushPull(BIT0|BIT1|BIT2|BIT3);		// Set P30,P31,P32,P33 as push-pull

	P10=1;
	PORT_SetP1OpenDrainPu(BIT0);					// Set P10 as Open-Drain with pull-up resistor
}

/***********************************************************************************
*Function:   void InitPCA_PWM(void)
*Description:   Initialize PCA
*Input:   
*Output:     
*************************************************************************************/
void InitPCA_PWM(void)
{
	PCA_SetCLOCK_SYSCLK();							// PCA clock = SysClk
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();

	PCA_CH0_SetPWM_8Bit();
	PCA_CH1_SetPWM_8Bit();
	PCA_CH2_SetPWM_8Bit();
	PCA_CH3_SetPWM_8Bit();


	PCA_SetPWM_EdgeAligned();						// Edge aligned

	// Set PWM duty
	PCA_CH0_SetValue_L(0); 				
	PCA_CH0_SetValue_9thBit_L_0();		// 9th bit
	PCA_CH0_SetValue_H(0);				// Reload value
	PCA_CH0_SetValue_9thBit_H_0();		// 9th bit

	PCA_CH1_SetValue_L(0); 				
	PCA_CH1_SetValue_9thBit_L_0();		// 9th bit
	PCA_CH1_SetValue_H(0);				// Reload value
	PCA_CH1_SetValue_9thBit_H_0();		// 9th bit

	PCA_CH2_SetValue_L(0); 				
	PCA_CH2_SetValue_9thBit_L_0();		// 9th bit
	PCA_CH2_SetValue_H(0);				// Reload value
	PCA_CH2_SetValue_9thBit_H_0();		// 9th bit

	PCA_CH3_SetValue_L(0); 				
	PCA_CH3_SetValue_9thBit_L_0();		// 9th bit
	PCA_CH3_SetValue_H(0);				// Reload value
	PCA_CH3_SetValue_9thBit_H_0();		// 9th bit

	// Set counter
	PCA_SetCounter(0);
	PCA_SetCounterReload(0);

	// Disable PWM output
	PCA_SetPWM0_DisOutput();					
	PCA_SetPWM1_DisOutput();
	PCA_SetPWM2_DisOutput();					
	PCA_SetPWM3_DisOutput();

	PCA_SetCEX0CEX1CEX2CEX3_P30P33P31P46();			// Set CEX0/CEX1/CEX2/CEX3 pin: P30P33P31P46

	PCA_CF_DisInterrupt();							// Disable CF interrupt

	PCA_EnPCACounter();								// Enable PCA counter, 
}

/***********************************************************************************
*Function:   void InitClock(void)
*Description:   Initialize clock	
*Input:   
*Output:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==8000000)
	// Default: IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
#endif

#if (MCU_SYSCLK==11059200)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK/2
	CLK_SelIHRCO_22118400Hz();
#endif
	
#if (MCU_SYSCLK==16000000)
	// IHRCO=16MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif

#if (MCU_SYSCLK==22118400)
	// IHRCO=22.12MHz, OSCin=IHRCO,MCK=OSCin,MCKDO=MCK
	CLK_SelIHRCO_22118400Hz();
	CLK_SetCKCON3(WDTCS_ILRCO|FWKP_NORMAL_120uS|MCKDO_MCK_DIV_1);
#endif
	

#if (MCU_CPUCLK==MCU_SYSCLK)
	CLK_SetCpuclk_Sysclk();
#else
	CLK_SetCpuclk_SysclkDiv2();
#endif

	// P45 ouput MCK/4
	//CLK_P45OC_MCKDiv4();
}

/***********************************************************************************
*Function:   void InitSystem(void)
*Description:   Initialize MCU
*Input:   
*Output:     
*************************************************************************************/
void InitSystem(void)
{
	InitClock();
	InitPort();
	InitPCA_PWM();
}


void main()
{
	u8 cnt,inx;
	bit bOutFlag;

    InitSystem();

	LED_G_0=0;LED_R=0;LED_G_0=0;
	DelayXms(1000);
	LED_G_0=1;LED_R=1;LED_G_1=1;

	wDuty[0].W=0x0000;
	wDuty[1].W=0x0000;
	wDuty[2].W=0x0000;
	wDuty[3].W=0x0000;
	bOutFlag=FALSE;
	
	while(1)
    {
    	DelayXms(1);
    	cnt++;
    	if(cnt>=200)
    	{
			cnt=0;
	    	if(bOutFlag==TRUE)
			{
		   		inx++;
		    	if(inx>=8)
				{
					inx=0;
				}
		    	switch(inx)
				{
					case 0:
						// Duty 100%, ALL High
						wDuty[0].W=0x0000;
						wDuty[1].W=0x0000;
						wDuty[2].W=0x0000;
						wDuty[3].W=0x0000;
						break;

					case 1:
						// Duty 75% 	
						wDuty[0].W=0x0040;
						wDuty[1].W=0x0040;
						wDuty[2].W=0x0040;
						wDuty[3].W=0x0040;
						break;

					case 2:
						// Duty 50% 	
						wDuty[0].W=0x0080;
						wDuty[1].W=0x0080;
						wDuty[2].W=0x0080;
						wDuty[3].W=0x0080;
						break;

					case 3:
						// Duty 25% 	
						wDuty[0].W=0x00C0;
						wDuty[1].W=0x00C0;
						wDuty[2].W=0x00C0;
						wDuty[3].W=0x00C0;
						break;
						
					case 4:
						// Duty 0%, ALL Low
						wDuty[0].W=0x0100;
						wDuty[1].W=0x0100;
						wDuty[2].W=0x0100;
						wDuty[3].W=0x0100;
						break;

					case 5:
						// Duty 25% 	
						wDuty[0].W=0x00C0;
						wDuty[1].W=0x00C0;
						wDuty[2].W=0x00C0;
						wDuty[3].W=0x00C0;
						break;

					case 6:
						// Duty 50% 	
						wDuty[0].W=0x0080;
						wDuty[1].W=0x0080;
						wDuty[2].W=0x0080;
						wDuty[3].W=0x0080;
						break;

					case 7:
						// Duty 75% 	
						wDuty[0].W=0x0040;
						wDuty[1].W=0x0040;
						wDuty[2].W=0x0040;
						wDuty[3].W=0x0040;
						break;
						
		    	}
				PCA_CH0_SetValue_8Bit(wDuty[0].B.BHigh,wDuty[0].B.BLow);
				PCA_CH1_SetValue_8Bit(wDuty[1].B.BHigh,wDuty[1].B.BLow);
				PCA_CH2_SetValue_8Bit(wDuty[2].B.BHigh,wDuty[2].B.BLow);
				PCA_CH3_SetValue_8Bit(wDuty[3].B.BHigh,wDuty[3].B.BLow);
	    	}
    	}
    	if(P10==1)
    	{
			if(bOutFlag==FALSE)
			{
				bOutFlag=TRUE;
				// Enable PWM output
				PCA_SetPWM0_EnOutput();					
				PCA_SetPWM1_EnOutput();
				PCA_SetPWM2_EnOutput();
				PCA_SetPWM3_EnOutput();
			}
    	}
    	else
    	{
			if(bOutFlag==TRUE)
			{
				bOutFlag=FALSE;
				// Disable PWM output
				PCA_SetPWM0_DisOutput();					
				PCA_SetPWM1_DisOutput();
				PCA_SetPWM2_DisOutput();
				PCA_SetPWM3_DisOutput();
			}
    	}
    }
}


