#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Delay function
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer4 overflow Interrupt(TH4) => TF4_Flag
Timer4 external Interrupt      => EXF4_Flag
Timer4 overflow Interrupt(TL4) => TF4L_Flag
****************************************************************/
uint8_t TF4_Flag, EXF4_Flag, TF4L_Flag;

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer4 interrupt (ET4) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER4_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P71 used for T4EX Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P7ModeSelect(P71_OpenDrainPullUp);

    /****************************************************************
     *  Timer4 Initialized
     *  1. Capture Source = T4EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER4_Capture_Source_Select(TIMER4_CAPTURE_SOURCE_T4EX_PIN);
    __DRV_TIMER4_Capture_Source_Dectect(Timer4_FALLING_EDGE);

    /****************************************************************
     *  Timer4 External Trigger
     *  Trigger source = T4EX Pin(P71)
     ****************************************************************/
    __DRV_GPIO_WriteP7(P71, 1);
    while (1)
    {
        __DRV_GPIO_WriteP7(P71, 0);
        if (EXF4_Flag == 1)
        {
            __DRV_GPIO_InversePinP5(P55);
            __DRV_GPIO_WriteP7(P71, 1);
            delay_ms(50);
            EXF4_Flag = 0;
        }
    }
}

/****************************************************************
Timer4 interrupt
The Timer4 has TF4, EXF4, TF4L flags to trigger the Timer4 interrupt.
****************************************************************/
void TIMER4_TF4_EXF4_TF4L_ISR(void) interrupt TIMER4_ISR_VECTOR
{
    if (DRV_TIMER4_GetTF4() == 1)
    {
        TF4_Flag = 1;
        DRV_TIMER4_ClearTF4();
    }

    if (DRV_TIMER4_GetTF4L() == 1)
    {
        TF4L_Flag = 1;
        DRV_TIMER4_ClearTF4L();
    }

    if (DRV_TIMER4_GetEXF4() == 1)
    {
        EXF4_Flag = 1;
        DRV_TIMER4_ClearEXF4();
    }
}
