#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
Variables
Timer3 overflow Interrupt(TH3) => TF3_Flag
Timer3 external Interrupt      => EXF3_Flag
Timer3 overflow Interrupt(TL3) => TF3L_Flag
****************************************************************/
uint8_t TF3_Flag, EXF3_Flag, TF3L_Flag;

void main()
{
    /****************************************************************
    Variables
    TF3_count(TH3)        => For time delay
    TF3L_count(TL3)       => For time delay
    ****************************************************************/
    uint16_t TF3_count = 0, TF3L_count = 0;

    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer3 interrupt (ET3) = Enable;
     *  2. Setting TL3IS and then open the TF3L interrupt (TL3IE) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER3_IT_Cmd(MW_ENABLE);
    __DRV_TIMER3_Function_Access_Control_Cmd(MW_ENABLE);
    __DRV_TIMER3_TF3L_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P56 used for LED_D5
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P56_PushPull | P55_PushPull);

    /****************************************************************
     *  Timer3 Initialized
     *  TF3 Interrupt time => (1 / (SYSCLK/12)) * 256 * 3906 � 1 S
     *  TF3L Interrupt time => (1 / (SYSCLK/12)) * 100 * 5000 � 0.5 S
     ****************************************************************/
    __DRV_TIMER3_Mode_Select(TIMER3_SPLIT_MODE3_TWO_8BIT_CAPTURE_WITH_AUTO_ZERO);
    __DRV_TIMER3_Clock_Source_Select(TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER3_SetLowByte(156);
    __DRV_TIMER3_SetRCAP3L(156);
    __DRV_TIMER_Globel_Enable_Cmd(TR3E | TR3LE);

    while (1)
    {
        if (TF3_Flag)
        {
            TF3_count += 1;
            if (TF3_count == 3906)
            {
                __DRV_GPIO_InversePinP5(P55);
                TF3_count = 0;
            }
            TF3_Flag = 0;
        }

        if (TF3L_Flag)
        {
            TF3L_count += 1;
            if (TF3L_count == 5000)
            {
                __DRV_GPIO_InversePinP5(P56);
                TF3L_count = 0;
            }
            TF3L_Flag = 0;
        }
    }
}

/****************************************************************
Timer3 interrupt
The Timer3 has TF3, EXF3, TF3L flags to trigger the Timer3 interrupt.
****************************************************************/
void TIMER3_TF3_EXF3_TF3L_ISR(void) interrupt TIMER3_ISR_VECTOR
{
    if (DRV_TIMER3_GetTF3() == 1)
    {
        TF3_Flag = 1;
        DRV_TIMER3_ClearTF3();
    }

    if (DRV_TIMER3_GetTF3L() == 1)
    {
        TF3L_Flag = 1;
        DRV_TIMER3_ClearTF3L();
    }

    if (DRV_TIMER3_GetEXF3() == 1)
    {
        EXF3_Flag = 1;
        DRV_TIMER3_ClearEXF3();
    }
}
