/**
 ******************************************************************************
 *
 * @file        MG82F6D64_SPI_MID.h
 *
 * @brief       This is the C code format driver file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.03
 * @date        2024/03/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer
 *		The Demo software is provided "AS IS"  without any warranty, either
 *		expressed or implied, including, but not limited to, the implied warranties
 *		of merchantability and fitness for a particular purpose.  The author will
 *		not be liable for any special, incidental, consequential or indirect
 *		damages due to loss of data or any other reason.
 *		These statements agree with the world wide and local dictated laws about
 *		authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#ifndef MG82F6D64_SPI_MID_H
#define MG82F6D64_SPI_MID_H








///@cond __DRV_SPI_Easy_Wizard_Init
typedef enum
    {
        SPI_SELECT0,
        SPI_SELECT1,
        SPI_SELECT2,
        SPI_SELECT3,
        SPI_SELECT4,
        SPI_SELECT5,
        SPI_SELECT6,
        SPI_SELECT7,
        SPI_SELECT8,
        SPI_SELECT9,
        SPI_SELECT10,
        SPI_SELECT11,
        SPI_SELECT12,
        SPI_SELECT13,
        SPI_SELECT14,
        SPI_SELECT15,
        SPI_SELECT16,
        SPI_SELECT17,
        SPI_SELECT18,
        SPI_SELECT19,
        SPI_SELECT20,
        SPI_SELECT21,
        SPI_SELECT22,
        SPI_SELECT23,
        SPI_SELECT24,
        SPI_SELECT25,
        SPI_SELECT26,
        SPI_SELECT27,
        SPI_SELECT28,
        SPI_SELECT29,
        SPI_SELECT30,
        SPI_SELECT31,
        SPI_SELECT32,
        SPI_SELECT33,
        SPI_SELECT34,
        SPI_SELECT35,
        SPI_SELECT36,
        SPI_SELECT37,
        SPI_SELECT38,
        SPI_SELECT39,
        SPI_SELECT40,
        SPI_SELECT41,
        SPI_SELECT42,
        SPI_SELECT43,
        SPI_SELECT44,
        SPI_SELECT45,
        SPI_SELECT46,
        SPI_SELECT47,
        SPI_SELECT48,
        SPI_SELECT49,
        SPI_SELECT50,
        SPI_SELECT51,
        SPI_SELECT52,
        SPI_SELECT53,
        SPI_SELECT54,
        SPI_SELECT55 = 55
    } SPI_SELECT;


///@endcond
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPEN SSIG MSTR
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @note         None
* @par          Example
* @code
                __DRV_SPI_Mode_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_SPI_Mode_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_SPI_EasySetSPEN(__SELECT__);\
        __DRV_SPI_EasySetSSIG(__SELECT__);\
        __DRV_SPI_EasySetMSTR(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPR2 SPR1 SPR0
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_Clock_Rate_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_Clock_Rate_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_SPI_EasySetSPR2(__SELECT__);\
        __DRV_SPI_EasySetSPR1(__SELECT__);\
        __DRV_SPI_EasySetSPR0(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set CPOL CPHA
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_Data_Mode_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_Data_Mode_Easy_Select(__SELECT__)\
        MWT(\
            __DRV_SPI_EasySetCPOL(__SELECT__);\
            __DRV_SPI_EasySetCPHA(__SELECT__);\
        ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set DORD
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_Data_Order_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_Data_Order_Easy_Select(__SELECT__)\
        MWT(\
            __DRV_SPI_EasySetDORD(__SELECT__);\
        ;)

/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPIPS1 SPIPS0
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_PinMux_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_PinMux_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_SPI_EasySetP1(__SELECT__);\
        __DRV_SPI_EasySetSPIPS1(__SELECT__);\
        __DRV_SPI_EasySetSPIPS0(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPI0M0 QPIEN
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT1 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT2 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT3 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT4 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT5 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT6 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT7 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT8 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT9 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT10 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT11 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT12 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT13 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT14 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT15 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT16 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT17 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT18 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT19 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT20 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT21 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT22 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT23 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT24 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT25 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT26 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT27 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,LSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT28 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT29 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT30 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT31 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT32 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT33 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT34 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT35 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=0 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT36 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT37 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT38 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT39 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT40 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT41 : Master by MSTR,MSTR=1 SSIG=1, CPOL=0 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT42 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=0,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT43 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT44 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT45 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT46 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT47 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT48 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=0,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT49 : Slave by nSS,nSS=0 MSTR=0 SSIG=0,CPOL=1 CPHA=1,clock rata by edge,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT50 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/4,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT51 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/8,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT52 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/16,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT53 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/32,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT54 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/64,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
*  @arg\b SPI_SELECT55 : Master by MSTR,MSTR=1 SSIG=1, CPOL=1 CPHA=1,clock rata by sysclk/2,MSB,nSS(p14) MOSI(SPID0)(p15) MISO(SPID1)(p16) SPICLK(p17) SPID2(p53) SPID3(p54),typical.
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_Connection_Easy_Select(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_Connection_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_SPI_EasySetSPI0M0(__SELECT__);\
        __DRV_SPI_EasySetQPIEN(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPEN
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPEN(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPEN(__SELECT__)\
    MWT(\
        ((__SELECT__^SPI_SELECT0)==0?(SPCON=SPCON|(SPEN)):(SPCON=SPCON|(SPEN)));\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SSIG
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSSIG(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSSIG(__SELECT__)\
    MWT(\
        ((__SELECT__%7)==0?(SPCON=SPCON&~(SSIG)):(SPCON=SPCON|(SSIG)));\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set MSTR
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetMSTR(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetMSTR(__SELECT__)\
    MWT(\
        ((__SELECT__%7)==0?(SPCON=SPCON&~(MSTR)):(SPCON=SPCON|(MSTR)));\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPR2
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPR2(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPR2(__SELECT__)\
    MWT(\
        ((__SELECT__%7)==0?(SPSTAT=SPSTAT&~(SPR2_QDOE)):\
        (__SELECT__%7)==1?(SPSTAT=SPSTAT&~(SPR2_QDOE)):\
        (__SELECT__%7)==2?(SPSTAT=SPSTAT&~(SPR2_QDOE)):\
        (__SELECT__%7)==3?(SPSTAT=SPSTAT&~(SPR2_QDOE)):\
        (__SELECT__%7)==4?(SPSTAT=SPSTAT&~(SPR2_QDOE)):\
        (__SELECT__%7)==5?(SPSTAT=SPSTAT|(SPR2_QDOE)):\
        (__SELECT__%7)==6?(SPSTAT=SPSTAT|(SPR2_QDOE)):_nop_());\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPR1
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPR1(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPR1(__SELECT__)\
    MWT(\
        ((__SELECT__%7)==0?(SPCON=SPCON&~(SPR1)):\
        (__SELECT__%7)==1?(SPCON=SPCON&~(SPR1)):\
        (__SELECT__%7)==2?(SPCON=SPCON&~(SPR1)):\
        (__SELECT__%7)==3?(SPCON=SPCON|(SPR1)):\
        (__SELECT__%7)==4?(SPCON=SPCON|(SPR1)):\
        (__SELECT__%7)==5?(SPCON=SPCON&~(SPR1)):\
        (__SELECT__%7)==6?(SPCON=SPCON&~(SPR1)):_nop_());\   
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPR0
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPR0(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPR0(__SELECT__)\
    MWT(\
        ((__SELECT__%7)==0?(SPCON=SPCON&~(SPR0)):\
        (__SELECT__%7)==1?(SPCON=SPCON&~(SPR0)):\
        (__SELECT__%7)==2?(SPCON=SPCON|(SPR0)):\
        (__SELECT__%7)==3?(SPCON=SPCON&~(SPR0)):\
        (__SELECT__%7)==4?(SPCON=SPCON|(SPR0)):\
        (__SELECT__%7)==5?(SPCON=SPCON&~(SPR0)):\
        (__SELECT__%7)==6?(SPCON=SPCON|(SPR0)):_nop_());\ 
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set CPOL
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetCPOL(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetCPOL(__SELECT__)\
    MWT(\
        ((__SELECT__/14)==0?(SPCON=SPCON&~(CPOL)):\
        (__SELECT__/14)==1?(SPCON=SPCON|(CPOL)):\
        (__SELECT__/14)==2?(SPCON=SPCON&~(CPOL)):\
        (__SELECT__/14)==3?(SPCON=SPCON|(CPOL)):_nop_());\       
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set CPHA
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetCPHA(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetCPHA(__SELECT__)\
    MWT(\
        ((__SELECT__/7)==0?(SPCON=SPCON&~(CPHA)):\
        (__SELECT__/7)==1?(SPCON=SPCON|(CPHA)):\
        (__SELECT__/7)==2?(SPCON=SPCON&~(CPHA)):\
        (__SELECT__/7)==3?(SPCON=SPCON|(CPHA)):\
        (__SELECT__/7)==4?(SPCON=SPCON&~(CPHA)):\
        (__SELECT__/7)==5?(SPCON=SPCON|(CPHA)):\
        (__SELECT__/7)==6?(SPCON=SPCON&~(CPHA)):\
        (__SELECT__/7)==7?(SPCON=SPCON|(CPHA)):_nop_());\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set DORD
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetDORD(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetDORD(__SELECT__)\
    MWT(\
        ((__SELECT__/28)==0?(SPCON=SPCON|(DORD)):\
        (__SELECT__/28)==1?(SPCON=SPCON&~(DORD)):_nop_());\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set P1 Port Mode
* @param[in]    __SELECT__ :
*  @arg\b       SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetP1(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetP1(__SELECT__)\
    MWT(\
        if((__SELECT__%7)==0)\
            {\
                __DRV_SFR_PageIndex(P1M1_Page);\
                (P1M1=P1M1|(P1M14|P1M15|P1M17));\
                (P1M1=P1M1&~(P1M16));\
                __DRV_SFR_PageIndex(P1M0_Page);\
                (P1M0=P1M0|(P1M04|P1M05|P1M07));\
                (P1M0=P1M0|(P1M06));\
                __DRV_SFR_PageIndex(0);\
            }\
        else\
            {\
                __DRV_SFR_PageIndex(P1M1_Page);\
                (P1M1=P1M1&~(P1M14|P1M15|P1M17));\
                (P1M1=P1M1|(P1M16));\
                __DRV_SFR_PageIndex(P1M0_Page);\
                (P1M0=P1M0|(P1M04|P1M05|P1M07));\
                (P1M0=P1M0|(P1M06));\
                __DRV_SFR_PageIndex(0);\
            }\
    ;)    
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPIPS1
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                _DRV_SPI_EasySetSPIPS1(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPIPS1(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR10_Page);\
        ((__SELECT__^SPI_SELECT0)==0?(AUXR10=AUXR10&~(SPIPS1)):(AUXR10=AUXR10&~(SPIPS1)));\  
        __DRV_SFR_PageIndex(0);\
    ;)

/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPIPS0
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPIPS0(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPIPS0(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR10_Page);\
        ((__SELECT__^SPI_SELECT0)==0?(AUXR10=AUXR10&~(SPIPS0)):(AUXR10=AUXR10&~(SPIPS0)));\
        __DRV_SFR_PageIndex(0);\
    ;)

/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set SPI0M0
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPI0M0(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetSPI0M0(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR7_Page);\
        ((__SELECT__^SPI_SELECT0)==0?(AUXR7=AUXR7&~(SPI0M0)):(AUXR7=AUXR7&~(SPI0M0)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        SPI Easy Wizard
* @details      Set QPIEN
* @param[in]    __SELECT__ :
*  @arg\b SPI_SELECT0~SPI_SELECT55
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_SPI_EasySetSPI0M0(SPI_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_SPI_EasySetQPIEN(__SELECT__)\
    MWT(\
        ((__SELECT__^SPI_SELECT0)==0?(SPSTAT=SPSTAT&(~QPIEN)):(SPSTAT=SPSTAT&(~QPIEN)));\
    ;)

#endif  //MG82F6D64_SPI_MID_H




