/*********************************************************************
*    Ŀ:MG82F6D64-DEMO
*			԰ʹ MG82F6D64 LQFP64_V10 EV Board (TH210A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			ʹTWSI0 (SCL/P25, SDA/P23)ģʽ
*			ʹTWSI1 (SCL/P42, SDA/P43)ģʽ
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	33170000,36000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)


#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define TWI0_SCL		P25
#define TWI0_SDA		P23

#define TWI1_SCL		P42
#define TWI1_SDA		P43

#define SLAVE_ADDRESS_A0	0xA0
#define SLAVE_ADDRESS_B0	0xB0
#define TEST_BUF_SIZE	16

u8	TWI0OvTime;
u8	TWI1OvTime;

u8 rand;

WordTypeDef TWI0TestAddr;
WordTypeDef TWI1TestAddr;

bit bES0;
u8 LedTime;
xdata u8 WriteBuf[TEST_BUF_SIZE];
xdata u8 ReadBuf[TEST_BUF_SIZE];
u8 TestBufLen;

/***********************************************************************************
*:   void INT_T0(void)
*:T0 жϷ
*:   
*ز:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;
	if(TWI0OvTime!=0) TWI0OvTime--;
	if(TWI1OvTime!=0) TWI1OvTime--;
	if(LedTime!=0) LedTime--;
}

/***********************************************************************************
*:     void SendByte(u8 tByte)
*: ͨUARTһֽ
*: u8 tByte: ͵
*ز:
*************************************************************************************/
void SendByte(u8 tByte)
{
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
*: void SendStr(u8* PStr)
*: ַ
*: u8* PStr:ַʼַ
*ز:     
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
*:     void SendHex(u8 ToSend)
*: ַʽ16
*: u8 ToSend: ͵16  
*ز:     
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void InitUart0_S0BRG(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_57600_2X_12000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitTimer0(void)
*:Timer0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();			// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);						// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);					// T08λ

	TM_EnableT0();							// ʹT0
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);					// P55,P56,P57Ϊ(LED)
	PORT_SetP2OpenDrainPu(BIT3|BIT5);					// P23,P25Ϊ©(TWI0:SCL/SDA)
	PORT_SetP4OpenDrainPu(BIT2|BIT3);					// P42,P43Ϊ©(TWI1:SCL/SDA)
}

/***********************************************************************************
*:   void InitTWI0(void)
*: TWI0ʼ
*:   
*ز:     
*************************************************************************************/
void InitTWI0()
{
	TWI0_Clear();
	TWI0_SCL=0;
	TWI0_SDA=1;
	TWI0_SetClock(TWI0_CLK_SYSCLK_128);
	TWI0_SetSCLSDAP25P23();
	TWI0_SCL=1;
	TWI0_Enable();
}

/***********************************************************************************
*:   void InitTWI1(void)
*: TWI1ʼ
*:   
*ز:     
*************************************************************************************/
void InitTWI1()
{
	TWI1_Clear();
	TWI1_SCL=0;
	TWI1_SDA=1;
	TWI1_SetClock(TWI1_CLK_SYSCLK_128);
	TWI1_SetSCLSDAP42P43();
	TWI1_SCL=1;
	TWI1_Enable();
}

/***********************************************************************************
*:   void InitClock(void)
*:   ʱӳʼ	
*:   
*ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==36000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#else
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
*:   void InitInterrupt(void)
*:   жϳʼ
*:   
*ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnTIMER0();						// ʹT0ж
	INT_EnAll();						// ʹȫж
}	

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTWI0();
	InitTWI1();
	InitTimer0();
	InitUart0_S0BRG();
	InitInterrupt();
}

/***********************************************************************************
*:   u8 TWI0_WriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pByte,u8 Len)
*: ͨTWI0ݷ͵ӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻݵʼַ
*		u8 *pBuf: ݵĻַ
*		u8 Len: ͵ݸ
*ز:
*		u8: 0->ɹ, 1->NO ACK, 2-> Over time
*************************************************************************************/
u8 TWI0_WriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	u8 i;
	u8 Retval;
	Retval=1;

	SICON |=STA;						// START
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SICON &=~STA;

	SICON=SICON|(AA);	   

	SIDAT = DevAddr&0xFE;				// ַ 
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x18) goto TWI0_WRITE_NOACK;		// ûյACK

	SIDAT = HIBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI0_WRITE_NOACK;		// ûյACK

	SIDAT = LOBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI0_WRITE_NOACK;		// ûյACK

	i=0;
	while(i<Len)
	{
		if(i==(Len-1))
		{
			SICON=SICON&(~AA);	   
		}
		else
		{
			SICON=SICON|(AA);	   
		}
		SIDAT=pBuf[i];			// 
		TWI0OvTime=5;
		SICON &=~SI;			
		while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
		i++;
	}
	Retval = 0;
	
TWI0_WRITE_NOACK:

	SICON |= STO;				// STOP
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&STO)==STO){if(TWI0OvTime==0) goto TWI0_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SICON &=~STO;

	SICON = SICON &(~SI);		// жϱ־

	return Retval;
	
TWI0_WRITE_OVERTIME:
	SICON |= STO;				// STOP
	SICON = SICON &(~SI);		// жϱ־
	return 2;
}


/***********************************************************************************
*:   u8 TWI0_ReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
*:
*		ͨTWI0ȡӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻȡݵʼַ
*		u8 *pBuf: ȡݵĻַ
*		u8 Len: ȡݸ
*ز:
*		u8: 0->ɹ, 1->NO ACK, 2-> Over time
*************************************************************************************/
u8 TWI0_ReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	u8 i;
	u8 Retval;
	Retval=1;
	
	SICON |=STA;				// START
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SICON &=~STA;

	SICON=SICON|(AA);	   

	SIDAT = DevAddr&0xFE;		// ַ 
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x18) goto TWI0_READ_NOACK;			// ûյACK

	SIDAT = HIBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI0_READ_NOACK;			// ûյACK
	
	SIDAT = LOBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI0_READ_NOACK;			// ûյACK

	SICON |= STA;				// ٴηSTART
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SICON &=~STA;

	SIDAT = DevAddr|0x01;		// ַ ,ģʽ
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x40) goto TWI0_READ_NOACK;			// ûյACK
	
	i=0;
	while(i<Len)
	{
		if(i==(Len-1))
		{
			SICON=SICON&(~AA);	   
		}
		else
		{
			SICON=SICON|(AA);	   
		}
		TWI0OvTime=5;
		SICON &=~SI;			
		while((SICON&SI)!=SI){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
		pBuf[i] = SIDAT; 			// ȡ
		i++;
	}
	
	Retval=0;
	
TWI0_READ_NOACK:
	SICON |= STO;				// STOP
	TWI0OvTime=5;
	SICON &=~SI;			
	while((SICON&STO)==STO){if(TWI0OvTime==0) goto TWI0_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SICON &=~STO;

	SICON = SICON &(~SI);		// жϱ־

	return Retval;
	
TWI0_READ_OVERTIME:
	SICON |= STO;				// STOP
	SICON = SICON &(~SI);		// жϱ־
	return 2;
}

/***********************************************************************************
*:   u8 TWI1_WriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pByte,u8 Len)
*: ͨTWI1ݷ͵ӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻݵʼַ
*		u8 *pBuf: ݵĻַ
*		u8 Len: ͵ݸ
*ز:
*		u8: 0->ɹ, 1->NO ACK, 2-> Over time
*************************************************************************************/
u8 TWI1_WriteBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	u8 i;
	u8 Retval;
	Retval=1;

	SFR_SetPage(1);

	SI1CON |=STA1;						// START
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SI1CON &=~STA;

	SI1CON=SI1CON|(AA1);	   

	SI1DAT = DevAddr&0xFE;				// ַ 
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x18) goto TWI1_WRITE_NOACK;			// ûյACK
	
	SI1DAT = HIBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI1_WRITE_NOACK;			// ûյACK
	
	SI1DAT = LOBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI1_WRITE_NOACK;			// ûյACK

	i=0;
	while(i<Len)
	{
		if(i==(Len-1))
		{
			SI1CON=SI1CON&(~AA1);	   
		}
		else
		{
			SI1CON=SI1CON|(AA1);	   
		}
		SI1DAT=pBuf[i];					// 
		TWI1OvTime=5;
		SI1CON &=~SI1;			
		while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
		i++;
	}
	
	Retval=0;
	
TWI1_WRITE_NOACK:
	SI1CON |= STO1;						// STOP
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&STO1)==STO1){if(TWI1OvTime==0) goto TWI1_WRITE_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SI1CON &=~STO1;

	SI1CON = SI1CON &(~SI1);			// жϱ־
	SFR_SetPage(0);
	
	return Retval;

TWI1_WRITE_OVERTIME:
	SI1CON |= STO1;						// STOP
	SI1CON = SI1CON &(~SI1);			// жϱ־
	SFR_SetPage(0);
	return 2;

}


/***********************************************************************************
*:   u8 TWI1_ReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
*:
*		ͨTWI1ȡӻ
*: 
*		u8 DevAddr: ӻַ
*		u16 RegStartAddr: ӻȡݵʼַ
*		u8 *pBuf: ȡݵĻַ
*		u8 Len: ȡݸ
*ز:
*		u8: 0->ɹ, 1->NO ACK, 2-> Over time
*************************************************************************************/
u8 TWI1_ReadBuf(u8 DevAddr,u16 RegStartAddr,u8 *pBuf,u8 Len)
{
	u8 i;
	u8 Retval;
	Retval=1;

	SFR_SetPage(1);
	
	SI1CON |=STA1;				// START
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SI1CON &=~STA1;

	SI1CON=SI1CON|(AA1);	   

	SI1DAT = DevAddr&0xFE;		// ַ 
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x18) goto TWI1_READ_NOACK;			// ûյACK

	SI1DAT = HIBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI1_READ_NOACK;			// ûյACK

	SI1DAT = LOBYTE(RegStartAddr);		// ͵ַ 8λ
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x28) goto TWI1_READ_NOACK;			// ûյACK
	
	SI1CON |= STA1;				// ٴηSTART
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SI1CON &=~STA1;

	SI1DAT = DevAddr|0x01;		// ַ ,ģʽ
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ

	if(SISTA != 0x40) goto TWI1_READ_NOACK;			// ûյACK
	
	i=0;
	while(i<Len)
	{
		if(i==(Len-1))
		{
			SI1CON=SI1CON&(~AA1);	   
		}
		else
		{
			SI1CON=SI1CON|(AA1);	   
		}
		TWI1OvTime=5;
		SI1CON &=~SI1;			
		while((SI1CON&SI1)!=SI1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
		pBuf[i] = SI1DAT; 			// ȡ
		i++;
	}
	
	Retval=0;
	
TWI1_READ_NOACK:
	SI1CON |= STO1;				// STOP
	TWI1OvTime=5;
	SI1CON &=~SI1;			
	while((SI1CON&STO1)==STO1){if(TWI1OvTime==0) goto TWI1_READ_OVERTIME;}		// ȴ, ʱ򷵻ʧֵ
	SI1CON &=~STO1;

	SI1CON = SI1CON &(~SI1);		// жϱ־
	SFR_SetPage(0);
	return Retval;
	
TWI1_READ_OVERTIME:
	SI1CON |= STO1; 					// STOP
	SI1CON = SI1CON &(~SI1);			// жϱ־
	SFR_SetPage(0);
	return 2;
}


void TWI0_TestProc(void)
{
	u8 S0Ret;
	u8 i;
	
	SendStr("\nTWI0 Test ");
	SendHex(TWI0TestAddr.B.BHigh);
	SendHex(TWI0TestAddr.B.BLow);
	
	for(i=0;i<TEST_BUF_SIZE;i++)
	{
		WriteBuf[i]=0x78+i+rand;
	}
	
	S0Ret=TWI0_WriteBuf(SLAVE_ADDRESS_A0, TWI0TestAddr.W, &WriteBuf[0],TEST_BUF_SIZE);
	if(S0Ret==0)
	{
		DelayXms(5); // EEPROM дʱ
		S0Ret=TWI0_ReadBuf(SLAVE_ADDRESS_A0,TWI0TestAddr.W,&ReadBuf[0],TEST_BUF_SIZE);
		if(S0Ret==0)
		{
			for(i=0;i<TEST_BUF_SIZE;i++)
			{
				if(WriteBuf[i] != ReadBuf[i]) break;
			}
			if(i<TEST_BUF_SIZE)
			{
				SendStr("...Err--Verify:");
				SendHex(i);
				SendByte(0x20);
				SendHex(WriteBuf[i]);
				SendByte(0x20);
				SendHex(ReadBuf[i]);
			}
			else
			{
				LED_G_0=0;
				SendStr("...SUCCESS!");
				DelayXms(50);
				LED_G_0=1;
			}
		}
		else
		{
			SendStr("...Err--R:");
			SendHex(S0Ret);
		}
	}
	else
	{
		SendStr("...Err--W:");
		SendHex(S0Ret);
	}
	if(S0Ret>=2)
	{
		// ,TWI0
		InitTWI0();
	
	}
	TWI0TestAddr.W=TWI0TestAddr.W+TEST_BUF_SIZE;
	if(TWI0TestAddr.W>=0x1000)
	{
		TWI0TestAddr.W=0;
	}
}

void TWI1_TestProc(void)
{
	u8 S0Ret;
	u8 i;
	
	SendStr("\nTWI1 Test ");
	SendHex(TWI1TestAddr.B.BHigh);
	SendHex(TWI1TestAddr.B.BLow);
	
	for(i=0;i<TEST_BUF_SIZE;i++)
	{
		WriteBuf[i]=0x78+i+rand;
	}
	
	S0Ret=TWI1_WriteBuf(SLAVE_ADDRESS_A0, TWI1TestAddr.W, &WriteBuf[0],TEST_BUF_SIZE);
	if(S0Ret==0)
	{
		DelayXms(5); // EEPROM дʱ
		S0Ret=TWI1_ReadBuf(SLAVE_ADDRESS_A0,TWI1TestAddr.W,&ReadBuf[0],TEST_BUF_SIZE);
		if(S0Ret==0)
		{
			for(i=0;i<TEST_BUF_SIZE;i++)
			{
				if(WriteBuf[i] != ReadBuf[i]) break;
			}
			if(i<TEST_BUF_SIZE)
			{
				SendStr("...Err--Verify:");
				SendHex(i);
				SendByte(0x20);
				SendHex(WriteBuf[i]);
				SendByte(0x20);
				SendHex(ReadBuf[i]);
			}
			else
			{
				LED_G_1=0;
				SendStr("...SUCCESS!");
				DelayXms(50);
				LED_G_1=1;
			}
		}
		else
		{
			SendStr("...Err--R:");
			SendHex(S0Ret);
		}
	}
	else
	{
		SendStr("...Err--W:");
		SendHex(S0Ret);
	}
	if(S0Ret>=2)
	{
		// ,TWI1
		InitTWI1();
	}
	TWI1TestAddr.W=TWI1TestAddr.W+TEST_BUF_SIZE;
	if(TWI1TestAddr.W>=0x1000)
	{
		TWI1TestAddr.W=0;
	}
}


void main()
{
	
    InitSystem();
	
 	SendStr("\nStart");
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;

	rand = 0x00;
	TWI0TestAddr.W=0x0000;
	TWI1TestAddr.W=0x0000;

    while(1)
    {
		rand++;
    	if(LedTime==0)
    	{
			LED_R = ~LED_R;
			LedTime=200;
			TWI0_TestProc();
			TWI1_TestProc();
		}
    }
}


