/*********************************************************************
*    Ŀ:MG82F6D64-DEMO
*			԰ʹ MG82F6D64 LQFP64_V10 EV Board (TH210A)
*			CpuCLK=12MHz, SysCLK=12MHz
*	
*			ͨڲIVR1.4v,P10ѹ
*	ע
*
*    ʱ:
*    ޸־:
*    
*********************************************************************/

#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
*ϵͳʱSysClk (MAX.50MHz)
*ѡ: 
*	11059200,12000000,
*	22118400,24000000,
*	29491200,32000000,
*	33170000,36000000,
*	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
*CPUʱ CpuClk (MAX.36MHz)
*	1) CpuCLK=SysCLK
*	2) CpuClk=SysClk/2
*************************************************/

#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

/*************************************************
*: char putchar (char c)   
*: printf Ĵ
*:     char c
*ز:     
*************************************************/
char putchar (char c)   
{      
	bit bES;
	bES=ES0;
    ES0=0;        
    S0BUF = c;        
    while(TI0==0);        
    TI0=0;        
    ES0=bES;        
    return 0;
}

/*************************************************
*:     void DelayXus(u16 xUs)
*:   	ʱ򣬵λΪus
*:     u8 Us -> *1us  (1~255)
*ز:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
*:     void DelayXms(u16 xMs)
*:     ʱ򣬵λΪms
*:     u16 xMs -> *1ms  (1~65535)
*ز:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
*:   void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
*:дPҳ⹦
*:   
*		 u8 PsfrAddr: Pҳַ
*		 u8 PsfrData: Pҳ
*ز:     
*************************************************************************************/
void IAP_WritePPage(u8 PsfrAddr,u8 PsfrData)
{
	bit bEA=EA;
	EA = 0; 					//ж
	IFADRH = 0; 				//IFADRHΪ0
	IFADRL= PsfrAddr;			//Pҳַ;
	IFD= PsfrData;				//Pҳ
	IFMT = ISP_WRITE_P;
	ISPCR = 0x80;				//õȴʱ, ISP/IAP
	SCMD = 0x46;
	SCMD = 0xB9;
	nop();
	IFMT=0;
	ISPCR = 0;					//ISP/IAPĴֹ
	EA = bEA;					//ָж
}

/***********************************************************************************
*:   void InitUart0(void)
*:   Uart0ʼ ʹS0BRGΪԴ
*:   
*ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();
	// Sets B.R. value
	UART0_SetS0BRGValue(S0BRG_BRGRL_9600_2X_12000000_1T);

	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
*:   void InitPort(void)
*:   IO
*:   
*ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);		//  P55,P56,P57Ϊ(LED)
	PORT_SetP1AInputOnly(BIT0);				// P10(AIN0)Ϊģ
}

/***********************************************************************************
*:   void InitADC(void)
*:   ADCʼ
*:   
*ز:     
*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();						// ʹADC
	ADC_SetClock_SYSCLK();			    // ADCתʱΪ SYSCLK       ת= 12M/30=600K
	ADC_SetMode_SetADCS();				// ADCģʽ, ADCS
	ADC_SetADCData_12Bit();				// ADCλΪ12λ			
	ADC_SetRightJustified();			// ADCתҶ

	IAP_WritePPage(PCON3_P,IVREN_P);	// ʹڲIVR 1.4V
}

/***********************************************************************************
*:   u16 GetAdcData()
*:   ȡdǰͨADCֵ
*:   
*ز:   u16 :ADCֵ
*************************************************************************************/
u16 GetAdcValue()
{
	WordTypeDef wAdcValue;
	ADCON0 = ADCON0|ADCS;				// λADCS,ADC
    while((ADCON0&ADCI)==0);            // ȴת
    wAdcValue.B.BHigh=ADCDH;
    wAdcValue.B.BLow=ADCDL;
 	ADCON0 = ADCON0&(~ADCI);		            //ADCI
 	return wAdcValue.W&0x0FFF;
}

/***********************************************************************************
*:   void InitSystem(void)
*:   ϵͳʼ
*:   
*ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitUart0_S0BRG();
	InitADC();
}

void main()
{
	u16 wADCValue;
	u32 dwTemp0,dwTemp1;
	
    InitSystem();
	
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;

    while(1)
    {
		DelayXms(500);
		LED_R = !LED_R;

		ADC_SetChannel_IVR14();		// ADCͨΪIVR 1.4V
		dwTemp0=GetAdcValue();		// ȡڲIVR 1.4V ADCֵ
		
		ADC_SetChannel_AIN0();		// ADCͨΪAIN0
		dwTemp1=GetAdcValue();		// ȡP10(AIN0) ADCֵ
		// P10(AIN0) ѹֵ
		wADCValue=(dwTemp1*1400L)/dwTemp0;
		// 
		printf("\nP10 V:%d",wADCValue);
    }
}


