/**
 ******************************************************************************
 *
 * @file        MG82F6D64_UART1_MID.h
 *
 * @brief       This is the C code format driver file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.13
 * @date        2024/03/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IS"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#ifndef MG82F6D64_UART1_MID_H
#define MG82F6D64_UART1_MID_H




///@cond __DRV_URT1_Easy_Wizard_Init

typedef enum
    {
        UART1_SELECT0,
        UART1_SELECT1,
        UART1_SELECT2,
        UART1_SELECT3,
        UART1_SELECT4,
        UART1_SELECT5,
        UART1_SELECT6,
        UART1_SELECT7,
        UART1_SELECT8,
        UART1_SELECT9,
        UART1_SELECT10,
        UART1_SELECT11,
        UART1_SELECT12,
        UART1_SELECT13,
        UART1_SELECT14,
        UART1_SELECT15,
        UART1_SELECT16,
        UART1_SELECT17,
        UART1_SELECT18,
        UART1_SELECT19,
        UART1_SELECT20,
        UART1_SELECT21,
        UART1_SELECT22,
        UART1_SELECT23,
        UART1_SELECT24,
        UART1_SELECT25,
        UART1_SELECT26,
        UART1_SELECT27,
        UART1_SELECT28,
        UART1_SELECT29,
        UART1_SELECT30,
        UART1_SELECT31,
        UART1_SELECT32,
        UART1_SELECT33,
        UART1_SELECT34,
        UART1_SELECT35,
        UART1_SELECT36,
        UART1_SELECT37,
        UART1_SELECT38,
        UART1_SELECT39,
        UART1_SELECT40,
        UART1_SELECT41,
        UART1_SELECT42,
        UART1_SELECT43,
        UART1_SELECT44,
        UART1_SELECT45,
        UART1_SELECT46,
        UART1_SELECT47,
        UART1_SELECT48,
        UART1_SELECT49,
        UART1_SELECT50,
        UART1_SELECT51,
        UART1_SELECT52,
        UART1_SELECT53,
        UART1_SELECT54,
        UART1_SELECT55,
        UART1_SELECT56,
        UART1_SELECT57,
        UART1_SELECT58,
        UART1_SELECT59,
        UART1_SELECT60,
        UART1_SELECT61,
        UART1_SELECT62,
        UART1_SELECT63,
        UART1_SELECT64,
        UART1_SELECT65,
        UART1_SELECT66,
        UART1_SELECT67,
        UART1_SELECT68,
        UART1_SELECT69,
        UART1_SELECT70,
        UART1_SELECT71,
        UART1_SELECT72,
        UART1_SELECT73 = 73
    } UART1_SELECT;
///@endcond




/**
*******************************************************************************
* @brief        UART1 Easy Wizard
* @details      Set SM31 SM01 SM11 S1DOR S1MOD1
* @param[in]    __SELECT__ :
*  @arg\b      UART1_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
* @return      None
* @note        None
* @par         Example
* @code
               __DRV_URT1_Mode_Easy_Select(UART1_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_URT1_Mode_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT1_EasySetSM31(__SELECT__);\
        __DRV_URT1_EasySetSM01(__SELECT__);\
        __DRV_URT1_EasySetSM11(__SELECT__);\
        __DRV_URT1_EasySetS1DOR(__SELECT__);\
        __DRV_URT1_EasySetS1MOD1(__SELECT__);\
    ;)

/**
*******************************************************************************
* @brief       UART1 Easy Wizard
* @details     Set S1TR S1BRT S1BRC
* @param[in]    __SELECT__ :
*  @arg\b      UART1_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
* @note        None
* @par         Example
* @code
               __DRV_URT1_BaudRate_Easy_Select(UART1_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT1_BaudRate_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT1_EasySetS1TR_Stop(__SELECT__);\
        __DRV_URT1_EasySetS1TX12(__SELECT__);\
        __DRV_URT1_EasySetS1BRT(__SELECT__);\
        __DRV_URT1_EasySetS1BRC(__SELECT__);\
        __DRV_URT1_EasySetS1TR_Start(__SELECT__);\
     ;)

/**
*******************************************************************************
* @brief       UART1 PinMux Easy Wizard
* @details     Set S1PS0 S1PS1
* @param[in]    __SELECT__ :
*  @arg\b      UART1_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
*  @arg\b      UART1_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S1BRG
* @return      None
* @note        None
* @par         Example
* @code
               __DRV_URT1_PinMux_Easy_Select(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_PinMux_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT1_EasySetS1PS1(__SELECT__);\
        __DRV_URT1_EasySetS1PS0(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Serial Reception
* @details      Set REN1
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasyEnableSerialReception(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasyEnableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CON_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(REN1=1):(REN1=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Serial Reception
* @details      Clear REN1
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasyDisableSerialReception(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasyDisableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CON_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(REN1=0):(REN1=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Mode Select
* @details      Set SM31
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetSM31(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetSM31(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(S1CFG=S1CFG&~(SM31)):(S1CFG=S1CFG&~(SM31)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Mode Select
* @details      Set SM01
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetSM01(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetSM01(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CON_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(SM01=0):(SM01=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Mode Select
* @details      Set SM11
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetSM11(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetSM11(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CON_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(SM11=1):(SM11=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 S1BRG Clock Source
* @details      Set S1TX12
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1TX12(UART1_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT1_EasySetS1TX12(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(S1CFG=S1CFG|(S1TX12)):(S1CFG=S1CFG|(S1TX12)));\
        __DRV_SFR_PageIndex(0);\
    ;)

/**
*******************************************************************************
* @brief        UART1 Data Order
* @details      Set S1DOR
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1DOR(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1DOR(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__%2)==0?(S1CFG=S1CFG|(S1DOR)):(S1CFG=S1CFG&~(S1DOR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Enhance Baud Rate
* @details      Set S1MOD1
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73

* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1MOD1(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1MOD1(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(S1CFG=S1CFG|(S1MOD1)):(S1CFG=S1CFG|(S1MOD1)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1  Baud Rate Generator Reload Register
* @details      Write S1BRT
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1BRT(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
///@cond __DRV_URT1_EasySetS1BRT

#define S1BRG_BRGRL_9600_2X_12000000_1T             0xB2        // 0.16%
#define S1BRG_BRGRL_19200_2X_12000000_1T            0xD9        // 0.16%
#define S1BRG_BRGRL_57600_2X_12000000_1T            0xF3        // 0.16%

#define S1BRG_BRGRL_9600_2X_11059200_1T             0xB8        // 0%
#define S1BRG_BRGRL_19200_2X_11059200_1T            0xDC        // 0%
#define S1BRG_BRGRL_57600_2X_11059200_1T            0xF4        // 0%
#define S1BRG_BRGRL_115200_2X_11059200_1T           0xFA        // 0%

#define S1BRG_BRGRL_9600_2X_24000000_1T             0x64        // 0.16%
#define S1BRG_BRGRL_19200_2X_24000000_1T            0xB2        // 0.16%
#define S1BRG_BRGRL_57600_2X_24000000_1T            0xE6        // 0.16%
#define S1BRG_BRGRL_115200_2X_24000000_1T           0xF3        // 0.16%

#define S1BRG_BRGRL_9600_2X_22118400_1T             0x70        // 0%
#define S1BRG_BRGRL_19200_2X_22118400_1T            0xB8        // 0%
#define S1BRG_BRGRL_57600_2X_22118400_1T            0xE8        // 0%
#define S1BRG_BRGRL_115200_2X_22118400_1T           0xF4        // 0%

#define S1BRG_BRGRL_9600_2X_29491200_1T             0x40        // 0%
#define S1BRG_BRGRL_19200_2X_29491200_1T            0xA0        // 0%
#define S1BRG_BRGRL_57600_2X_29491200_1T            0xE0        // 0%
#define S1BRG_BRGRL_115200_2X_29491200_1T           0xF0        // 0%

#define S1BRG_BRGRL_9600_2X_33177600_1T             0x28        // 0%
#define S1BRG_BRGRL_19200_2X_33177600_1T            0x94        // 0%
#define S1BRG_BRGRL_57600_2X_33177600_1T            0xDC        // 0%
#define S1BRG_BRGRL_115200_2X_33177600_1T           0xEE        // 0%

#define S1BRG_BRGRL_9600_2X_32000000_1T             0x30        // 0.16%
#define S1BRG_BRGRL_19200_2X_32000000_1T            0x98        // 0.16%
#define S1BRG_BRGRL_57600_2X_32000000_1T            0xDE        // 2.21%
#define S1BRG_BRGRL_115200_2X_32000000_1T           0xEF        // 2.21%

#define S1BRG_BRGRL_9600_2X_36000000_1T             0x16        // 0.16%
#define S1BRG_BRGRL_19200_2X_36000000_1T            0x8B        // 0.16%
#define S1BRG_BRGRL_57600_2X_36000000_1T            0xD9        // 0.16%
#define S1BRG_BRGRL_115200_2X_36000000_1T           0xEC        // -2.3%

#define S1BRG_BRGRL_19200_2X_44236800_1T            0x70        // 0%
#define S1BRG_BRGRL_57600_2X_44236800_1T            0xD0        // 0%
#define S1BRG_BRGRL_115200_2X_44236800_1T           0xE8        // 0%

#define S1BRG_BRGRL_19200_2X_48000000_1T            0x64        // 0.16%
#define S1BRG_BRGRL_57600_2X_48000000_1T            0xCC        // 0.16%
#define S1BRG_BRGRL_115200_2X_48000000_1T           0xE6        // 0.16%

///@endcond

#define __DRV_URT1_EasySetS1BRT(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1BRT_Page);\
        ((__SELECT__/2)==0?(S1BRT=S1BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S1BRT=S1BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S1BRT=S1BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S1BRT=S1BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S1BRT=S1BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S1BRT=S1BRG_BRGRL_19200_2X_11059200_1T):\
        (__SELECT__/2)==6?(S1BRT=S1BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S1BRT=S1BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S1BRT=S1BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S1BRT=S1BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S1BRT=S1BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S1BRT=S1BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S1BRT=S1BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S1BRT=S1BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S1BRT=S1BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S1BRT=S1BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S1BRT=S1BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S1BRT=S1BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S1BRT=S1BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S1BRT=S1BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S1BRT=S1BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S1BRT=S1BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S1BRT=S1BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S1BRT=S1BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S1BRT=S1BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S1BRT=S1BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S1BRT=S1BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S1BRT=S1BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S1BRT=S1BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S1BRT=S1BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S1BRT=S1BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S1BRT=S1BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S1BRT=S1BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S1BRT=S1BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S1BRT=S1BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S1BRT=S1BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S1BRT=S1BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
    ;)


/**
*******************************************************************************
* @brief        UART1  Baud Rate Generator Reload Register
* @details      Write S1BRC
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1BRC(UART1_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT1_EasySetS1BRC(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1BRC_Page);\
        ((__SELECT__/2)==0?(S1BRC=S1BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S1BRC=S1BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S1BRC=S1BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S1BRC=S1BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S1BRC=S1BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S1BRC=S1BRG_BRGRL_57600_2X_11059200_1T):\
        (__SELECT__/2)==6?(S1BRC=S1BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S1BRC=S1BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S1BRC=S1BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S1BRC=S1BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S1BRC=S1BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S1BRC=S1BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S1BRC=S1BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S1BRC=S1BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S1BRC=S1BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S1BRC=S1BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S1BRC=S1BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S1BRC=S1BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S1BRC=S1BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S1BRC=S1BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S1BRC=S1BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S1BRC=S1BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S1BRC=S1BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S1BRC=S1BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S1BRC=S1BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S1BRC=S1BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S1BRC=S1BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S1BRC=S1BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S1BRC=S1BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S1BRC=S1BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S1BRC=S1BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S1BRC=S1BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S1BRC=S1BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S1BRC=S1BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S1BRC=S1BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S1BRC=S1BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S1BRC=S1BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
     ;)



/**
*******************************************************************************
* @brief        UART1 S1BRG Operation Enable
* @details      Set S1TR
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1TR_Start(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1TR_Start(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(S1CFG=S1CFG|(S1TR)):(S1CFG=S1CFG|(S1TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 S1BRG Operation Disable
* @details      Set S1TR
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1TR_Stop(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1TR_Stop(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S1CFG_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(S1CFG=S1CFG&~(S1TR)):(S1CFG=S1CFG&~(S1TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Pin Config
* @details      Set S1PS1
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1PS0(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1PS0(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR9_Page);\
        ((__SELECT__^UART1_SELECT0)==0?(AUXR9=AUXR9|(S1PS0)):(AUXR9=AUXR9|(S1PS0)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART1 Pin Config
* @details      Set S1PS1
* @param[in]    __SELECT__ :
*  @arg\b       UART1_SELECT0~UART1_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT1_EasySetS1PS1(UART1_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT1_EasySetS1PS1(__SELECT__)\
    MWT(\
         __DRV_SFR_PageIndex(AUXR9_Page);\
         ((__SELECT__^UART1_SELECT0)==0?(AUXR9=AUXR9|(S1PS1)):(AUXR9=AUXR9|(S1PS1)));\
         __DRV_SFR_PageIndex(0);\
     ;)









#endif  //MG82F6D64_UART1_MID_H



