#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

uint8_t TF0_Flag;

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer0 interrupt (ET0) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER0_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer0 Initialized
     *  Interrupt time => (1/ILRCO * 65536) = 2.048 S
     ****************************************************************/
    __DRV_TIMER0_Mode_Select(TIMER0_MODE1_16BIT_TIMER);
    __DRV_TIMER0_Clock_Source_Select(TIMER0_CLOCK_SOURCE_ILRCO);
    __DRV_TIMER0_Run_Cmd(MW_ENABLE);

    while (1)
    {
        if (TF0_Flag)
        {
            __DRV_GPIO_InversePinP5(P55);
            TF0_Flag = 0;
        }
    }
}

/****************************************************************
Timer0 interrupt
Timer0 interrupt flag (TF0) is cleared by hardware interrupt.
****************************************************************/
void TIMER0_TF0_ISR(void) interrupt TIMER0_ISR_VECTOR
{
    TF0_Flag = 1;
}

