#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P34 used for T0CKO
     *  2. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P3ModeSelect(P34_PushPull);
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer0 Initialized
     *  PWM Duty high = 90.2% (230/255)
     *  PWM Duty low = 9.8% (25/255)
     ****************************************************************/
    __DRV_TIMER0_Mode_Select(TIMER0_MODE0_8BIT_PWM);
    __DRV_TIMER0_Clock_Source_Select(TIMER0_CLOCK_SOURCE_ILRCO);
    __DRV_TIMER0_SetHighByte(25);
    __DRV_TIMER0_T0CKO_Cmd(MW_ENABLE);
    __DRV_TIMER0_Run_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  PWM Output signal(T0CKO) to P55(LED_D4)
         ****************************************************************/
        __DRV_GPIO_WriteP5(P55, P34);
    }
}
