#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. Port 5 used for I/O toggle.
     *  2. Port 6 used for I/O toggle.
     *  3. Port 7 used for I/O toggle.
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P5ALL_PushPull);
    __DRV_GPIO_P6ModeSelect(P6ALL_PushPull);
    __DRV_GPIO_P7ModeSelect(P7ALL_PushPull);

    while (1)
    {
        /****************************************************************
         *  Port toggle
         *  1. Inverse Port5?Port6?Port7 every 300ms.
         ****************************************************************/
        __DRV_GPIO_InversePinP5(P5);
        __DRV_GPIO_InversePinP6(P6);
        __DRV_GPIO_InversePinP7(P7);
        delay_ms(300);
    }
}
