/**
 ******************************************************************************
 *
 * @file        MG82F6D64_UART3_MID.h
 *
 * @brief       This is the C code format driver file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.03
 * @date        2024/03/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *          The Demo software is provided "AS IS"  without any warranty, either
 *          expressed or implied, including, but not limited to, the implied warranties
 *          of merchantability and fitness for a particular purpose.  The author will
 *          not be liable for any special, incidental, consequential or indirect
 *          damages due to loss of data or any other reason.
 *          These statements agree with the world wide and local dictated laws about
 *          authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#ifndef MG82F6D64_UART3_MID_H
#define MG82F6D64_UART3_MID_H





///@cond __DRV_URT3_Easy_Wizard_Init

typedef enum
    {
        UART3_SELECT0,
        UART3_SELECT1,
        UART3_SELECT2,
        UART3_SELECT3,
        UART3_SELECT4,
        UART3_SELECT5,
        UART3_SELECT6,
        UART3_SELECT7,
        UART3_SELECT8,
        UART3_SELECT9,
        UART3_SELECT10,
        UART3_SELECT11,
        UART3_SELECT12,
        UART3_SELECT13,
        UART3_SELECT14,
        UART3_SELECT15,
        UART3_SELECT16,
        UART3_SELECT17,
        UART3_SELECT18,
        UART3_SELECT19,
        UART3_SELECT20,
        UART3_SELECT21,
        UART3_SELECT22,
        UART3_SELECT23,
        UART3_SELECT24,
        UART3_SELECT25,
        UART3_SELECT26,
        UART3_SELECT27,
        UART3_SELECT28,
        UART3_SELECT29,
        UART3_SELECT30,
        UART3_SELECT31,
        UART3_SELECT32,
        UART3_SELECT33,
        UART3_SELECT34,
        UART3_SELECT35,
        UART3_SELECT36,
        UART3_SELECT37,
        UART3_SELECT38,
        UART3_SELECT39,
        UART3_SELECT40,
        UART3_SELECT41,
        UART3_SELECT42,
        UART3_SELECT43,
        UART3_SELECT44,
        UART3_SELECT45,
        UART3_SELECT46,
        UART3_SELECT47,
        UART3_SELECT48,
        UART3_SELECT49,
        UART3_SELECT50,
        UART3_SELECT51,
        UART3_SELECT52,
        UART3_SELECT53,
        UART3_SELECT54,
        UART3_SELECT55,
        UART3_SELECT56,
        UART3_SELECT57,
        UART3_SELECT58,
        UART3_SELECT59,
        UART3_SELECT60,
        UART3_SELECT61,
        UART3_SELECT62,
        UART3_SELECT63,
        UART3_SELECT64,
        UART3_SELECT65,
        UART3_SELECT66,
        UART3_SELECT67,
        UART3_SELECT68,
        UART3_SELECT69,
        UART3_SELECT70,
        UART3_SELECT71,
        UART3_SELECT72,
        UART3_SELECT73 = 73
    } UART3_SELECT;

///@endcond




/**
*******************************************************************************
* @brief        UART3 Easy Wizard
* @details      Set SM33 SM03 SM13 S3DOR S3MOD1
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_Mode_Easy_Select(UART3_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_URT3_Mode_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT3_EasySetSM33(__SELECT__);\
        __DRV_URT3_EasySetSM03(__SELECT__);\
        __DRV_URT3_EasySetSM13(__SELECT__);\
        __DRV_URT3_EasySetS3DOR(__SELECT__);\
        __DRV_URT3_EasySetS3MOD1(__SELECT__);\
    ;)

/**
*******************************************************************************
* @brief        UART3 Easy Wizard
* @details      Set S3TR S3BRT S3BRC
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_BaudRate_Easy_Select(UART3_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT3_BaudRate_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT3_EasySetS3TR_Stop(__SELECT__);\
        __DRV_URT3_EasySetS3TX12(__SELECT__);\
        __DRV_URT3_EasySetS3BRT(__SELECT__);\
        __DRV_URT3_EasySetS3BRC(__SELECT__);\
        __DRV_URT3_EasySetS3TR_Start(__SELECT__);\
     ;)

/**
*******************************************************************************
* @brief        UART3 PinMux Easy Wizard
* @details      Set S3PS0
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
*  @arg\b       UART3_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S3BRG
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_PinMux_Easy_Select(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_PinMux_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT3_EasySetS3PS0(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Serial Reception
* @details      Set REN3
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasyEnableSerialReception(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasyEnableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CON_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(REN3=1):(REN3=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Serial Reception
* @details      Clear REN3
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasyDisableSerialReception(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasyDisableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CON_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(REN3=0):(REN3=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Mode Select
* @details      Set SM33
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetSM33(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetSM33(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CON_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(S3CFG=S3CFG&~(SM33)):(S3CFG=S3CFG&~(SM33)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Mode Select
* @details      Set SM03
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetSM03(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetSM03(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CON_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(SM03=0):(SM03=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Mode Select
* @details      Set SM13
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetSM13(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetSM13(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CON_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(SM13=1):(SM13=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 S3BRG Clock Source
* @details      Set S3TX12
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3TX12(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3TX12(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CFG_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(S3CFG=S3CFG|(S3TX12)):(S3CFG=S3CFG|(S3TX12)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Data Order
* @details      Set S3DOR
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3DOR(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3DOR(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CFG_Page);\
        ((__SELECT__%2)==0?(S3CFG=S3CFG|(S3DOR)):(S3CFG=S3CFG&~(S3DOR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Enhance Baud Rate
* @details      Set S3MOD1
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3MOD1(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3MOD1(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CFG_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(S3CFG=S3CFG|(S3MOD1)):(S3CFG=S3CFG|(S3MOD1)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3  Baud Rate Generator Reload Register
* @details      Write S3BRT
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3BRT(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
///@cond __DRV_URT3_EasySetS3BRT
#define S3BRG_BRGRL_9600_2X_12000000_1T             0xB2        // 0.16%
#define S3BRG_BRGRL_19200_2X_12000000_1T            0xD9        // 0.16%
#define S3BRG_BRGRL_57600_2X_12000000_1T            0xF3        // 0.16%

#define S3BRG_BRGRL_9600_2X_11059200_1T             0xB8        // 0%
#define S3BRG_BRGRL_19200_2X_11059200_1T            0xDC        // 0%
#define S3BRG_BRGRL_57600_2X_11059200_1T            0xF4        // 0%
#define S3BRG_BRGRL_115200_2X_11059200_1T           0xFA        // 0%

#define S3BRG_BRGRL_9600_2X_24000000_1T             0x64        // 0.16%
#define S3BRG_BRGRL_19200_2X_24000000_1T            0xB2        // 0.16%
#define S3BRG_BRGRL_57600_2X_24000000_1T            0xE6        // 0.16%
#define S3BRG_BRGRL_115200_2X_24000000_1T           0xF3        // 0.16%

#define S3BRG_BRGRL_9600_2X_22118400_1T             0x70        // 0%
#define S3BRG_BRGRL_19200_2X_22118400_1T            0xB8        // 0%
#define S3BRG_BRGRL_57600_2X_22118400_1T            0xE8        // 0%
#define S3BRG_BRGRL_115200_2X_22118400_1T           0xF4        // 0%

#define S3BRG_BRGRL_9600_2X_29491200_1T             0x40        // 0%
#define S3BRG_BRGRL_19200_2X_29491200_1T            0xA0        // 0%
#define S3BRG_BRGRL_57600_2X_29491200_1T            0xE0        // 0%
#define S3BRG_BRGRL_115200_2X_29491200_1T           0xF0        // 0%

#define S3BRG_BRGRL_9600_2X_33177600_1T             0x28        // 0%
#define S3BRG_BRGRL_19200_2X_33177600_1T            0x94        // 0%
#define S3BRG_BRGRL_57600_2X_33177600_1T            0xDC        // 0%
#define S3BRG_BRGRL_115200_2X_33177600_1T           0xEE        // 0%

#define S3BRG_BRGRL_9600_2X_32000000_1T             0x30        // 0.16%
#define S3BRG_BRGRL_19200_2X_32000000_1T            0x98        // 0.16%
#define S3BRG_BRGRL_57600_2X_32000000_1T            0xDE        // 2.21%
#define S3BRG_BRGRL_115200_2X_32000000_1T           0xEF        // 2.21%

#define S3BRG_BRGRL_9600_2X_36000000_1T             0x16        // 0.16%
#define S3BRG_BRGRL_19200_2X_36000000_1T            0x8B        // 0.16%
#define S3BRG_BRGRL_57600_2X_36000000_1T            0xD9        // 0.16%
#define S3BRG_BRGRL_115200_2X_36000000_1T           0xEC        // -2.3%

#define S3BRG_BRGRL_19200_2X_44236800_1T            0x70        // 0%
#define S3BRG_BRGRL_57600_2X_44236800_1T            0xD0        // 0%
#define S3BRG_BRGRL_115200_2X_44236800_1T           0xE8        // 0%

#define S3BRG_BRGRL_19200_2X_48000000_1T            0x64        // 0.16%
#define S3BRG_BRGRL_57600_2X_48000000_1T            0xCC        // 0.16%
#define S3BRG_BRGRL_115200_2X_48000000_1T           0xE6        // 0.16%
///@endcond

#define __DRV_URT3_EasySetS3BRT(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3BRT_Page);\
        ((__SELECT__/2)==0?(S3BRT=S3BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S3BRT=S3BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S3BRT=S3BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S3BRT=S3BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S3BRT=S3BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S3BRT=S3BRG_BRGRL_19200_2X_11059200_1T):\
        (__SELECT__/2)==6?(S3BRT=S3BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S3BRT=S3BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S3BRT=S3BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S3BRT=S3BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S3BRT=S3BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S3BRT=S3BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S3BRT=S3BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S3BRT=S3BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S3BRT=S3BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S3BRT=S3BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S3BRT=S3BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S3BRT=S3BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S3BRT=S3BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S3BRT=S3BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S3BRT=S3BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S3BRT=S3BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S3BRT=S3BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S3BRT=S3BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S3BRT=S3BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S3BRT=S3BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S3BRT=S3BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S3BRT=S3BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S3BRT=S3BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S3BRT=S3BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S3BRT=S3BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S3BRT=S3BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S3BRT=S3BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S3BRT=S3BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S3BRT=S3BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S3BRT=S3BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S3BRT=S3BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3  Baud Rate Generator Reload Register
* @details      Write S3BRC
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3BRC(UART3_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT3_EasySetS3BRC(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3BRC_Page);\
        ((__SELECT__/2)==0?(S3BRC=S3BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S3BRC=S3BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S3BRC=S3BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S3BRC=S3BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S3BRC=S3BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S3BRC=S3BRG_BRGRL_19200_2X_11059200_1T):\
        (__SELECT__/2)==6?(S3BRC=S3BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S3BRC=S3BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S3BRC=S3BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S3BRC=S3BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S3BRC=S3BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S3BRC=S3BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S3BRC=S3BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S3BRC=S3BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S3BRC=S3BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S3BRC=S3BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S3BRC=S3BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S3BRC=S3BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S3BRC=S3BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S3BRC=S3BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S3BRC=S3BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S3BRC=S3BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S3BRC=S3BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S3BRC=S3BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S3BRC=S3BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S3BRC=S3BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S3BRC=S3BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S3BRC=S3BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S3BRC=S3BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S3BRC=S3BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S3BRC=S3BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S3BRC=S3BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S3BRC=S3BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S3BRC=S3BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S3BRC=S3BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S3BRC=S3BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S3BRC=S3BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
     ;)
/**
*******************************************************************************
* @brief        UART3 S3BRG Operation Enable
* @details      Set S3TR
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3TR_Start(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3TR_Start(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CFG_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(S3CFG=S3CFG|(S3TR)):(S3CFG=S3CFG|(S3TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 S3BRG Operation Disable
* @details      Set S3TR
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3TR_Stop(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3TR_Stop(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S3CFG_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(S3CFG=S3CFG&~(S3TR)):(S3CFG=S3CFG&~(S3TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART3 Pin Config
* @details      Set S3PS0
* @param[in]    __SELECT__ :
*  @arg\b       UART3_SELECT0~UART3_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT3_EasySetS3PS0(UART3_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT3_EasySetS3PS0(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR13_Page);\
        ((__SELECT__^UART3_SELECT0)==0?(AUXR13=AUXR13&~(S3PS0)):(AUXR13=AUXR13&~(S3PS0)));\
        __DRV_SFR_PageIndex(0);\
    ;)
#endif  //MG82F6D64_UART3_MID_H



