/**
 ******************************************************************************
 *
 * @file        MG82F6D64_UART2_MID.h
 *
 * @brief       This is the C code format driver file.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V1.03
 * @date        2024/03/07
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2024 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *          The Demo software is provided "AS IS"  without any warranty, either
 *          expressed or implied, including, but not limited to, the implied warranties
 *          of merchantability and fitness for a particular purpose.  The author will
 *          not be liable for any special, incidental, consequential or indirect
 *          damages due to loss of data or any other reason.
 *          These statements agree with the world wide and local dictated laws about
 *          authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#ifndef MG82F6D64_UART2_MID_H
#define MG82F6D64_UART2_MID_H




///@cond __DRV_URT2_Easy_Wizard_Init

typedef enum
    {
        UART2_SELECT0,
        UART2_SELECT1,
        UART2_SELECT2,
        UART2_SELECT3,
        UART2_SELECT4,
        UART2_SELECT5,
        UART2_SELECT6,
        UART2_SELECT7,
        UART2_SELECT8,
        UART2_SELECT9,
        UART2_SELECT10,
        UART2_SELECT11,
        UART2_SELECT12,
        UART2_SELECT13,
        UART2_SELECT14,
        UART2_SELECT15,
        UART2_SELECT16,
        UART2_SELECT17,
        UART2_SELECT18,
        UART2_SELECT19,
        UART2_SELECT20,
        UART2_SELECT21,
        UART2_SELECT22,
        UART2_SELECT23,
        UART2_SELECT24,
        UART2_SELECT25,
        UART2_SELECT26,
        UART2_SELECT27,
        UART2_SELECT28,
        UART2_SELECT29,
        UART2_SELECT30,
        UART2_SELECT31,
        UART2_SELECT32,
        UART2_SELECT33,
        UART2_SELECT34,
        UART2_SELECT35,
        UART2_SELECT36,
        UART2_SELECT37,
        UART2_SELECT38,
        UART2_SELECT39,
        UART2_SELECT40,
        UART2_SELECT41,
        UART2_SELECT42,
        UART2_SELECT43,
        UART2_SELECT44,
        UART2_SELECT45,
        UART2_SELECT46,
        UART2_SELECT47,
        UART2_SELECT48,
        UART2_SELECT49,
        UART2_SELECT50,
        UART2_SELECT51,
        UART2_SELECT52,
        UART2_SELECT53,
        UART2_SELECT54,
        UART2_SELECT55,
        UART2_SELECT56,
        UART2_SELECT57,
        UART2_SELECT58,
        UART2_SELECT59,
        UART2_SELECT60,
        UART2_SELECT61,
        UART2_SELECT62,
        UART2_SELECT63,
        UART2_SELECT64,
        UART2_SELECT65,
        UART2_SELECT66,
        UART2_SELECT67,
        UART2_SELECT68,
        UART2_SELECT69,
        UART2_SELECT70,
        UART2_SELECT71,
        UART2_SELECT72,
        UART2_SELECT73 = 73
    } UART2_SELECT;

///@endcond




/**
*******************************************************************************
* @brief        UART2 Easy Wizard
* @details      Set SM32 SM02 SM12 S2DOR S2MOD1
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_Mode_Easy_Select(UART2_SELECT0)
* @endcode
*******************************************************************************
*/

#define __DRV_URT2_Mode_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT2_EasySetSM32(__SELECT__);\
        __DRV_URT2_EasySetSM02(__SELECT__);\
        __DRV_URT2_EasySetSM12(__SELECT__);\
        __DRV_URT2_EasySetS2DOR(__SELECT__);\
        __DRV_URT2_EasySetS2MOD1(__SELECT__);\
    ;)

/**
*******************************************************************************
* @brief        UART2 Easy Wizard
* @details      Set S2TR S2BRT S2BRC
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_BaudRate_Easy_Select(UART2_SELECT0)
* @endcode
*******************************************************************************
*/


#define __DRV_URT2_BaudRate_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT2_EasySetS2TR_Stop(__SELECT__);\
        __DRV_URT2_EasySetS2TX12(__SELECT__);\
        __DRV_URT2_EasySetS2BRT(__SELECT__);\
        __DRV_URT2_EasySetS2BRC(__SELECT__);\
        __DRV_URT2_EasySetS2TR_Start(__SELECT__);\
     ;)

/**
*******************************************************************************
* @brief        UART2 PinMux Easy Wizard
* @details      Set S2PS0
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0 : 9600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT1 : 9600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT2 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT3 : 19200 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT4 : 57600 12MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT5 : 57600 12MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT6 : 115200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT7 : 115200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT8 : 57600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT9 : 57600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT10 : 19200 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT11 : 19200 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT12 : 9600 11.0592MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT13 : 9600 11.0592MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT14 : 9600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT15 : 9600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT16 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT17 : 19200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT18 : 57600 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT19 : 57600 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT20 : 115200 24MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT21 : 115200 24MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT22 : 115200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT23 : 115200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT24 : 57600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT25 : 57600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT26 : 19200 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT27 : 19200 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT28 : 9600 22.1184MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT29 : 9600 22.1184MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT30 : 9600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT31 : 9600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT32 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT33 : 19200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT34 : 57600 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT35 : 57600 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT36 : 115200 29.4912MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT37 : 115200 29.4912MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT38 : 115200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT39 : 115200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT40 : 57600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT41 : 57600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT42 : 19200 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT43 : 19200 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT44 : 9600 33.1776MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT45 : 9600 33.1776MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT46 : 9600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT47 : 9600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT48 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT49 : 19200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT50 : 57600 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT51 : 57600 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT52 : 115200 32MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT53 : 115200 32MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT54 : 115200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT55 : 115200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT56 : 57600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT57 : 57600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT58 : 19200 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT59 : 19200 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT60 : 9600 36MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT61 : 9600 36MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT62 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT63 : 19200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT64 : 57600 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT65 : 57600 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT66 : 115200 44.2368MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT67 : 115200 44.2368MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT68 : 115200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT69 : 115200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT70 : 57600 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT71 : 57600 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT72 : 19200 48MHz 8bit LSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
*  @arg\b       UART2_SELECT73 : 19200 48MHz 8bit MSB Rx p34 Tx p35 Tx Rx both SYSCLK/1 double baud rate S2BRG
* @note         None
* @par          Example
* @code
                __DRV_URT2_PinMux_Easy_Select(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_PinMux_Easy_Select(__SELECT__)\
    MWT(\
        __DRV_URT2_EasySetS2PS0(__SELECT__);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Serial Reception
* @details      Set REN2
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasyEnableSerialReception(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasyEnableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CON_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(REN2=1):(REN2=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Serial Reception
* @details      Clear REN2
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73

* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasyDisableSerialReception(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasyDisableSerialReception(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CON_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(REN2=0):(REN2=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Mode Select
* @details      Set SM32
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetSM32(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetSM32(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(S2CFG=S2CFG&~(SM32)):(S2CFG=S2CFG&~(SM32)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Mode Select
* @details      Set SM02
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetSM02(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetSM02(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CON_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(SM02=0):(SM02=0));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Mode Select
* @details      Set SM12
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetSM12(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetSM12(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CON_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(SM12=1):(SM12=1));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 S2BRG Clock Source
* @details      Set S2TX12
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2TX12(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2TX12(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(S2CFG=S2CFG|(S2TX12)):(S2CFG=S2CFG|(S2TX12)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Data Order
* @details      Set S2DOR
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2DOR(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2DOR(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__%2)==0?(S2CFG=S2CFG|(S2DOR)):(S2CFG=S2CFG&~(S2DOR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Enhance Baud Rate
* @details      Set S2MOD1
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2MOD1(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2MOD1(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(S2CFG=S2CFG|(S2MOD1)):(S2CFG=S2CFG|(S2MOD1)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2  Baud Rate Generator Reload Register
* @details      Write S2BRT
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2BRT(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
///@cond __DRV_URT2_EasySetS2BRT
#define S2BRG_BRGRL_9600_2X_12000000_1T             0xB2        // 0.16%
#define S2BRG_BRGRL_19200_2X_12000000_1T            0xD9        // 0.16%
#define S2BRG_BRGRL_57600_2X_12000000_1T            0xF3        // 0.16%

#define S2BRG_BRGRL_9600_2X_11059200_1T             0xB8        // 0%
#define S2BRG_BRGRL_19200_2X_11059200_1T            0xDC        // 0%
#define S2BRG_BRGRL_57600_2X_11059200_1T            0xF4        // 0%
#define S2BRG_BRGRL_115200_2X_11059200_1T           0xFA        // 0%

#define S2BRG_BRGRL_9600_2X_24000000_1T             0x64        // 0.16%
#define S2BRG_BRGRL_19200_2X_24000000_1T            0xB2        // 0.16%
#define S2BRG_BRGRL_57600_2X_24000000_1T            0xE6        // 0.16%
#define S2BRG_BRGRL_115200_2X_24000000_1T           0xF3        // 0.16%

#define S2BRG_BRGRL_9600_2X_22118400_1T             0x70        // 0%
#define S2BRG_BRGRL_19200_2X_22118400_1T            0xB8        // 0%
#define S2BRG_BRGRL_57600_2X_22118400_1T            0xE8        // 0%
#define S2BRG_BRGRL_115200_2X_22118400_1T           0xF4        // 0%

#define S2BRG_BRGRL_9600_2X_29491200_1T             0x40        // 0%
#define S2BRG_BRGRL_19200_2X_29491200_1T            0xA0        // 0%
#define S2BRG_BRGRL_57600_2X_29491200_1T            0xE0        // 0%
#define S2BRG_BRGRL_115200_2X_29491200_1T           0xF0        // 0%

#define S2BRG_BRGRL_9600_2X_33177600_1T             0x28        // 0%
#define S2BRG_BRGRL_19200_2X_33177600_1T            0x94        // 0%
#define S2BRG_BRGRL_57600_2X_33177600_1T            0xDC        // 0%
#define S2BRG_BRGRL_115200_2X_33177600_1T           0xEE        // 0%

#define S2BRG_BRGRL_9600_2X_32000000_1T             0x30        // 0.16%
#define S2BRG_BRGRL_19200_2X_32000000_1T            0x98        // 0.16%
#define S2BRG_BRGRL_57600_2X_32000000_1T            0xDE        // 2.21%
#define S2BRG_BRGRL_115200_2X_32000000_1T           0xEF        // 2.21%

#define S2BRG_BRGRL_9600_2X_36000000_1T             0x16        // 0.16%
#define S2BRG_BRGRL_19200_2X_36000000_1T            0x8B        // 0.16%
#define S2BRG_BRGRL_57600_2X_36000000_1T            0xD9        // 0.16%
#define S2BRG_BRGRL_115200_2X_36000000_1T           0xEC        // -2.3%

#define S2BRG_BRGRL_19200_2X_44236800_1T            0x70        // 0%
#define S2BRG_BRGRL_57600_2X_44236800_1T            0xD0        // 0%
#define S2BRG_BRGRL_115200_2X_44236800_1T           0xE8        // 0%

#define S2BRG_BRGRL_19200_2X_48000000_1T            0x64        // 0.16%
#define S2BRG_BRGRL_57600_2X_48000000_1T            0xCC        // 0.16%
#define S2BRG_BRGRL_115200_2X_48000000_1T           0xE6        // 0.16%

///@endcond

#define __DRV_URT2_EasySetS2BRT(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2BRT_Page);\
        ((__SELECT__/2)==0?(S2BRT=S2BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S2BRT=S2BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S2BRT=S2BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S2BRT=S2BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S2BRT=S2BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S2BRT=S2BRG_BRGRL_19200_2X_11059200_1T):\
        (__SELECT__/2)==6?(S2BRT=S2BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S2BRT=S2BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S2BRT=S2BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S2BRT=S2BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S2BRT=S2BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S2BRT=S2BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S2BRT=S2BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S2BRT=S2BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S2BRT=S2BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S2BRT=S2BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S2BRT=S2BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S2BRT=S2BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S2BRT=S2BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S2BRT=S2BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S2BRT=S2BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S2BRT=S2BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S2BRT=S2BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S2BRT=S2BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S2BRT=S2BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S2BRT=S2BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S2BRT=S2BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S2BRT=S2BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S2BRT=S2BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S2BRT=S2BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S2BRT=S2BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S2BRT=S2BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S2BRT=S2BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S2BRT=S2BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S2BRT=S2BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S2BRT=S2BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S2BRT=S2BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2  Baud Rate Generator Reload Register
* @details      Write S2BRC
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2BRC(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2BRC(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2BRC_Page);\
        ((__SELECT__/2)==0?(S2BRC=S2BRG_BRGRL_9600_2X_12000000_1T):\
        (__SELECT__/2)==1?(S2BRC=S2BRG_BRGRL_19200_2X_12000000_1T):\
        (__SELECT__/2)==2?(S2BRC=S2BRG_BRGRL_57600_2X_12000000_1T):\
        (__SELECT__/2)==3?(S2BRC=S2BRG_BRGRL_115200_2X_11059200_1T):\
        (__SELECT__/2)==4?(S2BRC=S2BRG_BRGRL_57600_2X_11059200_1T ):\
        (__SELECT__/2)==5?(S2BRC=S2BRG_BRGRL_57600_2X_11059200_1T):\
        (__SELECT__/2)==6?(S2BRC=S2BRG_BRGRL_9600_2X_11059200_1T):\
        (__SELECT__/2)==7?(S2BRC=S2BRG_BRGRL_9600_2X_24000000_1T):\
        (__SELECT__/2)==8?(S2BRC=S2BRG_BRGRL_19200_2X_24000000_1T):\
        (__SELECT__/2)==9?(S2BRC=S2BRG_BRGRL_57600_2X_24000000_1T):\
        (__SELECT__/2)==10?(S2BRC=S2BRG_BRGRL_115200_2X_24000000_1T):\
        (__SELECT__/2)==11?(S2BRC=S2BRG_BRGRL_115200_2X_22118400_1T):\
        (__SELECT__/2)==12?(S2BRC=S2BRG_BRGRL_57600_2X_22118400_1T):\
        (__SELECT__/2)==13?(S2BRC=S2BRG_BRGRL_19200_2X_22118400_1T):\
        (__SELECT__/2)==14?(S2BRC=S2BRG_BRGRL_9600_2X_22118400_1T):\
        (__SELECT__/2)==15?(S2BRC=S2BRG_BRGRL_9600_2X_29491200_1T):\
        (__SELECT__/2)==16?(S2BRC=S2BRG_BRGRL_19200_2X_29491200_1T):\
        (__SELECT__/2)==17?(S2BRC=S2BRG_BRGRL_57600_2X_29491200_1T):\
        (__SELECT__/2)==18?(S2BRC=S2BRG_BRGRL_115200_2X_29491200_1T):\
        (__SELECT__/2)==19?(S2BRC=S2BRG_BRGRL_115200_2X_33177600_1T):\
        (__SELECT__/2)==20?(S2BRC=S2BRG_BRGRL_57600_2X_33177600_1T):\
        (__SELECT__/2)==21?(S2BRC=S2BRG_BRGRL_19200_2X_33177600_1T):\
        (__SELECT__/2)==22?(S2BRC=S2BRG_BRGRL_9600_2X_33177600_1T):\
        (__SELECT__/2)==23?(S2BRC=S2BRG_BRGRL_9600_2X_32000000_1T):\
        (__SELECT__/2)==24?(S2BRC=S2BRG_BRGRL_19200_2X_32000000_1T):\
        (__SELECT__/2)==25?(S2BRC=S2BRG_BRGRL_57600_2X_32000000_1T):\
        (__SELECT__/2)==26?(S2BRC=S2BRG_BRGRL_115200_2X_32000000_1T):\
        (__SELECT__/2)==27?(S2BRC=S2BRG_BRGRL_115200_2X_36000000_1T):\
        (__SELECT__/2)==28?(S2BRC=S2BRG_BRGRL_57600_2X_36000000_1T):\
        (__SELECT__/2)==29?(S2BRC=S2BRG_BRGRL_19200_2X_36000000_1T):\
        (__SELECT__/2)==30?(S2BRC=S2BRG_BRGRL_9600_2X_36000000_1T):\
        (__SELECT__/2)==31?(S2BRC=S2BRG_BRGRL_19200_2X_44236800_1T):\
        (__SELECT__/2)==32?(S2BRC=S2BRG_BRGRL_57600_2X_44236800_1T):\
        (__SELECT__/2)==33?(S2BRC=S2BRG_BRGRL_115200_2X_44236800_1T):\
        (__SELECT__/2)==34?(S2BRC=S2BRG_BRGRL_115200_2X_48000000_1T):\
        (__SELECT__/2)==35?(S2BRC=S2BRG_BRGRL_57600_2X_48000000_1T):\
        (__SELECT__/2)==36?(S2BRC=S2BRG_BRGRL_19200_2X_48000000_1T):_nop_());\
        __DRV_SFR_PageIndex(0);\
     ;)
/**
*******************************************************************************
* @brief        UART2 S2BRG Operation Enable
* @details      Set S2TR
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2TR_Start(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2TR_Start(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(S2CFG=S2CFG|(S2TR)):(S2CFG=S2CFG|(S2TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 S2BRG Operation Disable
* @details      Set S2TR
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2TR_Stop(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2TR_Stop(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(S2CFG_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(S2CFG=S2CFG&~(S2TR)):(S2CFG=S2CFG&~(S2TR)));\
        __DRV_SFR_PageIndex(0);\
    ;)
/**
*******************************************************************************
* @brief        UART2 Pin Config
* @details      Set S2PS0
* @param[in]    __SELECT__ :
*  @arg\b       UART2_SELECT0~UART2_SELECT73
* @return       None
* @note         None
* @par          Example
* @code
                __DRV_URT2_EasySetS2PS0(UART2_SELECT0)
* @endcode
*******************************************************************************
*/
#define __DRV_URT2_EasySetS2PS0(__SELECT__)\
    MWT(\
        __DRV_SFR_PageIndex(AUXR13_Page);\
        ((__SELECT__^UART2_SELECT0)==0?(AUXR13=AUXR13&~(S2PS0)):(AUXR13=AUXR13&~(S2PS0)));\
        __DRV_SFR_PageIndex(0);\
    ;)
#endif  //MG82F6D64_UART2_MID_H



